/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import java.util.Hashtable;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthenticateUserHelper {
    static final long serialVersionUID = 823342336024802080L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Subject authenticateUser(AuthenticationService authenticationService, String userName, String jaasEntryName) throws AuthenticationException {
        return this.authenticateUser(authenticationService, userName, jaasEntryName, null);
    }

    public Subject authenticateUser(AuthenticationService authenticationService, String userName, String jaasEntryName, String customCacheKey) throws AuthenticationException {
        this.validateInput(authenticationService, userName);
        if (jaasEntryName == null || jaasEntryName.trim().isEmpty()) {
            jaasEntryName = "system.DEFAULT";
        }
        Subject partialSubject = this.createPartialSubject(userName, authenticationService, customCacheKey);
        return authenticationService.authenticate(jaasEntryName, partialSubject);
    }

    protected Subject createPartialSubject(String username, AuthenticationService authenticationService, String customCacheKey) {
        Subject partialSubject = null;
        partialSubject = new Subject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("com.ibm.wsspi.security.cred.userId", username);
        if (!authenticationService.isAllowHashTableLoginWithIdOnly().booleanValue()) {
            hashtable.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
        }
        if (customCacheKey != null) {
            hashtable.put("com.ibm.wsspi.security.cred.cacheKey", customCacheKey);
        }
        partialSubject.getPublicCredentials().add(hashtable);
        return partialSubject;
    }

    private void validateInput(AuthenticationService authenticationService, String username) throws AuthenticationException {
        if (authenticationService == null) {
            throw new AuthenticationException("authenticationService cannot be null.");
        }
        if (username == null) {
            throw new AuthenticationException("username cannot be null.");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.helper.AuthenticateUserHelper", AuthenticateUserHelper.class, null, null);
    }
}

