/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

public class BootstrapDefaults {
    static final String MANIFEST_KERNEL = "WebSphere-DefaultKernel";
    static final String MANIFEST_LOG_PROVIDER = "WebSphere-DefaultLogProvider";
    static final String MANIFEST_OS_EXTENSION = "WebSphere-DefaultExtension-";
    static final String BOOTPROP_KERNEL = "websphere.kernel";
    static final String BOOTPROP_LOG_PROVIDER = "websphere.log.provider";
    static final String BOOTPROP_OS_EXTENSIONS = "websphere.os.extension";
    private final Properties defaults;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BootstrapDefaults(BootstrapConfig bootConfig) throws IOException {
        Properties defaultProps = null;
        try (FileInputStream fis = new FileInputStream(new File(bootConfig.getInstallRoot(), "lib/platform/defaults"));){
            defaultProps = new Properties();
            defaultProps.load(fis);
        }
        String normalizedOsName = BootstrapDefaults.getNormalizedOperatingSystemName(bootConfig.get("os.name"));
        File osDefaults = new File(bootConfig.getInstallRoot(), "lib/platform/defaults-" + normalizedOsName);
        if (osDefaults.exists() && osDefaults.isFile()) {
            fis = new FileInputStream(osDefaults);
            try {
                this.defaults = new Properties(defaultProps);
                this.defaults.load(fis);
            }
            finally {
                fis.close();
            }
        } else {
            this.defaults = defaultProps;
        }
    }

    public String getKernelDefinition(BootstrapConfig bootProps) {
        String kernelDef = bootProps.get(BOOTPROP_KERNEL);
        if (kernelDef == null) {
            kernelDef = this.defaults.getProperty(MANIFEST_KERNEL);
        }
        if (kernelDef != null) {
            bootProps.put(BOOTPROP_KERNEL, kernelDef);
        }
        return kernelDef;
    }

    public String getLogProviderDefinition(BootstrapConfig bootProps) {
        String logProvider = bootProps.get(BOOTPROP_LOG_PROVIDER);
        if (logProvider == null) {
            logProvider = this.defaults.getProperty(MANIFEST_LOG_PROVIDER);
        }
        if (logProvider != null) {
            bootProps.put(BOOTPROP_LOG_PROVIDER, logProvider);
        }
        return logProvider;
    }

    public String getOSExtensionDefinition(BootstrapConfig bootProps) {
        String osExtension = bootProps.get(BOOTPROP_OS_EXTENSIONS);
        if (osExtension == null) {
            String normalizedName = BootstrapDefaults.getNormalizedOperatingSystemName(bootProps.get("os.name"));
            osExtension = this.defaults.getProperty(MANIFEST_OS_EXTENSION + normalizedName);
        }
        if (osExtension != null) {
            bootProps.put(BOOTPROP_OS_EXTENSIONS, osExtension);
        }
        return osExtension;
    }

    static String getNormalizedOperatingSystemName(String osName) {
        String name = osName.toLowerCase(Locale.ENGLISH);
        name = name.replaceAll("[^0-9a-zA-Z_-]", "");
        return name;
    }
}

