/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.FrameSettings;
import java.util.Base64;

public class H2ConnectionSettings {
    private int headerTableSize = 4096;
    private int enablePush = 1;
    private int maxConcurrentStreams = 100;
    private int initialWindowSize = 65535;
    public int maxFrameSize = 16384;
    private int maxHeaderListSize = -1;

    protected void processUpgradeHeaderSettings(String settings) throws Http2Exception {
        byte[] decoded;
        if (settings != null && (decoded = H2ConnectionSettings.decode(settings)) != null) {
            FrameSettings settingsFrame = new FrameSettings(0, decoded.length, 0, false, Frame.FrameDirection.READ);
            settingsFrame.processPayload(decoded);
            this.updateSettings(settingsFrame);
        }
    }

    public void updateSettings(FrameSettings settings) {
        if (settings.getHeaderTableSize() != -1) {
            this.headerTableSize = settings.getHeaderTableSize();
        }
        if (settings.getEnablePush() != -1) {
            this.enablePush = settings.getEnablePush();
        }
        if (settings.getMaxConcurrentStreams() != -1) {
            this.maxConcurrentStreams = settings.getMaxConcurrentStreams();
        }
        if (settings.getInitialWindowSize() != -1) {
            this.initialWindowSize = settings.getInitialWindowSize();
        }
        if (settings.getMaxFrameSize() != -1) {
            this.maxFrameSize = settings.getMaxFrameSize();
        }
        if (settings.getMaxHeaderListSize() != -1) {
            this.maxHeaderListSize = settings.getMaxHeaderListSize();
        }
    }

    public int getHeaderTableSize() {
        return this.headerTableSize;
    }

    public void setHeaderTableSize(int headerTableSize) {
        this.headerTableSize = headerTableSize;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public void setMaxHeaderListSize(int maxHeaderListSize) {
        this.maxHeaderListSize = maxHeaderListSize;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setEnablePush(int enablePush) {
        this.enablePush = enablePush;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public int getEnablePush() {
        return this.enablePush;
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    @Trivial
    private static byte[] decode(String str) {
        try {
            return Base64.getDecoder().decode(str);
        }
        catch (Exception e) {
            return null;
        }
    }
}

