/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.location.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class FileLocator {
    static final long serialVersionUID = 1273789794797694593L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private FileLocator() {
        throw new AssertionError((Object)"This class is not instantiable");
    }

    public static File findFileInNamedPath(String name, Collection<String> pathNameList) {
        if (name == null || pathNameList == null || pathNameList.size() == 0) {
            return null;
        }
        for (String path : pathNameList) {
            File result;
            if (path == null || path.length() == 0 || (result = FileLocator.getFile(new File(path), name)) == null) continue;
            return result;
        }
        return null;
    }

    public static File findFileInFilePath(String name, Collection<File> pathList) {
        if (name == null || pathList == null || pathList.size() == 0) {
            return null;
        }
        for (File dirPath : pathList) {
            File result = FileLocator.getFile(dirPath, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static File findLowerCaseFileInFilePath(String name, Collection<File> pathList) {
        if (name == null || pathList == null || pathList.size() == 0) {
            return null;
        }
        for (File dirPath : pathList) {
            File result = FileLocator.getFile(dirPath, name);
            if (result == null) continue;
            return result;
        }
        for (File dirPath : pathList) {
            LowerCaseFileName filter;
            File[] fileList = dirPath.listFiles(filter = new LowerCaseFileName(name));
            if (fileList == null || fileList.length < 1) continue;
            return fileList[0];
        }
        return null;
    }

    private static File getFile(File dirPath, String name) {
        File myFile;
        if (dirPath != null && dirPath.isDirectory() && (myFile = new File(dirPath, name)).exists()) {
            return myFile;
        }
        return null;
    }

    public static File matchFileInNamedPath(String regex, Collection<String> pathNameList) {
        if (regex == null || pathNameList == null || pathNameList.size() == 0) {
            return null;
        }
        for (String currentPath : pathNameList) {
            File result;
            if (currentPath == null || currentPath.length() == 0 || (result = FileLocator.matchFile(new File(currentPath), regex)) == null) continue;
            return result;
        }
        return null;
    }

    public static File matchFileInFilePath(String regex, Collection<File> pathList) {
        if (regex == null || pathList == null || pathList.size() == 0) {
            return null;
        }
        for (File dirPath : pathList) {
            File result = FileLocator.matchFile(dirPath, regex);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static File matchFile(File dirPath, String regex) {
        if (dirPath != null && dirPath.isDirectory()) {
            List<File> fileList = FileLocator.getMatchingFiles(dirPath, regex);
            for (File currentFile : fileList) {
                if (!currentFile.exists()) continue;
                return currentFile;
            }
        }
        return null;
    }

    public static List<File> getMatchingFiles(String root, String filterExpr) {
        if (root == null) {
            return Collections.emptyList();
        }
        File file = new File(root);
        return FileLocator.getMatchingFiles(file, filterExpr);
    }

    public static List<File> getMatchingFiles(File root, String filterExpr) {
        if (root == null) {
            return Collections.emptyList();
        }
        FileFilter filter = filterExpr == null ? new FilesOnly() : new FilesOnlyFilter(filterExpr);
        File[] fileList = root.listFiles(filter);
        if (fileList == null) {
            return Collections.emptyList();
        }
        if (fileList.length > 1) {
            Arrays.sort(fileList, new SortByFileName());
        }
        return Arrays.asList(fileList);
    }

    public static List<String> getMatchingFileNames(String root, String filterExpr, boolean fullPath) {
        List<File> fileList = FileLocator.getMatchingFiles(root, filterExpr);
        ArrayList<String> list = new ArrayList<String>(fileList.size());
        for (File f : fileList) {
            if (fullPath) {
                list.add(f.getAbsolutePath());
                continue;
            }
            list.add(f.getName());
        }
        return list;
    }

    public static List<String> getDirectoryNames(String root, boolean fullPath) {
        List<File> fileList = FileLocator.getDirectoriesByName(root);
        ArrayList<String> list = new ArrayList<String>(fileList.size());
        for (File f : fileList) {
            String name = fullPath ? f.getAbsolutePath() : f.getName();
            list.add(name);
        }
        return list;
    }

    public static List<File> getDirectoriesByName(String root) {
        if (root == null || root.length() == 0) {
            return Collections.emptyList();
        }
        return FileLocator.getDirectories(new File(root));
    }

    public static List<File> getDirectories(File root) {
        if (root == null) {
            return Collections.emptyList();
        }
        DirsOnlyFilter filter = new DirsOnlyFilter();
        File[] fileList = root.listFiles(filter);
        if (fileList == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(fileList);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.location.internal.FileLocator", FileLocator.class, (String)"locationService", (String)"com.ibm.ws.kernel.service.location.internal.resources.LocServiceMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class SortByFileName
    implements Comparator<File> {
        static final long serialVersionUID = -1221801918461260077L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SortByFileName() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.location.internal.FileLocator$SortByFileName", SortByFileName.class, (String)"locationService", (String)"com.ibm.ws.kernel.service.location.internal.resources.LocServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class FilesOnlyFilter
    implements FileFilter {
        String filterExpr;
        static final long serialVersionUID = 1610996961518814746L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FilesOnlyFilter(String filterExpr) {
            this.filterExpr = filterExpr;
        }

        @Override
        public boolean accept(File file) {
            String name;
            return file != null && file.isFile() && (name = file.getName()).matches(this.filterExpr);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.location.internal.FileLocator$FilesOnlyFilter", FilesOnlyFilter.class, (String)"locationService", (String)"com.ibm.ws.kernel.service.location.internal.resources.LocServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class LowerCaseFileName
    implements FileFilter {
        String name;
        static final long serialVersionUID = 2420075517551288890L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public LowerCaseFileName(String name) {
            this.name = name.toLowerCase();
        }

        @Override
        public boolean accept(File file) {
            String fileName;
            return file != null && file.isFile() && this.name.equals(fileName = file.getName().toLowerCase());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.location.internal.FileLocator$LowerCaseFileName", LowerCaseFileName.class, (String)"locationService", (String)"com.ibm.ws.kernel.service.location.internal.resources.LocServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class FilesOnly
    implements FileFilter {
        static final long serialVersionUID = -8872910716321230301L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        FilesOnly() {
        }

        @Override
        public boolean accept(File file) {
            return file != null && file.isFile();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.location.internal.FileLocator$FilesOnly", FilesOnly.class, (String)"locationService", (String)"com.ibm.ws.kernel.service.location.internal.resources.LocServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class DirsOnlyFilter
    implements FileFilter {
        static final long serialVersionUID = 3945063459115540294L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DirsOnlyFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file != null && file.isDirectory();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.location.internal.FileLocator$DirsOnlyFilter", DirsOnlyFilter.class, (String)"locationService", (String)"com.ibm.ws.kernel.service.location.internal.resources.LocServiceMessages");
        }
    }
}

