/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.encryption;

import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.encryption.AuditCrypto;
import com.ibm.ws.security.audit.encryption.AuditKeyEncryptor;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.audit.AuditDecryptionException;
import com.ibm.wsspi.security.audit.AuditEncrypting;
import com.ibm.wsspi.security.audit.AuditEncryptionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import javax.management.ObjectName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuditEncryptionImpl
implements AuditEncrypting {
    private static final TraceComponent tc = Tr.register(AuditEncryptionImpl.class, null, (String)"com.ibm.ejs.resources.security");
    private final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    static final String KEY_KEYSTORE_SERVICE_REF = "keyStoreService";
    private final AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    String[] ciphers = null;
    AuditCrypto crypto = null;
    Key sharedkey = null;
    String serverName = null;
    int aliasIncrement = 1;
    private static AuditEncryptionImpl ae = null;
    private static String subjectDN = "CN=auditsigner, OU=SWG, O=IBM, C=US";
    private static String keyStoreName = "auditSignerKeyStore_";
    private static String certLabelPrefix = "auditcert";
    private static String CRYPTO_ALGORITHM = "SHA256withRSA";
    private final int signerKeyStoreIncrement = 1;
    private final ObjectName mgmScopeObjName = null;
    AuditKeyEncryptor encryptor = null;
    private String _name = null;
    private String _location = null;
    private String _type = null;
    private String _provider = null;
    private String _password = null;
    private String _alias = null;
    static final long serialVersionUID = 2658694773852775512L;

    /*
     * WARNING - void declaration
     */
    public static AuditEncryptionImpl getInstance(String keyStoreName, String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword, String keyAlias) throws AuditEncryptionException {
        try {
            if (ae == null) {
                ae = new AuditEncryptionImpl(keyStoreName, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, keyAlias);
            }
            return ae;
        }
        catch (AuditEncryptionException auditEncryptionException) {
            void e;
            FFDCFilter.processException((Throwable)auditEncryptionException, (String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl", (String)"84", null, (Object[])new Object[]{keyStoreName, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, keyAlias});
            throw new AuditEncryptionException((Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public AuditEncryptionImpl(String keyStoreName, String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword, String keyAlias) throws AuditEncryptionException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("keyStoreName: " + keyStoreName + " keyStorePath: " + keyStorePath + " keyStoreType: " + keyStoreType + " keyStoreProvider: " + keyStoreProvider + " keyStorePassword: " + keyStorePassword + " keyAlias: " + keyAlias), (Object[])new Object[0]);
        }
        try {
            this.initialize(keyStoreName, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, keyAlias);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl", (String)"99", (Object)this, (Object[])new Object[]{keyStoreName, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, keyAlias});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception initializing AuditEncryptionImpl.", (Object[])new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.AuditEncryptionImpl.constructor", (String)"96", (Object)this);
        }
    }

    public void initialize(String keyStoreName, String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword, String keyAlias) throws AuditEncryptionException {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        if (locationAdmin != null) {
            this.serverName = locationAdmin.getServerName();
        }
        this._name = keyStoreName;
        this._location = keyStorePath;
        this._type = keyStoreType;
        this._provider = keyStoreProvider;
        this._password = keyStorePassword;
        this._alias = keyAlias;
        this.crypto = new AuditCrypto();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("_name: " + this._name + " _location: " + this._location + " _type: " + this._type + " _provider: " + this._provider + " _keyStorePassword: " + this._password + " _alias: " + this._alias), (Object[])new Object[0]);
        }
        long begin_time = 0L;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Initializing audit encryptor at " + new Date(System.currentTimeMillis())), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Key generateSharedKey() throws java.security.KeyException {
        SecretKeySpec sharedKey = null;
        try {
            block8: {
                if (this.crypto != null) {
                    try {
                        sharedKey = new SecretKeySpec(AuditCrypto.generate3DESKey(), 0, 24, "DESede");
                    }
                    catch (Exception exception) {
                        void me;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl", (String)"172", (Object)this, (Object[])new Object[0]);
                        if (!tc.isDebugEnabled()) break block8;
                        Tr.debug((TraceComponent)tc, (String)("me.getMessage: " + me.getMessage()), (Object[])new Object[0]);
                    }
                }
            }
            if (sharedKey != null) {
                return sharedKey;
            }
            throw new KeyException("Key could not be generated.");
        }
        catch (Exception me) {
            void e;
            FFDCFilter.processException((Throwable)me, (String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl", (String)"184", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error generating key.", (Object[])new Object[]{e});
            }
            if (e instanceof java.security.KeyException) {
                throw (java.security.KeyException)e;
            }
            throw new java.security.KeyException(e.getMessage(), (Throwable)e);
        }
    }

    public String generateAliasForSharedKey() {
        String alias = null;
        if (this.serverName != null) {
            alias = this.serverName + "Alias" + new Integer(this.aliasIncrement).toString();
        }
        ++this.aliasIncrement;
        return alias;
    }

    /*
     * WARNING - void declaration
     */
    public X509Certificate retrieveCertificate() throws IOException {
        Object publicKey = null;
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance(this._type, this._provider);
            InputStream is = AuditEncryptionImpl.openKeyStore(this._location);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("successfully opened the keystore at " + this._location), (Object[])new Object[0]);
            }
            ks.load(is, this._password.toCharArray());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("successfully loaded the keystore at " + this._location), (Object[])new Object[0]);
            }
            X509Certificate cert = (X509Certificate)ks.getCertificate(this._alias);
            return cert;
        }
        catch (NoSuchProviderException is) {
            void ne;
            FFDCFilter.processException((Throwable)is, (String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl", (String)"233", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore: no such provider.", (Object[])new Object[]{ne.getMessage()});
            }
            throw new IOException(ne.getMessage());
        }
        catch (MalformedURLException ne) {
            void me;
            FFDCFilter.processException((Throwable)ne, (String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl", (String)"237", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore: malformed URL", (Object[])new Object[]{me.getMessage()});
            }
            throw new IOException(me.getMessage());
        }
        catch (KeyStoreException me) {
            void ke;
            FFDCFilter.processException((Throwable)me, (String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl", (String)"241", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ke.getMessage()});
            }
            throw new IOException(ke.getMessage());
        }
        catch (NoSuchAlgorithmException ke) {
            void ae;
            FFDCFilter.processException((Throwable)ke, (String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl", (String)"245", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore: no such algorithm", (Object[])new Object[]{ae.getMessage()});
            }
            throw new IOException(ae.getMessage());
        }
        catch (CertificateException ae) {
            void ce;
            FFDCFilter.processException((Throwable)ae, (String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl", (String)"249", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting certificate.", (Object[])new Object[]{ce.getMessage()});
            }
            throw new IOException(ce.getMessage());
        }
        catch (IOException ce) {
            void ioe;
            FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl", (String)"253", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ioe.getMessage()});
            }
            throw new IOException(ioe.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Key retrievePublicKey() throws IOException {
        PublicKey publicKey = null;
        try {
            X509Certificate cert = this.retrieveCertificate();
            publicKey = cert.getPublicKey();
            return publicKey;
        }
        catch (MalformedURLException cert) {
            void me;
            FFDCFilter.processException((Throwable)cert, (String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl", (String)"276", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{me.getMessage()});
            }
            throw new IOException(me.getMessage());
        }
        catch (IOException me) {
            void ioe;
            FFDCFilter.processException((Throwable)me, (String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl", (String)"280", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ioe.getMessage()});
            }
            throw new IOException(ioe.getMessage());
        }
    }

    public byte[] encryptSharedKey(Key sharedKey, Key pKey) throws IOException {
        byte[] encryptedSharedKey = null;
        if (sharedKey == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR!!! shared key is null!", (Object[])new Object[0]);
            }
            return null;
        }
        byte[] encodedPublicKey = pKey.getEncoded();
        byte[] encodedSharedKey = sharedKey.getEncoded();
        this.encryptor = new AuditKeyEncryptor(encodedPublicKey);
        encryptedSharedKey = this.encryptor.encrypt(encodedSharedKey);
        return encryptedSharedKey;
    }

    public byte[] decryptSharedKey(byte[] sharedKey, Key pKey) throws IOException {
        byte[] encodedPublicKey;
        byte[] decryptedSharedKey = null;
        if (sharedKey == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR!!! shared key is null!", (Object[])new Object[0]);
            }
            return null;
        }
        if (this.encryptor == null) {
            encodedPublicKey = pKey.getEncoded();
            this.encryptor = new AuditKeyEncryptor(encodedPublicKey);
        }
        encodedPublicKey = pKey.getEncoded();
        decryptedSharedKey = this.encryptor.decrypt(sharedKey);
        return decryptedSharedKey;
    }

    public byte[] encrypt(byte[] data, Key sharedKey) throws AuditEncryptionException {
        if (data == null) {
            Tr.error((TraceComponent)tc, (String)"security.audit.encryption.data.error", (Object[])new Object[0]);
            throw new AuditEncryptionException("Invalid data passed into the encryption algorithm.");
        }
        if (sharedKey == null) {
            Tr.error((TraceComponent)tc, (String)"security.audit.invalid.shared.key.error", (Object[])new Object[0]);
            throw new AuditEncryptionException("An invalid shared key was detected.");
        }
        AuditCrypto ac = new AuditCrypto();
        byte[] encryptedData = AuditCrypto.encrypt(data, sharedKey.getEncoded());
        return encryptedData;
    }

    public byte[] decrypt(byte[] data, Key sharedKey) throws AuditDecryptionException {
        if (data == null) {
            Tr.error((TraceComponent)tc, (String)"security.audit.decryption.data.error", (Object[])new Object[0]);
            throw new AuditDecryptionException("Invalid data passed into the decryption algorithm.");
        }
        if (sharedKey == null) {
            Tr.error((TraceComponent)tc, (String)"security.audit.invalid.shared.key.error", (Object[])new Object[0]);
            throw new AuditDecryptionException("An invalid shared key was detected.");
        }
        AuditCrypto ac = new AuditCrypto();
        byte[] decryptedData = AuditCrypto.decrypt(data, sharedKey.getEncoded());
        return decryptedData;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    protected static InputStream openKeyStore(String fileName) throws MalformedURLException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("openKeyStore" + fileName), (Object[])new Object[0]);
        }
        try {
            OpenKeyStoreAction action = new OpenKeyStoreAction(fileName);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openKeyStore");
            }
            return (InputStream)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException action) {
            void e;
            FFDCFilter.processException((Throwable)action, (String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl", (String)"408", null, (Object[])new Object[]{fileName});
            Exception ex = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ex});
            }
            if (ex instanceof MalformedURLException) {
                throw (MalformedURLException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex.getMessage());
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class OpenKeyStoreAction
    implements PrivilegedExceptionAction {
        private String file = null;
        static final long serialVersionUID = 3336692334718422270L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public OpenKeyStoreAction(String fileName) {
            this.file = fileName;
        }

        @ManualTrace
        public Object run() throws MalformedURLException, IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"OpenKeyStoreAction.run", (Object[])new Object[0]);
            }
            InputStream fis = null;
            URL urlFile = null;
            File kfile = new File(this.file);
            if (kfile.exists() && kfile.length() == 0L) {
                throw new IOException("Keystore file exists, but is empty: " + this.file);
            }
            urlFile = !kfile.exists() ? new URL(this.file) : new URL("file:" + kfile.getCanonicalPath());
            fis = urlFile.openStream();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"OpenKeyStoreAction.run");
            }
            return fis;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.audit.encryption.AuditEncryptionImpl$OpenKeyStoreAction", OpenKeyStoreAction.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
        }
    }
}

