/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.model;

import java.util.ArrayList;
import java.util.List;

public class TraceOptionsData {
    private final List<String> traceGroups = new ArrayList<String>();
    private String messageBundle;
    private boolean traceExceptionThrow;
    private boolean traceExceptionHandling;

    public TraceOptionsData() {
    }

    public TraceOptionsData(List<String> traceGroups, String messageBundle, boolean traceExceptionThrow, boolean traceExceptionHandling) {
        for (String traceGroup : traceGroups) {
            this.addTraceGroup(traceGroup);
        }
        this.setMessageBundle(messageBundle);
        this.traceExceptionThrow = traceExceptionThrow;
        this.traceExceptionHandling = traceExceptionHandling;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == TraceOptionsData.class) {
            TraceOptionsData traceOptions = (TraceOptionsData)object;
            return this.traceGroups.equals(traceOptions.traceGroups) && (this.messageBundle == null ? traceOptions.messageBundle == null : this.messageBundle.equals(traceOptions.messageBundle)) && this.traceExceptionThrow == traceOptions.traceExceptionThrow && this.traceExceptionHandling == traceOptions.traceExceptionHandling;
        }
        return false;
    }

    public List<String> getTraceGroups() {
        return this.traceGroups;
    }

    public void addTraceGroup(String traceGroup) {
        if (traceGroup != null && !traceGroup.equals("") && !this.traceGroups.contains(traceGroup)) {
            this.traceGroups.add(traceGroup);
        }
    }

    public boolean isTraceExceptionHandling() {
        return this.traceExceptionHandling;
    }

    public void setTraceExceptionHandling(boolean traceExceptionHandling) {
        this.traceExceptionHandling = traceExceptionHandling;
    }

    public boolean isTraceExceptionThrow() {
        return this.traceExceptionThrow;
    }

    public void setTraceExceptionThrow(boolean traceExceptionThrow) {
        this.traceExceptionThrow = traceExceptionThrow;
    }

    public void setMessageBundle(String messageBundle) {
        if (messageBundle != null && !messageBundle.equals("")) {
            this.messageBundle = messageBundle;
        }
    }

    public String getMessageBundle() {
        return this.messageBundle;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(";traceGroups=").append(this.traceGroups);
        sb.append(",messageBundle=").append(this.messageBundle);
        sb.append(",traceExceptionThrow=").append(this.traceExceptionThrow);
        sb.append(",traceExceptionHandling=").append(this.traceExceptionHandling);
        return sb.toString();
    }
}

