/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.tasks;

import com.ibm.ws.jbatch.utility.tasks.BaseWaitTask;
import com.ibm.ws.jbatch.utility.utils.ArgumentRequiredException;
import com.ibm.ws.jbatch.utility.utils.ConsoleWrapper;
import com.ibm.ws.jbatch.utility.utils.TaskIO;
import java.io.IOException;
import java.io.PrintStream;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;

public class StopTask
extends BaseWaitTask<StopTask> {
    public StopTask(String scriptName) {
        super("stop", scriptName);
    }

    @Override
    public int handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        JobInstance jobInstance;
        JobExecution jobExecution;
        this.setTaskIO(new TaskIO(stdin, stdout, stderr));
        this.setTaskArgs(args);
        long executionId = this.resolveJobExecutionId();
        if (executionId >= 0L) {
            jobExecution = this.getBatchRestClient().stop(executionId);
            jobInstance = this.getBatchRestClient().getJobInstanceForJobExecution(jobExecution.getExecutionId());
        } else {
            jobInstance = this.getBatchRestClient().getJobInstance(this.getJobInstanceId());
            jobExecution = this.getBatchRestClient().stop(jobInstance);
        }
        this.issueJobStopSubmittedMessage(jobInstance);
        if (this.shouldWaitForTermination()) {
            if (jobExecution.getExecutionId() == -1L) {
                this.issueJobStoppedMessage(jobInstance, null);
                return 0;
            }
            jobExecution = this.waitForTermination(jobInstance, jobExecution);
            return this.getProcessReturnCode(jobExecution);
        }
        return 0;
    }

    @Override
    protected void issueJobFinishedMessage(JobInstance jobInstance, JobExecution jobExecution) {
        this.issueJobStoppedMessage(jobInstance, jobExecution);
    }

    protected Long getJobExecutionId() {
        return this.getTaskArgs().getLongValue("--jobExecutionId", null);
    }

    protected Long getJobInstanceId() {
        return this.getTaskArgs().getLongValue("--jobInstanceId", null);
    }

    protected long resolveJobExecutionId() throws InterruptedException, IOException {
        Long jobInstanceId = this.getJobInstanceId();
        Long jobExecutionId = this.getJobExecutionId();
        if (jobExecutionId != null) {
            return jobExecutionId;
        }
        if (jobInstanceId != null) {
            return -1L;
        }
        throw new ArgumentRequiredException("--jobInstanceId or --jobExecutionId");
    }
}

