/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.tasks;

import com.ibm.ws.jbatch.utility.http.HttpUtils;
import com.ibm.ws.jbatch.utility.rest.BatchRestClient;
import com.ibm.ws.jbatch.utility.rest.PollingBatchClient;
import com.ibm.ws.jbatch.utility.rest.WSPurgeResponse;
import com.ibm.ws.jbatch.utility.tasks.BaseCommandTask;
import com.ibm.ws.jbatch.utility.utils.ControlPropsTaskArgs;
import com.ibm.ws.jbatch.utility.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;

public abstract class BaseBatchRestTask<T extends BaseBatchRestTask>
extends BaseCommandTask {
    private BatchRestClient batchRestClient;
    private PollingBatchClient pollingBatchRestClient;
    private ControlPropsTaskArgs taskArgs;
    protected static final int BatchStatusOrdinalValueRangeShift = 30;

    public BaseBatchRestTask(String taskName, String scriptName) {
        super(taskName, scriptName);
    }

    @Override
    public String getTaskHelp() {
        String taskName = this.getTaskName();
        return this.joinMsgs(this.getUsage("global.usage.options", this.scriptName, taskName), this.getDesc(taskName + ".desc"), this.collateRequiredOptions(this.getRequiredOptionsMessages()), this.collateOptionalOptions(this.getOptionalOptionsMessages()));
    }

    protected List<String> getRequiredOptionsMessages() {
        ArrayList<String> retMe = new ArrayList<String>();
        retMe.add(this.buildOptionsMessage("connect.required-key", "connect.required-desc"));
        retMe.add(this.buildOptionsMessage(this.getTaskName() + ".required-key", this.getTaskName() + ".required-desc"));
        return retMe;
    }

    protected List<String> getOptionalOptionsMessages() {
        ArrayList<String> retMe = new ArrayList<String>();
        retMe.add(this.buildOptionsMessage("connect.optional-key", "connect.optional-desc"));
        retMe.add(this.buildOptionsMessage(this.getTaskName() + ".optional-key", this.getTaskName() + ".optional-desc"));
        return retMe;
    }

    protected List<String> getTaskOptions() {
        ArrayList<String> retMe = new ArrayList<String>();
        retMe.addAll(this.getNlsOptionNames("connect.required-key."));
        retMe.addAll(this.getNlsOptionNames("connect.optional-key."));
        retMe.addAll(this.getNlsOptionNames(this.getTaskName() + ".required-key."));
        retMe.addAll(this.getNlsOptionNames(this.getTaskName() + ".optional-key."));
        return retMe;
    }

    protected T setTaskArgs(String[] args) throws IOException {
        this.taskArgs = new ControlPropsTaskArgs(Arrays.copyOfRange(args, 1, args.length));
        this.taskArgs.validateExpectedArgs(this.getTaskOptions());
        if (this.taskArgs.isSpecified("--trustSslCertificates")) {
            HttpUtils.setDefaultTrustAllCertificates();
        }
        return (T)this;
    }

    protected ControlPropsTaskArgs getTaskArgs() {
        return this.taskArgs;
    }

    protected BatchRestClient buildBatchRestClient() {
        List<String> targets = StringUtils.split(this.getTaskArgs().getRequiredString("--batchManager"), ",");
        String user = this.getTaskArgs().getStringValue("--user");
        String password = this.getTaskArgs().getStringValue("--password");
        boolean reusePreviousParams = this.taskArgs.isSpecified("--reusePreviousParams");
        return new BatchRestClient(targets).setAuthorization(user, password).setHttpTimeout(this.getHttpTimeout_ms()).setTaskIO(this.getTaskIO()).setReusePreviousParams(reusePreviousParams);
    }

    protected T setBatchRestClient(BatchRestClient batchRestClient) {
        this.batchRestClient = batchRestClient;
        return (T)this;
    }

    protected BatchRestClient getBatchRestClient() {
        if (this.batchRestClient == null) {
            this.setBatchRestClient(this.buildBatchRestClient());
        }
        return this.batchRestClient;
    }

    protected T setPollingBatchRestClient(PollingBatchClient pollingBatchClient) {
        this.pollingBatchRestClient = pollingBatchClient;
        return (T)this;
    }

    protected PollingBatchClient getPollingBatchRestClient() {
        if (this.pollingBatchRestClient == null) {
            this.setPollingBatchRestClient(new PollingBatchClient(this.getBatchRestClient(), this.getPollingInterval_ms()).setVerboseWait(this.getVerbose(), this.getTaskIO()));
        }
        return this.pollingBatchRestClient;
    }

    protected long getPollingInterval_ms() {
        return this.getTaskArgs().getLongValue("--pollingInterval_s", 30L) * 1000L;
    }

    protected int getHttpTimeout_ms() {
        return this.getTaskArgs().getIntValue("--httpTimeout_s", 30) * 1000;
    }

    protected boolean getVerbose() {
        return this.getTaskArgs().isSpecified("--verbose");
    }

    protected void issueJobSubmittedMessage(JobInstance jobInstance) {
        this.getTaskIO().info(this.getMessage("job.submitted", jobInstance.getJobName(), String.valueOf(jobInstance.getInstanceId())));
    }

    protected void issueJobFinishedMessage(JobInstance jobInstance, JobExecution jobExecution) {
        this.getTaskIO().info(this.getMessage("job.finished", jobInstance.getJobName(), String.valueOf(jobInstance.getInstanceId()), String.valueOf(jobExecution.getBatchStatus()), jobExecution.getExitStatus()));
    }

    protected void issueJobPurgedMessage(JobInstance jobInstance) {
        this.getTaskIO().info(this.getMessage("job.purged", jobInstance.getJobName(), String.valueOf(jobInstance.getInstanceId())));
    }

    protected void issueJobRestartedMessage(JobInstance jobInstance) {
        this.getTaskIO().info(this.getMessage("job.restarted", jobInstance.getJobName(), String.valueOf(jobInstance.getInstanceId())));
    }

    protected void issueJobStoppedMessage(JobInstance jobInstance, JobExecution jobExecution) {
        if (jobExecution != null) {
            this.getTaskIO().info(this.getMessage("job.stopped", jobInstance.getJobName(), String.valueOf(jobInstance.getInstanceId()), String.valueOf(jobExecution.getBatchStatus()), jobExecution.getExitStatus()));
        } else {
            this.getTaskIO().info(this.getMessage("job.stopped", jobInstance.getJobName(), String.valueOf(jobInstance.getInstanceId()), null, null));
        }
    }

    protected void issueJobStopSubmittedMessage(JobInstance jobInstance) {
        this.getTaskIO().info(this.getMessage("job.stop.submitted", jobInstance.getJobName(), String.valueOf(jobInstance.getInstanceId())));
    }

    protected void issueShutdownHookMessage(JobInstance jobInstance) {
        this.getTaskIO().info(this.getMessage("shutdown.hook", jobInstance.getJobName(), String.valueOf(jobInstance.getInstanceId())));
    }

    protected void issueJobExecutionMessage(JobExecution jobExecution) {
        this.getTaskIO().info(this.getMessage("job.execution.record", jobExecution.toString()));
    }

    protected void issueJobInstanceMessage(JobInstance jobInstance) {
        this.getTaskIO().info(this.getMessage("job.instance.record", jobInstance.toString()));
    }

    protected int getBatchStatusReturnCode(BatchStatus batchStatus) {
        return batchStatus.ordinal() + 30;
    }

    protected void issueJobPurgedMessage(WSPurgeResponse response) {
        this.getTaskIO().info(this.getMessage("job.purged.multi", String.valueOf(response.getInstanceId()), response.getPurgeStatus(), response.getMessage(), response.getRedirectUrl()));
    }
}

