/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLObjectBuilderFactory {
    private final Logger log = LoggerFactory.getLogger(XMLObjectBuilderFactory.class);
    private Map<QName, XMLObjectBuilder> builders = new ConcurrentHashMap<QName, XMLObjectBuilder>();

    public XMLObjectBuilder getBuilder(QName key) {
        if (key == null) {
            return null;
        }
        return this.builders.get(key);
    }

    public XMLObjectBuilder getBuilder(Element domElement) {
        XMLObjectBuilder builder = this.getBuilder(XMLHelper.getXSIType((Element)domElement));
        if (builder == null) {
            builder = this.getBuilder(XMLHelper.getNodeQName((Node)domElement));
        }
        return builder;
    }

    public Map<QName, XMLObjectBuilder> getBuilders() {
        return Collections.unmodifiableMap(this.builders);
    }

    public void registerBuilder(QName builderKey, XMLObjectBuilder builder) {
        this.log.debug("Registering builder, {} under key {}", (Object)builder.getClass().getName(), (Object)builderKey);
        if (builderKey == null) {
            throw new IllegalArgumentException("Builder key may not be null");
        }
        this.builders.put(builderKey, builder);
    }

    public XMLObjectBuilder deregisterBuilder(QName builderKey) {
        this.log.debug("Deregistering builder for object type {}", (Object)builderKey);
        if (builderKey != null) {
            return this.builders.remove(builderKey);
        }
        return null;
    }
}

