/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.encryption;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.Configuration;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.impl.SecureRandomIdentifierGenerator;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.BaseID;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.saml2.core.EncryptedAttribute;
import org.opensaml.saml2.core.EncryptedElementType;
import org.opensaml.saml2.core.EncryptedID;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.NewEncryptedID;
import org.opensaml.saml2.core.NewID;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.encryption.CarriedKeyName;
import org.opensaml.xml.encryption.DataReference;
import org.opensaml.xml.encryption.EncryptedData;
import org.opensaml.xml.encryption.EncryptedKey;
import org.opensaml.xml.encryption.EncryptionException;
import org.opensaml.xml.encryption.EncryptionParameters;
import org.opensaml.xml.encryption.KeyEncryptionParameters;
import org.opensaml.xml.encryption.ReferenceList;
import org.opensaml.xml.encryption.XMLEncryptionBuilder;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoGenerator;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.KeyName;
import org.opensaml.xml.signature.RetrievalMethod;
import org.opensaml.xml.signature.XMLSignatureBuilder;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Encrypter
extends org.opensaml.xml.encryption.Encrypter {
    private XMLObjectBuilderFactory builderFactory;
    private XMLSignatureBuilder<KeyInfo> keyInfoBuilder;
    private XMLEncryptionBuilder<DataReference> dataReferenceBuilder;
    private XMLEncryptionBuilder<ReferenceList> referenceListBuilder;
    private XMLSignatureBuilder<RetrievalMethod> retrievalMethodBuilder;
    private XMLSignatureBuilder<KeyName> keyNameBuilder;
    private XMLEncryptionBuilder<CarriedKeyName> carriedKeyNameBuilder;
    private IdentifierGenerator idGenerator;
    private EncryptionParameters encParams;
    private List<KeyEncryptionParameters> kekParamsList;
    private KeyPlacement keyPlacement;
    private final Logger log = LoggerFactory.getLogger(Encrypter.class);

    public Encrypter(EncryptionParameters dataEncParams, List<KeyEncryptionParameters> keyEncParams) {
        this.encParams = dataEncParams;
        this.kekParamsList = keyEncParams;
        this.init();
    }

    public Encrypter(EncryptionParameters dataEncParams, KeyEncryptionParameters keyEncParam) {
        ArrayList<KeyEncryptionParameters> keks = new ArrayList<KeyEncryptionParameters>();
        keks.add(keyEncParam);
        this.encParams = dataEncParams;
        this.kekParamsList = keks;
        this.init();
    }

    public Encrypter(EncryptionParameters dataEncParams) {
        ArrayList<KeyEncryptionParameters> keks = new ArrayList<KeyEncryptionParameters>();
        this.encParams = dataEncParams;
        this.kekParamsList = keks;
        this.init();
    }

    private void init() {
        this.builderFactory = Configuration.getBuilderFactory();
        this.keyInfoBuilder = (XMLSignatureBuilder)this.builderFactory.getBuilder(KeyInfo.DEFAULT_ELEMENT_NAME);
        this.dataReferenceBuilder = (XMLEncryptionBuilder)this.builderFactory.getBuilder(DataReference.DEFAULT_ELEMENT_NAME);
        this.referenceListBuilder = (XMLEncryptionBuilder)this.builderFactory.getBuilder(ReferenceList.DEFAULT_ELEMENT_NAME);
        this.retrievalMethodBuilder = (XMLSignatureBuilder)this.builderFactory.getBuilder(RetrievalMethod.DEFAULT_ELEMENT_NAME);
        this.keyNameBuilder = (XMLSignatureBuilder)this.builderFactory.getBuilder(KeyName.DEFAULT_ELEMENT_NAME);
        this.carriedKeyNameBuilder = (XMLEncryptionBuilder)this.builderFactory.getBuilder(CarriedKeyName.DEFAULT_ELEMENT_NAME);
        try {
            this.idGenerator = new SecureRandomIdentifierGenerator();
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("JVM does not support SHA1PRNG random number generation algorithm.");
        }
        this.keyPlacement = KeyPlacement.PEER;
    }

    public void setIDGenerator(IdentifierGenerator newIDGenerator) {
        this.idGenerator = newIDGenerator;
    }

    public KeyPlacement getKeyPlacement() {
        return this.keyPlacement;
    }

    public void setKeyPlacement(KeyPlacement newKeyPlacement) {
        this.keyPlacement = newKeyPlacement;
    }

    public EncryptedAssertion encrypt(Assertion assertion) throws EncryptionException {
        return (EncryptedAssertion)this.encrypt((XMLObject)((Object)assertion), EncryptedAssertion.DEFAULT_ELEMENT_NAME);
    }

    public EncryptedID encryptAsID(Assertion assertion) throws EncryptionException {
        return (EncryptedID)this.encrypt((XMLObject)((Object)assertion), EncryptedID.DEFAULT_ELEMENT_NAME);
    }

    public EncryptedAttribute encrypt(Attribute attribute) throws EncryptionException {
        return (EncryptedAttribute)this.encrypt(attribute, EncryptedAttribute.DEFAULT_ELEMENT_NAME);
    }

    public EncryptedID encrypt(NameID nameID) throws EncryptionException {
        return (EncryptedID)this.encrypt((XMLObject)((Object)nameID), EncryptedID.DEFAULT_ELEMENT_NAME);
    }

    public EncryptedID encrypt(BaseID baseID) throws EncryptionException {
        return (EncryptedID)this.encrypt((XMLObject)((Object)baseID), EncryptedID.DEFAULT_ELEMENT_NAME);
    }

    public NewEncryptedID encrypt(NewID newID) throws EncryptionException {
        return (NewEncryptedID)this.encrypt((XMLObject)((Object)newID), NewEncryptedID.DEFAULT_ELEMENT_NAME);
    }

    private EncryptedElementType encrypt(XMLObject xmlObject, QName encElementName) throws EncryptionException {
        this.checkParams(this.encParams, this.kekParamsList);
        EncryptedElementType encElement = (EncryptedElementType)this.builderFactory.getBuilder(encElementName).buildObject(encElementName);
        this.checkAndMarshall((XMLObject)((Object)encElement));
        Document ownerDocument = encElement.getDOM().getOwnerDocument();
        String encryptionAlgorithmURI = this.encParams.getAlgorithm();
        Key encryptionKey = SecurityHelper.extractEncryptionKey((Credential)this.encParams.getEncryptionCredential());
        if (encryptionKey == null) {
            encryptionKey = this.generateEncryptionKey(encryptionAlgorithmURI);
        }
        EncryptedData encryptedData = this.encryptElement(xmlObject, encryptionKey, encryptionAlgorithmURI, false);
        if (this.encParams.getKeyInfoGenerator() != null) {
            KeyInfoGenerator generator = this.encParams.getKeyInfoGenerator();
            this.log.debug("Dynamically generating KeyInfo from Credential for EncryptedData using generator: {}", (Object)generator.getClass().getName());
            try {
                encryptedData.setKeyInfo(generator.generate(this.encParams.getEncryptionCredential()));
            }
            catch (SecurityException e) {
                throw new EncryptionException("Error generating EncryptedData KeyInfo", (Exception)((Object)e));
            }
        }
        ArrayList<EncryptedKey> encryptedKeys = new ArrayList<EncryptedKey>();
        if (this.kekParamsList != null && !this.kekParamsList.isEmpty()) {
            encryptedKeys.addAll(this.encryptKey(encryptionKey, this.kekParamsList, ownerDocument));
        }
        return this.processElements(encElement, encryptedData, encryptedKeys);
    }

    protected EncryptedElementType processElements(EncryptedElementType encElement, EncryptedData encData, List<EncryptedKey> encKeys) throws EncryptionException {
        if (encData.getID() == null) {
            encData.setID(this.idGenerator.generateIdentifier());
        }
        if (encKeys.isEmpty()) {
            encElement.setEncryptedData(encData);
            return encElement;
        }
        if (encData.getKeyInfo() == null) {
            encData.setKeyInfo((KeyInfo)this.keyInfoBuilder.buildObject());
        }
        for (EncryptedKey encKey : encKeys) {
            if (encKey.getID() != null) continue;
            encKey.setID(this.idGenerator.generateIdentifier());
        }
        switch (this.keyPlacement) {
            case INLINE: {
                return this.placeKeysInline(encElement, encData, encKeys);
            }
            case PEER: {
                return this.placeKeysAsPeers(encElement, encData, encKeys);
            }
        }
        throw new EncryptionException("Unsupported key placement option was specified: " + (Object)((Object)this.keyPlacement));
    }

    protected EncryptedElementType placeKeysInline(EncryptedElementType encElement, EncryptedData encData, List<EncryptedKey> encKeys) {
        this.log.debug("Placing EncryptedKey elements inline inside EncryptedData");
        encData.getKeyInfo().getEncryptedKeys().addAll(encKeys);
        encElement.setEncryptedData(encData);
        return encElement;
    }

    protected EncryptedElementType placeKeysAsPeers(EncryptedElementType encElement, EncryptedData encData, List<EncryptedKey> encKeys) {
        this.log.debug("Placing EncryptedKey elements as peers of EncryptedData in EncryptedElementType");
        for (EncryptedKey encKey : encKeys) {
            if (encKey.getReferenceList() != null) continue;
            encKey.setReferenceList((ReferenceList)this.referenceListBuilder.buildObject());
        }
        if (encKeys.size() == 1) {
            this.linkSinglePeerKey(encData, encKeys.get(0));
        } else if (encKeys.size() > 1) {
            this.linkMultiplePeerKeys(encData, encKeys);
        }
        encElement.setEncryptedData(encData);
        encElement.getEncryptedKeys().addAll(encKeys);
        return encElement;
    }

    protected void linkSinglePeerKey(EncryptedData encData, EncryptedKey encKey) {
        this.log.debug("Linking single peer EncryptedKey with RetrievalMethod and DataReference");
        RetrievalMethod rm = (RetrievalMethod)this.retrievalMethodBuilder.buildObject();
        rm.setURI("#" + encKey.getID());
        rm.setType("http://www.w3.org/2001/04/xmlenc#EncryptedKey");
        encData.getKeyInfo().getRetrievalMethods().add(rm);
        DataReference dr = (DataReference)this.dataReferenceBuilder.buildObject();
        dr.setURI("#" + encData.getID());
        encKey.getReferenceList().getDataReferences().add(dr);
    }

    protected void linkMultiplePeerKeys(EncryptedData encData, List<EncryptedKey> encKeys) {
        String carriedKeyNameValue;
        this.log.debug("Linking multiple peer EncryptedKeys with CarriedKeyName and DataReference");
        List dataEncKeyNames = encData.getKeyInfo().getKeyNames();
        if (dataEncKeyNames.size() == 0 || DatatypeHelper.isEmpty((String)((KeyName)dataEncKeyNames.get(0)).getValue())) {
            String keyNameValue = this.idGenerator.generateIdentifier();
            this.log.debug("EncryptedData encryption key had no KeyName, generated one for use in CarriedKeyName: {}", (Object)keyNameValue);
            KeyName keyName = (KeyName)dataEncKeyNames.get(0);
            if (keyName == null) {
                keyName = (KeyName)this.keyNameBuilder.buildObject();
                dataEncKeyNames.add(keyName);
            }
            keyName.setValue(keyNameValue);
            carriedKeyNameValue = keyNameValue;
        } else {
            carriedKeyNameValue = ((KeyName)dataEncKeyNames.get(0)).getValue();
        }
        for (EncryptedKey encKey : encKeys) {
            if (encKey.getCarriedKeyName() == null) {
                encKey.setCarriedKeyName((CarriedKeyName)this.carriedKeyNameBuilder.buildObject());
            }
            encKey.getCarriedKeyName().setValue(carriedKeyNameValue);
            DataReference dr = (DataReference)this.dataReferenceBuilder.buildObject();
            dr.setURI("#" + encData.getID());
            encKey.getReferenceList().getDataReferences().add(dr);
        }
    }

    public static enum KeyPlacement {
        PEER,
        INLINE;

    }
}

