/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.core.impl;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.impl.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml1.core.RequestAbstractType;
import org.opensaml.saml1.core.RespondWith;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class RequestAbstractTypeUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    private final Logger log = LoggerFactory.getLogger(RequestAbstractType.class);

    public XMLObject unmarshall(Element domElement) throws UnmarshallingException {
        RequestAbstractType request = (RequestAbstractType)((Object)super.unmarshall(domElement));
        if (request.getMinorVersion() != 0 && !DatatypeHelper.isEmpty((String)request.getID())) {
            domElement.setIdAttributeNS(null, "RequestID", true);
        }
        return request;
    }

    @Override
    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        RequestAbstractType request = (RequestAbstractType)((Object)parentSAMLObject);
        if (childSAMLObject instanceof Signature) {
            request.setSignature((Signature)childSAMLObject);
        } else if (childSAMLObject instanceof RespondWith) {
            request.getRespondWiths().add((RespondWith)((Object)childSAMLObject));
        } else {
            super.processChildElement(parentSAMLObject, childSAMLObject);
        }
    }

    @Override
    protected void processAttribute(XMLObject samlElement, Attr attribute) throws UnmarshallingException {
        RequestAbstractType request = (RequestAbstractType)((Object)samlElement);
        if ("RequestID".equals(attribute.getLocalName())) {
            request.setID(attribute.getValue());
        } else if ("IssueInstant".equals(attribute.getLocalName()) && !DatatypeHelper.isEmpty((String)attribute.getValue())) {
            DateTime cal = new DateTime((Object)attribute.getValue(), (Chronology)ISOChronology.getInstanceUTC());
            request.setIssueInstant(cal);
        } else if ("MinorVersion".equals(attribute.getLocalName())) {
            int minor;
            try {
                minor = Integer.parseInt(attribute.getValue());
            }
            catch (NumberFormatException n) {
                this.log.error("Unable to parse minor version string", (Throwable)n);
                throw new UnmarshallingException((Exception)n);
            }
            if (minor == 0) {
                request.setVersion(SAMLVersion.VERSION_10);
            } else if (minor == 1) {
                request.setVersion(SAMLVersion.VERSION_11);
            }
        } else {
            super.processAttribute(samlElement, attribute);
        }
    }
}

