/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.class_scanner.ano;

import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ClassInfoType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.InnerClassesType;
import java.util.HashSet;
import java.util.List;

public class InnerOuterResolver {
    private final HashSet<UnresolvedInnerClassReference> innerClassesToResolveSet = new HashSet();
    private final HashSet<UnresolvedOuterClassReference> outerClassesToResolveSet = new HashSet();

    public void addUnresolvedInnerClassReference(ClassInfoType outerClass, String unresolvedInnerClass) {
        UnresolvedInnerClassReference uicr = new UnresolvedInnerClassReference(outerClass, unresolvedInnerClass);
        this.innerClassesToResolveSet.add(uicr);
    }

    public void addUnresolvedOuterClassReference(ClassInfoType innerClass, String unresolvedOuterClass) {
        UnresolvedOuterClassReference uocr = new UnresolvedOuterClassReference(innerClass, unresolvedOuterClass);
        this.outerClassesToResolveSet.add(uocr);
    }

    public void resolve(List<ClassInfoType> classList) {
        block0: for (UnresolvedInnerClassReference uicr : this.innerClassesToResolveSet) {
            ClassInfoType outerClass = uicr.getOuterClass();
            String innerClassName = uicr.getUnresolvedInnerClass();
            for (ClassInfoType cit : classList) {
                InnerClassesType ict;
                if (!cit.getClassName().equals(innerClassName) || (ict = outerClass.getInnerclasses()) == null || ict.getInnerclass().size() == 0) continue;
                ClassInfoType removeTarget = null;
                for (ClassInfoType innerCit : ict.getInnerclass()) {
                    if (!innerCit.getClassName().equals(innerClassName)) continue;
                    removeTarget = innerCit;
                    break;
                }
                if (removeTarget == null) continue;
                ict.getInnerclass().remove(removeTarget);
                ict.getInnerclass().add(cit);
                continue block0;
            }
        }
    }

    private class UnresolvedOuterClassReference {
        private final ClassInfoType innerClass;
        private final String unresolvedOuterClass;

        public UnresolvedOuterClassReference(ClassInfoType innerClass, String unresolvedOuterClass) {
            this.innerClass = innerClass;
            this.unresolvedOuterClass = unresolvedOuterClass;
        }

        public ClassInfoType getInnerClass() {
            return this.innerClass;
        }

        public String getUnresolvedOuterClass() {
            return this.unresolvedOuterClass;
        }

        public String toString() {
            return "UnresolvedOuterClassReference [innerClass=" + this.innerClass.getClassName() + ", unresolvedOuterClass=" + this.unresolvedOuterClass + "]";
        }
    }

    private class UnresolvedInnerClassReference {
        private final ClassInfoType outerClass;
        private final String unresolvedInnerClass;

        public UnresolvedInnerClassReference(ClassInfoType outerClass, String unresolvedInnerClass) {
            this.outerClass = outerClass;
            this.unresolvedInnerClass = unresolvedInnerClass;
        }

        public ClassInfoType getOuterClass() {
            return this.outerClass;
        }

        public String getUnresolvedInnerClass() {
            return this.unresolvedInnerClass;
        }

        public String toString() {
            return "UnresolvedInnerClassReference [outerClass=" + this.outerClass.getClassName() + ", unresolvedInnerClass=" + this.unresolvedInnerClass + "]";
        }
    }
}

