/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.class_scanner.ano;

import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ModifierType;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;

public final class AsmHelper {
    public static final String normalizeClassName(String className) {
        return className.replace('/', '.');
    }

    public static final String extractPackageName(String className) {
        if (className == null || className.trim().isEmpty()) {
            return "";
        }
        int idx = className.lastIndexOf(46);
        if (idx == -1) {
            return "";
        }
        return className.substring(0, idx);
    }

    public static final String extractSimpleClassName(String className) {
        if (className == null) {
            throw new NullPointerException();
        }
        int idx = className.lastIndexOf(46);
        if (idx == -1) {
            return className;
        }
        return className.substring(idx + 1);
    }

    public static final List<ModifierType> resolveAsmOpcode(RoleFilter filter, int opcode) {
        ArrayList<ModifierType> retList = new ArrayList<ModifierType>();
        if (0 != (0x400 & opcode)) {
            retList.add(ModifierType.ABSTRACT);
        }
        if (0 != (0x10 & opcode)) {
            retList.add(ModifierType.FINAL);
        }
        if (0 != (2 & opcode)) {
            retList.add(ModifierType.PRIVATE);
        }
        if (0 != (4 & opcode)) {
            retList.add(ModifierType.PROTECTED);
        }
        if (0 != (1 & opcode)) {
            retList.add(ModifierType.PUBLIC);
        }
        if (RoleFilter.CLASS == filter) {
            return retList;
        }
        if (0 != (8 & opcode)) {
            retList.add(ModifierType.STATIC);
        }
        return retList;
    }

    public static final boolean isPrimitiveType(Type type) {
        if (type == null) {
            throw new NullPointerException();
        }
        return Type.VOID_TYPE.equals((Object)type) || Type.BOOLEAN_TYPE.equals((Object)type) || Type.CHAR_TYPE.equals((Object)type) || Type.BYTE_TYPE.equals((Object)type) || Type.SHORT_TYPE.equals((Object)type) || Type.INT_TYPE.equals((Object)type) || Type.FLOAT_TYPE.equals((Object)type) || Type.LONG_TYPE.equals((Object)type) || Type.DOUBLE_TYPE.equals((Object)type);
    }

    public static enum RoleFilter {
        CLASS,
        FIELD,
        METHOD;

    }
}

