/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa;

import com.ibm.ws.jpa.JPAPuId;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class JPAExPcBindingContext
implements Serializable {
    private static final long serialVersionUID = 4812885700562185607L;
    private static final JPAPuId[] NoPuIds = new JPAPuId[0];
    private JPAExPcBindingContext ivParentContext;
    private static Long svIdBase = new Long(0L);
    private long ivBindId;
    private final String ivJ2eeName;
    private final boolean ivIsBmt;
    private boolean ivHasBmtUserTxBegunInMethod;
    private transient JPAPuId[] ivPuIds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPAExPcBindingContext(String j2eeName, boolean isBMT, JPAPuId[] puIds) {
        Long l = svIdBase;
        synchronized (l) {
            svIdBase = svIdBase + 1L;
            this.ivBindId = svIdBase;
        }
        this.ivJ2eeName = j2eeName;
        this.ivIsBmt = isBMT;
        this.ivHasBmtUserTxBegunInMethod = false;
        this.ivPuIds = puIds != null ? puIds : NoPuIds;
    }

    public void setParentContext(JPAExPcBindingContext parent) {
        this.ivParentContext = parent;
    }

    public JPAExPcBindingContext getParentContext() {
        return this.ivParentContext;
    }

    public long getBindId() {
        return this.ivBindId;
    }

    public String getName() {
        return this.ivJ2eeName;
    }

    public boolean isBmt() {
        return this.ivIsBmt;
    }

    public boolean hasBmtUserTxBegunInMethod() {
        return this.ivHasBmtUserTxBegunInMethod;
    }

    public void setBmtUserTxBegunInMethod(boolean hasBegan) {
        this.ivHasBmtUserTxBegunInMethod = hasBegan;
    }

    public JPAPuId[] getExPcPuIds() {
        return this.ivPuIds;
    }

    public String toString() {
        return (this.ivParentContext != null ? this.ivParentContext : "[Thread Entry]") + "\n\t--> " + this.thisToString();
    }

    public String thisToString() {
        return "{JPAExPcBindingContext: BindId=" + this.ivBindId + ", BMT=" + (this.ivIsBmt ? (char)'T' : 'F') + ", UserTxBegun=" + (this.ivHasBmtUserTxBegunInMethod ? (char)'T' : 'F') + ", Name=" + this.ivJ2eeName + ", PuIds=<" + this.ivPuIds.length + "> " + Arrays.toString(this.ivPuIds) + '}';
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int n = in.readInt();
        if (n == 0) {
            this.ivPuIds = NoPuIds;
        } else {
            this.ivPuIds = new JPAPuId[n];
            for (int i = 0; i < n; ++i) {
                JPAPuId id;
                this.ivPuIds[i] = id = (JPAPuId)in.readObject();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int n = this.ivPuIds.length;
        out.writeInt(n);
        for (int i = 0; i < n; ++i) {
            JPAPuId id = this.ivPuIds[i];
            out.writeObject(id);
        }
    }
}

