/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.faulttolerance.cdi.AggregatedFTPolicy;
import com.ibm.ws.microprofile.faulttolerance.cdi.PolicyStore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.spi.Bean;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractPolicyStore<K>
implements PolicyStore {
    private static final TraceComponent tc = Tr.register(AbstractPolicyStore.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.cdi.resources.FaultToleranceCDI");
    private final ConcurrentHashMap<K, AggregatedFTPolicy> store = new ConcurrentHashMap();
    static final long serialVersionUID = -7008182275426226586L;

    @Override
    public AggregatedFTPolicy getOrCreate(Bean<?> bean, Method method, Supplier<AggregatedFTPolicy> supplier) {
        AggregatedFTPolicy previous;
        K key = this.getKey(bean, method);
        AggregatedFTPolicy result = this.store.get(key);
        if (result == null && (previous = this.store.putIfAbsent(key, result = supplier.get())) != null) {
            result = previous;
        }
        return result;
    }

    protected abstract K getKey(Bean<?> var1, Method var2);

    @PreDestroy
    public void cleanUpExecutors() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleaning up executors", (Object[])new Object[0]);
        }
        this.store.values().forEach(e -> e.close());
    }
}

