/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.client.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.ddmodel.wsbnd.Port;
import com.ibm.ws.javaee.ddmodel.wsbnd.ServiceRef;
import com.ibm.ws.javaee.ddmodel.wsbnd.WebservicesBnd;
import com.ibm.ws.jaxws.client.JaxWsClientHandlerResolver;
import com.ibm.ws.jaxws.client.LibertyProviderImpl;
import com.ibm.ws.jaxws.client.injection.WebServiceRefInfoRefAddr;
import com.ibm.ws.jaxws.metadata.JaxWsClientMetaData;
import com.ibm.ws.jaxws.metadata.PortComponentRefInfo;
import com.ibm.ws.jaxws.metadata.WebServiceRefInfo;
import com.ibm.ws.jaxws.security.JaxWsSecurityConfigurationService;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.jaxws.support.LibertyHTTPTransportFactory;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.HandlerResolver;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ObjectFactory.class, ServiceRefObjectFactory.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class ServiceRefObjectFactory
implements ObjectFactory {
    private static final TraceComponent tc = Tr.register(ServiceRefObjectFactory.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
    private final AtomicServiceReference<JaxWsSecurityConfigurationService> securityConfigSR = new AtomicServiceReference("securityConfigurationService");
    static final long serialVersionUID = -5737479712807964641L;

    @Activate
    protected void activate(ComponentContext cCtx) {
        this.securityConfigSR.activate(cCtx);
    }

    @Deactivate
    protected void deActivate(ComponentContext cCtx) {
        this.securityConfigSR.deactivate(cCtx);
    }

    @org.osgi.service.component.annotations.Reference(name="securityConfigurationService", service=JaxWsSecurityConfigurationService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSecurityConfigurationService(ServiceReference<JaxWsSecurityConfigurationService> serviceRef) {
        this.securityConfigSR.setReference(serviceRef);
        LibertyProviderImpl.setSecurityConfigService(this.securityConfigSR);
        LibertyHTTPTransportFactory.setSecurityConfigService(this.securityConfigSR);
    }

    protected void unsetSecurityConfigurationService(ServiceReference<JaxWsSecurityConfigurationService> serviceRef) {
        this.securityConfigSR.unsetReference(serviceRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectInstance(Object obj, Name name, Context context, @Sensitive Hashtable<?, ?> environment) throws Exception {
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!ServiceRefObjectFactory.class.getName().equals(ref.getFactoryClassName())) {
            return null;
        }
        WebServiceRefInfo wsrInfo = null;
        WebServiceRefInfoRefAddr wsrInfoRefAddr = (WebServiceRefInfoRefAddr)ref.get("WebServiceRefInfo");
        if (wsrInfoRefAddr != null) {
            wsrInfo = (WebServiceRefInfo)wsrInfoRefAddr.getContent();
        }
        if (wsrInfo == null) {
            throw new Exception("Internal Error: Can not found the WebServiceRefInfo.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Service Ref JNDI name: " + wsrInfo.getJndiName()), (Object[])new Object[0]);
        }
        JaxWsClientMetaData declaredClientMetaData = wsrInfo.getClientMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("declaredClientMetaData: " + declaredClientMetaData), (Object[])new Object[0]);
        }
        JaxWsClientMetaData currentClientMetaData = JaxWsMetaDataManager.getJaxWsClientMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("currentClientMetaData: " + currentClientMetaData), (Object[])new Object[0]);
        }
        if (declaredClientMetaData == null) {
            declaredClientMetaData = currentClientMetaData;
        }
        if (declaredClientMetaData == null) {
            throw new IllegalStateException("Internal Error: Can not found the JaxWsClientMetaData");
        }
        this.mergeWebServicesBndInfo(wsrInfo, declaredClientMetaData);
        Bus originalThreadBus = BusFactory.getThreadDefaultBus((boolean)false);
        try {
            Object instance;
            BusFactory.setThreadDefaultBus((Bus)declaredClientMetaData.getClientBus());
            TransientWebServiceRefInfo tInfo = new TransientWebServiceRefInfo(declaredClientMetaData, wsrInfo, declaredClientMetaData.getModuleMetaData().getAppContextClassLoader());
            Object object = instance = this.getInstance(tInfo, wsrInfo);
            return object;
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)originalThreadBus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getInstance(TransientWebServiceRefInfo tInfo, WebServiceRefInfo wsrInfo) throws Exception {
        Object instance = null;
        Service svc = null;
        List<WebServiceFeature> originalWsFeatureList = LibertyProviderImpl.getWebServiceFeatures();
        WebServiceRefInfo originalWebServiceRefInfo = LibertyProviderImpl.getWebServiceRefInfo();
        try {
            List<WebServiceFeature> wsFeatureList = wsrInfo.getWSFeatureForSEIClass(wsrInfo.getServiceRefTypeClassName());
            LibertyProviderImpl.setWebServiceRefInfo(wsrInfo);
            LibertyProviderImpl.setWebServiceFeatures(wsFeatureList);
            svc = this.getServiceInstance(tInfo, wsrInfo);
        }
        finally {
            LibertyProviderImpl.setWebServiceFeatures(originalWsFeatureList);
            LibertyProviderImpl.setWebServiceRefInfo(originalWebServiceRefInfo);
        }
        svc.setHandlerResolver((HandlerResolver)new JaxWsClientHandlerResolver(tInfo.getWebServiceRefInfo(), tInfo.getClientMetaData()));
        Class<?> typeClass = tInfo.getServiceRefTypeClass();
        if (typeClass != null && !typeClass.getName().equals(Object.class.getName()) && !Service.class.isAssignableFrom(typeClass)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating a port instance based on class: " + tInfo.getServiceRefTypeClass().getName()), (Object[])new Object[0]);
            }
            instance = svc.getPort(typeClass);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Service instance created based on class: " + svc.getClass().getName()), (Object[])new Object[0]);
            }
            instance = svc;
        }
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    private Service getServiceInstance(TransientWebServiceRefInfo tInfo, WebServiceRefInfo wsrInfo) throws Exception {
        Class<?> svcSubClass = null;
        Service instance = null;
        if (tInfo.getServiceRefTypeClass() != null && Service.class.getName().equals(tInfo.getServiceRefTypeClassName())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Creating service instance using generic Service.create(QName)", (Object[])new Object[0]);
            }
            return Service.create((QName)tInfo.getServiceQName());
        }
        svcSubClass = tInfo.getServiceRefTypeClass() != null && Service.class.isAssignableFrom(tInfo.getServiceRefTypeClass()) ? tInfo.getServiceRefTypeClass() : tInfo.getServiceInterfaceClass();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Attempting to create instance of service sub-class: " + svcSubClass.getName()), (Object[])new Object[0]);
        }
        final Class<?> finalSvcSubClass = svcSubClass;
        Constructor constructor = null;
        try {
            Constructor finalConstructor;
            constructor = finalConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -1588436122495086721L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws NoSuchMethodException {
                    return finalSvcSubClass.getDeclaredConstructor(URL.class, QName.class);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.client.injection.ServiceRefObjectFactory$1", 1.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
                }
            });
        }
        catch (PrivilegedActionException finalConstructor) {
            void e;
            FFDCFilter.processException((Throwable)finalConstructor, (String)"com.ibm.ws.jaxws.client.injection.ServiceRefObjectFactory", (String)"259", (Object)this, (Object[])new Object[]{tInfo, wsrInfo});
            if (e.getException() != null) {
                throw e.getException();
            }
            throw e;
        }
        final URL url = tInfo.getWsdlURL();
        if (url != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Creating Service with WSDL URL: " + url + " and QName: " + tInfo.getServiceQName() + " for class: " + svcSubClass.getName()), (Object[])new Object[0]);
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(tInfo.classLoader);
            final Constructor finalConstructor = constructor;
            final QName serviceQName = tInfo.getServiceQName();
            instance = (Service)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -4133245179076422738L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws InstantiationException, IllegalAccessException, InvocationTargetException {
                    finalConstructor.setAccessible(true);
                    return finalConstructor.newInstance(url, serviceQName);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.client.injection.ServiceRefObjectFactory$2", 2.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
                }
            });
        }
        catch (PrivilegedActionException finalConstructor) {
            void e;
            FFDCFilter.processException((Throwable)finalConstructor, (String)"com.ibm.ws.jaxws.client.injection.ServiceRefObjectFactory", (String)"289", (Object)this, (Object[])new Object[]{tInfo, wsrInfo});
            if (e.getException() != null) {
                throw e.getException();
            }
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    private void mergeWebServicesBndInfo(WebServiceRefInfo wsrInfo, JaxWsClientMetaData jaxwsClientMetaData) {
        WebservicesBnd webServicesBnd = null;
        try {
            webServicesBnd = (WebservicesBnd)jaxwsClientMetaData.getModuleMetaData().getModuleContainer().adapt(WebservicesBnd.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jaxws.client.injection.ServiceRefObjectFactory", (String)"496", (Object)this, (Object[])new Object[]{wsrInfo, jaxwsClientMetaData});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Can not get the custom binding file due to {0}", (Object[])new Object[]{e});
            }
            return;
        }
        if (webServicesBnd != null) {
            String componenetName = wsrInfo.getComponenetName();
            ServiceRef serviceRef = webServicesBnd.getServiceRef(wsrInfo.getJndiName(), componenetName);
            if (serviceRef != null) {
                List portList = serviceRef.getPorts();
                if (portList != null && portList.size() > 0) {
                    for (Port port : portList) {
                        QName portQName = port.getPortQName();
                        PortComponentRefInfo portInfo = new PortComponentRefInfo(portQName);
                        portInfo.setAddress(port.getAddress());
                        portInfo.setUserName(port.getUserName());
                        portInfo.setPassword(port.getPassword());
                        portInfo.setSSLRef(port.getSSLRef());
                        portInfo.setKeyAlias(port.getKeyAlias());
                        portInfo.setProperties(port.getProperties());
                        wsrInfo.addPortComponentRefInfo(portInfo);
                    }
                }
                wsrInfo.setDefaultPortAddress(serviceRef.getPortAddress());
                wsrInfo.setProperties(serviceRef.getProperties());
                String wsdlOverride = serviceRef.getWsdlLocation();
                if (wsdlOverride != null && !wsdlOverride.isEmpty()) {
                    wsrInfo.setWsdlLocation(wsdlOverride);
                }
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class TransientWebServiceRefInfo {
        private Class<?> serviceInterfaceClass;
        private Class<?> serviceRefTypeClass;
        private final String wsdlLocation;
        private final QName serviceQName;
        private final QName portQName;
        private final ClassLoader classLoader;
        private final WebServiceRefInfo wsrInfo;
        private final JaxWsClientMetaData clientMetaData;
        private ModuleMetaData mmd;
        private final ComponentMetaData cmd;
        static final long serialVersionUID = 8177402252838753257L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public TransientWebServiceRefInfo(JaxWsClientMetaData metadata, WebServiceRefInfo info, ClassLoader classLoader) {
            this.clientMetaData = metadata;
            this.wsrInfo = info;
            this.wsdlLocation = info.getWsdlLocation();
            this.serviceQName = info.getServiceQName();
            this.portQName = info.getPortQName();
            this.classLoader = classLoader;
            if (classLoader == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"TransientWebServiceRefInfo ClassLoader from Client Metadata is null. Getting Context ClassLoader.", (Object[])new Object[0]);
                }
                classLoader = this.getCurrentContextClassLoader();
            }
            this.cmd = JaxWsMetaDataManager.getComponentMetaData();
            if (this.cmd != null) {
                this.mmd = this.cmd.getModuleMetaData();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("TransientWebServiceRefInfo ctor:\n   ModuleMetaData : " + this.mmd + "\n   ComponentMetaData: " + this.cmd + "\n   ClientMetaData : " + this.clientMetaData + "\n   ModuleName  : " + this.getName() + "\n   ClassLoader    : " + classLoader + "\n   WebServiceRefInfo: " + this.wsrInfo.toString()), (Object[])new Object[0]);
            }
        }

        private ClassLoader getCurrentContextClassLoader() {
            ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = 7553324976592211489L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.client.injection.ServiceRefObjectFactory$TransientWebServiceRefInfo$1", 1.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
                }
            });
            return cl;
        }

        public JaxWsClientMetaData getClientMetaData() {
            return this.clientMetaData;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Class<?> getServiceInterfaceClass() throws ClassNotFoundException {
            String className;
            if (this.serviceInterfaceClass == null && (className = this.wsrInfo.getServiceInterfaceClassName()) != null && !className.isEmpty()) {
                this.serviceInterfaceClass = Class.forName(className, true, this.classLoader);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Loaded service interface class: " + this.serviceInterfaceClass.getName()), (Object[])new Object[0]);
                }
            }
            return this.serviceInterfaceClass;
        }

        public Class<?> getServiceRefTypeClass() throws ClassNotFoundException {
            String className;
            if (this.serviceRefTypeClass == null && (className = this.wsrInfo.getServiceRefTypeClassName()) != null && !className.isEmpty()) {
                this.serviceRefTypeClass = Class.forName(className, true, this.classLoader);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Loaded service ref type class: " + this.serviceRefTypeClass.getName()), (Object[])new Object[0]);
                }
            }
            return this.serviceRefTypeClass;
        }

        public String getServiceInterfaceClassName() {
            return this.wsrInfo.getServiceInterfaceClassName();
        }

        public String getServiceRefTypeClassName() {
            return this.wsrInfo.getServiceRefTypeClassName();
        }

        public String getWsdlLocation() {
            return this.wsdlLocation;
        }

        public QName getServiceQName() {
            return this.serviceQName;
        }

        public QName getPortQName() {
            return this.portQName;
        }

        public WebServiceRefInfo getWebServiceRefInfo() {
            return this.wsrInfo;
        }

        @FFDCIgnore(value={Exception.class, PrivilegedActionException.class})
        private URL getWsdlURL() throws IOException {
            URL url;
            block8: {
                url = null;
                final String resolvedWSDL = this.getWsdlLocation();
                if (resolvedWSDL != null && !resolvedWSDL.isEmpty()) {
                    block7: {
                        url = JaxWsUtils.resolve(resolvedWSDL, this.getClientMetaData().getModuleMetaData().getModuleContainer());
                        if (url == null) {
                            try {
                                url = AccessController.doPrivileged(new PrivilegedAction<URL>(){
                                    static final long serialVersionUID = -5291657711570421597L;
                                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                                    @Override
                                    public URL run() {
                                        return TransientWebServiceRefInfo.this.classLoader.getResource(resolvedWSDL);
                                    }

                                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                    static {
                                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.client.injection.ServiceRefObjectFactory$TransientWebServiceRefInfo$2", 2.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
                                    }
                                });
                            }
                            catch (Exception e) {
                                if (!tc.isDebugEnabled()) break block7;
                                Tr.debug((TraceComponent)tc, (String)"Unable to wsdlLocation URL via ClassLoader.getRResource(): {0}", (Object[])new Object[]{e});
                            }
                        }
                    }
                    if (url == null) {
                        try {
                            final File file = new File(resolvedWSDL);
                            url = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){
                                static final long serialVersionUID = -3683579092899847323L;
                                private static final /* synthetic */ TraceComponent $$$tc$$$;

                                @Override
                                public URL run() throws MalformedURLException {
                                    return file.toURI().toURL();
                                }

                                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                static {
                                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.client.injection.ServiceRefObjectFactory$TransientWebServiceRefInfo$3", 3.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
                                }
                            });
                        }
                        catch (PrivilegedActionException e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                            Tr.debug((TraceComponent)tc, (String)"Unable to obtain wsdlLocation URL via File object: {0}", (Object[])new Object[]{e});
                        }
                    }
                }
            }
            return url;
        }

        public String getName() {
            return this.clientMetaData.getModuleMetaData().getName();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.client.injection.ServiceRefObjectFactory$TransientWebServiceRefInfo", TransientWebServiceRefInfo.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
        }
    }
}

