/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.runtime.util.URLStreamHandlerAdapter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class StreamHandlerUtils {
    private static TraceComponent tc = Tr.register(StreamHandlerUtils.class, (String)"StreamHandler", (String)"com.ibm.ws.ssl.resources.ssl");
    private static Map<String, URLStreamHandlerAdapter> streamHandlerAdapters = Collections.synchronizedMap(new HashMap());

    private StreamHandlerUtils() {
    }

    public static void create() {
    }

    public static void addProvider(String provider, String handlerClass) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addProvider", (Object[])new Object[]{provider, handlerClass});
        }
        URLStreamHandlerAdapter adapter = new URLStreamHandlerAdapter(provider, handlerClass, null);
        streamHandlerAdapters.put(provider, adapter);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addProvider", (Object)new Object[]{provider, handlerClass});
        }
    }

    public static void removeProvider(String provider) {
        URLStreamHandlerAdapter adapter;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeProvider", (Object[])new Object[]{provider});
        }
        if ((adapter = streamHandlerAdapters.remove(provider)) != null) {
            adapter.destroy();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeProvider", (Object)provider);
        }
    }

    public static boolean queryProvider(String provider) {
        return streamHandlerAdapters.containsKey(provider);
    }

    static String getProviderClasspath(List<String> providerClasspath) {
        StringBuilder sb = new StringBuilder();
        String segment = null;
        for (String classpathSegment : providerClasspath) {
            segment = classpathSegment.trim();
            if (0 == segment.length()) continue;
            if (0 < sb.length()) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(segment);
        }
        return sb.toString();
    }

    static String getClassName(String path) {
        return path.replace(File.pathSeparatorChar, '.');
    }

    static ClassLoader getResourceClassLoader(String classpath, ClassLoader parent) throws MalformedURLException {
        ClassLoader classloader = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getResourceClassLoader " + classpath + " : " + parent), (Object[])new Object[0]);
        }
        if (classpath == null || 0 == classpath.length()) {
            classloader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader result = Thread.currentThread().getContextClassLoader();
                    if (result == null) {
                        result = ClassLoader.getSystemClassLoader();
                    }
                    return result;
                }
            });
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("parsing urls classpath=" + classpath), (Object[])new Object[0]);
            }
            StringTokenizer st = new StringTokenizer(classpath.trim(), File.pathSeparator);
            ArrayList<String> entries = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String urlString = st.nextToken().trim();
                if (0 >= urlString.length()) continue;
                entries.add(urlString);
            }
            URL[] urls = AccessController.doPrivileged(new PrivilegedAction<URL[]>(){

                @Override
                public URL[] run() {
                    return new URL[0];
                }
            });
            if (tc.isDebugEnabled()) {
                StringBuilder msgurls = new StringBuilder(64 * urls.length);
                for (int i = 0; i < urls.length; ++i) {
                    msgurls.append("\n       ").append(urls[i]);
                }
                Tr.debug((TraceComponent)tc, (String)("loadingurls: " + msgurls.toString()), (Object[])new Object[0]);
            }
            final ClassLoader parentF = parent;
            final URL[] urlsF = urls;
            classloader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    if (parentF == null) {
                        return new URLClassLoader(urlsF, Thread.currentThread().getContextClassLoader());
                    }
                    return new URLClassLoader(urlsF, parentF);
                }
            });
        }
        return classloader;
    }
}

