/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.resource;

import com.ibm.websphere.ras.annotation.Trivial;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.resource.URIResolver;
import org.xml.sax.InputSource;

public class ExtendedURIResolver {
    protected URIResolver currentResolver;
    protected String lastestImportUri;
    protected Stack<InputStream> resourceOpened = new Stack();
    private static final Logger LOG = LogUtils.getL7dLogger(ExtendedURIResolver.class);

    @Trivial
    public ExtendedURIResolver() {
        this.currentResolver = new URIResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSource resolve(String curUri, String baseUri) throws ConnectException, SocketTimeoutException {
        try {
            this.currentResolver.resolve(baseUri, curUri, this.getClass());
            if (this.currentResolver.isResolved()) {
                if (this.currentResolver.getURI() != null && this.currentResolver.getURI().isAbsolute()) {
                    curUri = this.currentResolver.getURI().toString();
                }
                if (this.currentResolver.isFile()) {
                    curUri = this.currentResolver.getFile().getAbsoluteFile().toURI().toString();
                }
                InputStream in = this.currentResolver.getInputStream();
                this.resourceOpened.addElement(in);
                InputSource source = new InputSource(in);
                source.setSystemId(curUri);
                source.setPublicId(curUri);
                InputSource inputSource = source;
                return inputSource;
            }
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "Ignoring IOException 2: " + e);
        }
        finally {
            this.lastestImportUri = curUri;
        }
        return null;
    }

    @Trivial
    public void close() {
        while (!this.resourceOpened.isEmpty()) {
            try {
                InputStream in = this.resourceOpened.pop();
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Trivial
    public String getLatestImportURI() {
        return this.getURI();
    }

    @Trivial
    public String getURI() {
        if (this.currentResolver.getURI() != null) {
            return this.currentResolver.getURI().toString();
        }
        return this.lastestImportUri;
    }
}

