/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.tcp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.cxf.binding.soap.tcp.SoapTcpChannel;
import org.apache.cxf.binding.soap.tcp.SoapTcpSessionState;
import org.apache.cxf.binding.soap.tcp.SoapTcpUtils;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrame;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpMessage;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class SoapTcpMessageDecoder
extends ProtocolDecoderAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(IoSession session, IoBuffer buffer, ProtocolDecoderOutput out) throws Exception {
        Integer n;
        Integer n2;
        byte[] tempBuffer = (byte[])session.getAttribute((Object)"tempBuffer");
        Integer bufferPosition = (Integer)session.getAttribute((Object)"bufferPosition");
        Integer bufferDataLength = (Integer)session.getAttribute((Object)"bufferDataLength");
        if (tempBuffer == null) {
            tempBuffer = new byte[4096];
            bufferDataLength = buffer.limit();
            bufferPosition = new Integer(0);
            while (bufferPosition < bufferDataLength) {
                tempBuffer[bufferPosition.intValue()] = buffer.get();
                n2 = bufferPosition;
                n = bufferPosition = Integer.valueOf(bufferPosition + 1);
            }
            session.setAttribute((Object)"tempBuffer", (Object)tempBuffer);
            session.setAttribute((Object)"bufferPosition", (Object)bufferPosition);
            session.setAttribute((Object)"bufferDataLength", (Object)bufferDataLength);
        } else {
            bufferDataLength = bufferDataLength + buffer.limit();
            while (bufferPosition < bufferDataLength) {
                tempBuffer[bufferPosition.intValue()] = buffer.get();
                n2 = bufferPosition;
                n = bufferPosition = Integer.valueOf(bufferPosition + 1);
            }
        }
        SoapTcpSessionState sessionState = (SoapTcpSessionState)session.getAttribute((Object)"sessionState");
        if (sessionState != null && sessionState.getStateId() == 0) {
            if (bufferPosition == 16) {
                out.write((Object)IoBuffer.wrap((byte[])tempBuffer, (int)0, (int)bufferPosition));
                bufferPosition = 0;
                bufferDataLength = 0;
                session.setAttribute((Object)"bufferPosition", (Object)bufferPosition);
                session.setAttribute((Object)"bufferDataLength", (Object)bufferDataLength);
                return;
            }
            return;
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(tempBuffer, 0, bufferDataLength);
        try {
            SoapTcpFrame frame = SoapTcpUtils.readMessageFrame(inStream);
            List channels = (List)session.getAttribute((Object)"channels");
            Iterator iterator = channels.iterator();
            while (true) {
                if (iterator.hasNext()) {
                    SoapTcpChannel channel = (SoapTcpChannel)iterator.next();
                    if (channel.getChannelId() != frame.getChannelId()) continue;
                    switch (frame.getHeader().getFrameType()) {
                        case 0: 
                        case 4: 
                        case 5: {
                            SoapTcpMessage singleFrameMessage = SoapTcpMessage.createSoapTcpMessage(frame);
                            out.write((Object)singleFrameMessage);
                            bufferPosition = 0;
                            bufferDataLength = 0;
                            break;
                        }
                        case 1: 
                        case 2: {
                            channel.addFrame(frame);
                            bufferPosition = 0;
                            bufferDataLength = 0;
                            break;
                        }
                        case 3: {
                            List<SoapTcpFrame> frames = channel.getFrames();
                            SoapTcpMessage multiFrameMessage = SoapTcpMessage.createSoapTcpMessage(frames);
                            multiFrameMessage.getFrames().add(frame);
                            out.write((Object)multiFrameMessage);
                            bufferPosition = 0;
                            bufferDataLength = 0;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            session.setAttribute((Object)"bufferPosition", (Object)bufferPosition);
            session.setAttribute((Object)"bufferDataLength", (Object)bufferDataLength);
        }
    }
}

