/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.probe;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.request.probe.RequestProbeService;
import com.ibm.ws.request.probe.bci.internal.RequestProbeBCIManagerImpl;
import com.ibm.wsspi.logging.IntrospectableService;
import com.ibm.wsspi.probeExtension.ProbeExtension;
import com.ibm.wsspi.request.probe.bci.RequestProbeTransformDescriptor;
import com.ibm.wsspi.requestContext.RequestContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RequestProbeIntrospector
implements IntrospectableService {
    private static final TraceComponent tc = Tr.register(RequestProbeIntrospector.class, (String)"requestProbe", (String)"com.ibm.ws.request.probe.internal.resources.LoggingMessages");
    private static final int EXTRA_SPACE_REQUIRED = 2;

    protected void activate() {
    }

    protected void deactivate() {
    }

    public String getName() {
        return "RequestProbeIntrospector";
    }

    public String getDescription() {
        return "Information about the active requests, registered probe extensions and transform descriptors";
    }

    public void introspect(OutputStream out) throws IOException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"introspect", (Object[])new Object[0]);
        }
        PrintWriter writer = new PrintWriter(out, true);
        this.activeRequestIntropectors(writer);
        this.probeExtensionIntrospectors(writer);
        this.transformDescriptorIntrospectors(writer);
        writer.flush();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"introspect");
        }
    }

    private void activeRequestIntropectors(PrintWriter writer) {
        writer.println("\n------------------------------------------------------------------------------");
        writer.println("              Active Requests");
        writer.println("------------------------------------------------------------------------------\n");
        List<RequestContext> activeRequests = RequestProbeService.getActiveRequests();
        if (activeRequests == null || activeRequests.size() == 0) {
            writer.println("----- No active requests ----- ");
        } else {
            int maxDurationLength = 0;
            ArrayList<String> activeRequestDetails = new ArrayList<String>();
            for (RequestContext requestContext : activeRequests) {
                double totalRequestDuration = (double)(System.nanoTime() - requestContext.getRootEvent().getStartTime()) / 1000000.0;
                String totalRequestDurationStr = String.format("%.3f", totalRequestDuration);
                totalRequestDurationStr = totalRequestDurationStr + "ms";
                if (requestContext.getRequestId().toString().length() > maxDurationLength) {
                    maxDurationLength = requestContext.getRequestId().toString().length();
                }
                String threadId = DataFormatHelper.padHexString((int)((int)requestContext.getThreadId()), (int)8);
                activeRequestDetails.add(requestContext.getRequestId().toString() + "," + threadId + "," + totalRequestDurationStr);
            }
            writer.println(String.format("%-" + (maxDurationLength + 2) + "s%-10s%s", "Request", "Thread", "Duration"));
            for (String request : activeRequestDetails) {
                String requestId = request.split(",")[0];
                String threadId = request.split(",")[1];
                String totalDuration = request.split(",")[2];
                writer.println(String.format("%-" + (maxDurationLength + 2) + "s%-10s%s", requestId, threadId, totalDuration));
            }
            writer.println("------------------------------------------------------------------------------\n");
            for (RequestContext requestContext : activeRequests) {
                writer.println("Request " + requestContext.getRequestId().toString());
                writer.println(RequestContext.dumpTree(requestContext.getRootEvent(), true));
                writer.println();
            }
        }
    }

    private void transformDescriptorIntrospectors(PrintWriter writer) {
        Map<String, RequestProbeTransformDescriptor> registeredTransformDescriptors = RequestProbeBCIManagerImpl.getRequestProbeTransformDescriptors();
        ArrayList<String> transformDescriptorRefs = new ArrayList<String>(){
            {
                this.add("Transform Descriptor");
                this.add("");
            }
        };
        ArrayList<String> tdDetails = new ArrayList<String>(){
            {
                this.add("ClassName.MethodName(Description)");
                this.add("");
            }
        };
        ArrayList<Integer> indentationLength = new ArrayList<Integer>();
        int maxSpaceRequired = 0;
        for (Map.Entry<String, RequestProbeTransformDescriptor> transformDescriptor : registeredTransformDescriptors.entrySet()) {
            transformDescriptorRefs.add(transformDescriptor.getValue().toString());
            if (transformDescriptor.getValue().getMethodDesc().equals("all")) {
                tdDetails.add(transformDescriptor.getValue().getClassName() + "." + transformDescriptor.getValue().getMethodName() + "(" + transformDescriptor.getValue().getMethodDesc() + ")");
                continue;
            }
            tdDetails.add(transformDescriptor.getValue().getClassName() + "." + transformDescriptor.getValue().getMethodName() + transformDescriptor.getValue().getMethodDesc());
        }
        for (String transformDescriptorRef : transformDescriptorRefs) {
            if (transformDescriptorRef.length() <= maxSpaceRequired) continue;
            maxSpaceRequired = transformDescriptorRef.length();
        }
        indentationLength.add(maxSpaceRequired + 2);
        writer.println();
        writer.println("------------------------------------------------------------------------------");
        writer.println("              Registered Transform Descriptors ");
        writer.println("------------------------------------------------------------------------------");
        for (int i = 0; i < transformDescriptorRefs.size(); ++i) {
            writer.println(String.format("%-" + indentationLength.get(0) + "s%s", transformDescriptorRefs.get(i), tdDetails.get(i)));
        }
        if (registeredTransformDescriptors.size() == 0) {
            writer.println("----- No transform descriptors are registered ----- ");
        }
    }

    private void probeExtensionIntrospectors(PrintWriter writer) {
        List<ProbeExtension> registeredProbeExtensions = RequestProbeService.getProbeExtensions();
        ArrayList<String> probeExtensionRefList = new ArrayList<String>(){
            {
                this.add("Probe extension");
                this.add("");
                this.add("");
            }
        };
        ArrayList<String> sampleRateList = new ArrayList<String>(){
            {
                this.add("Sample");
                this.add("Rate");
                this.add("");
            }
        };
        ArrayList<String> contextInfoRequiredList = new ArrayList<String>(){
            {
                this.add("ContextInfo");
                this.add("required");
                this.add("");
            }
        };
        ArrayList<String> invokeOnyForRootList = new ArrayList<String>(){
            {
                this.add("Invoke only");
                this.add("for root");
                this.add("");
            }
        };
        ArrayList<String> entryEnabledList = new ArrayList<String>(){
            {
                this.add("Entry");
                this.add("enabled");
                this.add("");
            }
        };
        ArrayList<String> exitEnabledList = new ArrayList<String>(){
            {
                this.add("Exit");
                this.add("enabled");
                this.add("");
            }
        };
        ArrayList<String> includeTypeList = new ArrayList<String>(){
            {
                this.add("Include Types");
                this.add("");
                this.add("");
            }
        };
        ArrayList<Integer> indentationLength = new ArrayList<Integer>();
        int maxSpaceRequired = 0;
        for (ProbeExtension probeExtension : registeredProbeExtensions) {
            probeExtensionRefList.add(probeExtension.toString());
            sampleRateList.add("" + probeExtension.getRequestSampleRate());
            invokeOnyForRootList.add(probeExtension.invokeForRootEventsOnly() ? "True" : "False");
            entryEnabledList.add(probeExtension.invokeForEventEntry() ? "True" : "False");
            exitEnabledList.add(probeExtension.invokeForEventExit() ? "True" : "False");
            if (probeExtension.getContextInfoRequirement() == 0) {
                contextInfoRequiredList.add("ALL_EVENTS");
            } else if (probeExtension.getContextInfoRequirement() == 1) {
                contextInfoRequiredList.add("EVENTS_MATCHING_SPECIFIED_EVENT_TYPES");
            } else {
                contextInfoRequiredList.add("NONE");
            }
            StringBuilder eventTypes = new StringBuilder();
            String eventTypeStr = "";
            if (probeExtension.invokeForEventTypes() == null) {
                eventTypeStr = "ALL";
            } else {
                for (String eventType : probeExtension.invokeForEventTypes()) {
                    eventTypes.append(eventType + ",");
                }
                eventTypeStr = eventTypes.toString().substring(0, eventTypes.length() - 1);
            }
            includeTypeList.add(eventTypeStr);
        }
        for (String probeExtensionRef : probeExtensionRefList) {
            if (probeExtensionRef.length() <= maxSpaceRequired) continue;
            maxSpaceRequired = probeExtensionRef.length();
        }
        indentationLength.add(maxSpaceRequired + 2);
        maxSpaceRequired = 0;
        for (String sampleRate : sampleRateList) {
            if (sampleRate.length() <= maxSpaceRequired) continue;
            maxSpaceRequired = sampleRate.length();
        }
        indentationLength.add(maxSpaceRequired + 2);
        maxSpaceRequired = 0;
        for (String contextInfoRequired : contextInfoRequiredList) {
            if (contextInfoRequired.length() <= maxSpaceRequired) continue;
            maxSpaceRequired = contextInfoRequired.length();
        }
        indentationLength.add(maxSpaceRequired + 2);
        maxSpaceRequired = 0;
        for (String invokeOnyForRoot : invokeOnyForRootList) {
            if (invokeOnyForRoot.length() <= maxSpaceRequired) continue;
            maxSpaceRequired = invokeOnyForRoot.length();
        }
        indentationLength.add(maxSpaceRequired + 2);
        maxSpaceRequired = 0;
        for (String entryEnabled : entryEnabledList) {
            if (entryEnabled.length() <= maxSpaceRequired) continue;
            maxSpaceRequired = entryEnabled.length();
        }
        indentationLength.add(maxSpaceRequired + 2);
        maxSpaceRequired = 0;
        for (String exitEnabled : exitEnabledList) {
            if (exitEnabled.length() <= maxSpaceRequired) continue;
            maxSpaceRequired = exitEnabled.length();
        }
        indentationLength.add(maxSpaceRequired + 2);
        writer.println();
        writer.println("------------------------------------------------------------------------------");
        writer.println("              Registered Probe Extensions ");
        writer.println("------------------------------------------------------------------------------");
        for (int i = 0; i < probeExtensionRefList.size(); ++i) {
            writer.println(String.format("%-" + indentationLength.get(0) + "s%-" + indentationLength.get(1) + "s%-" + indentationLength.get(2) + "s%-" + indentationLength.get(3) + "s%-" + indentationLength.get(4) + "s%-" + indentationLength.get(5) + "s%s", probeExtensionRefList.get(i), sampleRateList.get(i), contextInfoRequiredList.get(i), invokeOnyForRootList.get(i), entryEnabledList.get(i), exitEnabledList.get(i), includeTypeList.get(i)));
        }
        if (registeredProbeExtensions.size() == 0) {
            writer.println("----- No probe extensions are registered ----- ");
        }
    }
}

