/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.utils;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SessionHashSet
extends AbstractSet {
    Object[] keys;
    private static SessionEmptyHashIterator sessionEmptyHashIterator = new SessionEmptyHashIterator();

    public SessionHashSet(Object[] keys) {
        this.keys = keys;
    }

    @Override
    public Iterator iterator() {
        return this.getSessionHashIterator();
    }

    @Override
    public int size() {
        if (this.keys == null) {
            return 0;
        }
        return this.keys.length;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private Iterator getSessionHashIterator() {
        if (this.size() == 0) {
            return sessionEmptyHashIterator;
        }
        return new SessionHashIterator();
    }

    private class SessionHashIterator
    implements Iterator {
        int current = 0;
        int end;

        SessionHashIterator() {
            this.end = SessionHashSet.this.keys.length;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.end;
        }

        public Object next() {
            if (this.current >= this.end) {
                throw new NoSuchElementException();
            }
            Object theObject = SessionHashSet.this.keys[this.current];
            ++this.current;
            return theObject;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SessionEmptyHashIterator
    implements Iterator {
        SessionEmptyHashIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

