/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.http;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.http.HttpSessionImpl;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.IProtocolAdapter;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.ISessionObserver;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;

public class HttpSessionObserver
implements ISessionObserver {
    private static final String methodClassName = "HttpSessionObserver";
    private static boolean _loggedVersion = false;
    protected ArrayList _sessionListeners;
    protected ArrayList _sessionIdListeners;
    protected IProtocolAdapter _adapter = null;
    protected static final int SESSION_DESTROYED = 0;
    protected static final String[] methodNames = new String[]{"sessionDestroyed"};

    public HttpSessionObserver(ArrayList listeners, IProtocolAdapter adapter) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE) && !_loggedVersion) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "", "CMVC Version 1.5 3/12/08 09:24:17");
            _loggedVersion = true;
        }
        this._sessionListeners = listeners;
        this._adapter = adapter;
    }

    public HttpSessionObserver(ArrayList listeners, ArrayList idListeners, IProtocolAdapter adapter) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE) && !_loggedVersion) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "", "CMVC Version 1.5 3/12/08 09:24:17");
            _loggedVersion = true;
        }
        this._sessionListeners = listeners;
        this._sessionIdListeners = idListeners;
        this._adapter = adapter;
    }

    @Override
    public void sessionCreated(ISession session) {
        HttpSessionImpl httpsession = (HttpSessionImpl)this._adapter.adapt(session);
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)httpsession);
        HttpSessionListener listener = null;
        for (int i = 0; i < this._sessionListeners.size(); ++i) {
            listener = (HttpSessionListener)this._sessionListeners.get(i);
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionCreated", "Calling sessionCreated on listener:" + listener);
            }
            if (session.isOverflow()) continue;
            listener.sessionCreated(event);
        }
    }

    @Override
    public void sessionAccessed(ISession session) {
    }

    @Override
    public void sessionAccessUnknownKey(Object key) {
    }

    @Override
    public void sessionAffinityBroke(ISession session) {
    }

    @Override
    public void sessionCacheDiscard(Object value) {
    }

    @Override
    public void sessionLiveCountInc(Object value) {
    }

    @Override
    public void sessionLiveCountDec(Object value) {
    }

    @Override
    public void sessionDestroyed(ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[0], "sessionid=" + session.getId());
        }
        ArrayList attributes = session.getListenerAttributeNames();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "attributes.size()=:" + attributes.size());
        }
        if (this._sessionListeners.size() > 0 || attributes.size() > 0) {
            HttpSessionImpl httpsession = (HttpSessionImpl)this._adapter.adapt(session);
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)httpsession);
            HttpSessionListener listener = null;
            for (int i = this._sessionListeners.size() - 1; i >= 0; --i) {
                listener = (HttpSessionListener)this._sessionListeners.get(i);
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "Calling sessionDestroyed on listener:" + listener);
                }
                try {
                    listener.sessionDestroyed(event);
                    continue;
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) continue;
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], e.toString() + " thrown by listener: " + listener);
                }
            }
            if (attributes.size() != 0) {
                Object value = null;
                String name = null;
                for (int i = 0; i < attributes.size(); ++i) {
                    name = (String)attributes.get(i);
                    value = session.getAttribute(name);
                    if (null == value) continue;
                    HttpSessionBindingListener bindingListener = (HttpSessionBindingListener)value;
                    HttpSessionBindingEvent bindingEvent = new HttpSessionBindingEvent((HttpSession)httpsession, name);
                    bindingListener.valueUnbound(bindingEvent);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0]);
        }
    }

    @Override
    public void sessionDestroyedByTimeout(ISession session) {
    }

    @Override
    public void sessionReleased(ISession session) {
    }

    @Override
    public void sessionFlushed(ISession session) {
    }

    @Override
    public void sessionDidActivate(ISession session) {
        HttpSessionImpl httpsession = (HttpSessionImpl)this._adapter.adapt(session);
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)httpsession);
        Enumeration enum1 = session.getAttributeNames();
        while (enum1.hasMoreElements()) {
            String attrName = (String)enum1.nextElement();
            Object attr = session.getAttribute(attrName);
            if (!(attr instanceof HttpSessionActivationListener)) continue;
            ((HttpSessionActivationListener)attr).sessionDidActivate(event);
        }
    }

    @Override
    public void sessionWillPassivate(ISession session) {
        HttpSessionImpl httpsession = (HttpSessionImpl)this._adapter.adapt(session);
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)httpsession);
        Enumeration enum1 = session.getAttributeNames();
        while (enum1.hasMoreElements()) {
            String attrName = (String)enum1.nextElement();
            Object attr = session.getAttribute(attrName);
            if (!(attr instanceof HttpSessionActivationListener)) continue;
            ((HttpSessionActivationListener)attr).sessionWillPassivate(event);
        }
    }

    @Override
    public String getId() {
        return methodClassName;
    }

    @Override
    public void sessionIdChanged(String oldId, ISession session) {
        HttpSessionImpl httpsession = (HttpSessionImpl)this._adapter.adapt(session);
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)httpsession);
        HttpSessionIdListener listener = null;
        for (int i = 0; i < this._sessionIdListeners.size(); ++i) {
            listener = (HttpSessionIdListener)this._sessionIdListeners.get(i);
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionIdChanged", "Calling sessionIdChanged on listener:" + listener);
            }
            listener.sessionIdChanged(event, oldId);
        }
    }
}

