/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.IGenericSessionManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;

public class SessionManagerRegistry {
    private static boolean _loggedVersion = false;
    private Map _genericSessionManagers = null;
    private static final String methodClassName = "SessionManagerRegistry";
    private static SessionManagerRegistry registry;
    private static final int GET_SESSION_MANAGER = 0;
    private static final int REGISTER_SESSION_MANAGER = 1;
    private static final int UNREGISTER_SESSION_MANAGER = 2;
    private static final String[] methodNames;

    public SessionManagerRegistry() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE) && !_loggedVersion) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "", "CMVC Version 1.5 3/12/08 09:24:04");
            _loggedVersion = true;
        }
        this._genericSessionManagers = new Hashtable();
    }

    public static synchronized SessionManagerRegistry getSessionManagerRegistry() {
        if (registry == null) {
            registry = new SessionManagerRegistry();
        }
        return registry;
    }

    public synchronized IGenericSessionManager getSessionManager(Object registryKey) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[0], "registryKey= " + registryKey);
        }
        IGenericSessionManager sessionManager = (IGenericSessionManager)this._genericSessionManagers.get(registryKey);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0], "sessionManager= " + sessionManager);
        }
        return sessionManager;
    }

    public synchronized void registerSessionManager(Object key, IGenericSessionManager sessionMgr) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[1], "registryKey= " + key + " sessionMgr:" + sessionMgr);
        }
        this._genericSessionManagers.put(key, sessionMgr);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[1]);
        }
    }

    public synchronized void unregisterSessionManager(Object key) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[2], "registryKey= " + key);
        }
        this._genericSessionManagers.remove(key);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[2]);
        }
    }

    public Enumeration getSessionManagers() {
        return ((Hashtable)this._genericSessionManagers).elements();
    }

    static {
        methodNames = new String[]{"getSessionManager", "registerSessionManager", "unregisterSessionManager"};
    }
}

