/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.sso.common.SsoService;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorHelper;
import com.ibm.ws.wssecurity.caller.AssertionToSubject;
import com.ibm.ws.wssecurity.token.TokenUtils;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.saml2.UserCredentialResolver;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSSecurityTokenServiceImpl
implements SsoService {
    protected static final TraceComponent tc = Tr.register(WSSecurityTokenServiceImpl.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    static final String KEY_SERVICE_PID = "service.pid";
    static final String KEY_SSO_SERVICE = "ssoService";
    static final String KEY_USER_RESOLVER = "userResolver";
    static final String KEY_SECURITY_SERVICE = "securityService";
    protected final ConcurrentServiceReferenceMap<String, SsoService> ssoServiceRefs = new ConcurrentServiceReferenceMap("ssoService");
    protected final ConcurrentServiceReferenceMap<String, UserCredentialResolver> userResolverRef = new ConcurrentServiceReferenceMap("userResolver");
    protected AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    static final long serialVersionUID = -3822751584101461860L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSsoService(ServiceReference<SsoService> reference) {
        String type = (String)reference.getProperty("type");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WSSecurity setSsoService type=" + type), (Object[])new Object[0]);
        }
        ConcurrentServiceReferenceMap<String, SsoService> concurrentServiceReferenceMap = this.ssoServiceRefs;
        synchronized (concurrentServiceReferenceMap) {
            this.ssoServiceRefs.putReference((Object)type, reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetSsoService(ServiceReference<SsoService> reference) {
        String type = (String)reference.getProperty("type");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WSSecurity unsetSsoService type=" + type), (Object[])new Object[0]);
        }
        ConcurrentServiceReferenceMap<String, SsoService> concurrentServiceReferenceMap = this.ssoServiceRefs;
        synchronized (concurrentServiceReferenceMap) {
            this.ssoServiceRefs.removeReference((Object)type, reference);
        }
    }

    protected void setSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.setReference(ref);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.unsetReference(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUserResolver(ServiceReference<UserCredentialResolver> ref) {
        String serviceId = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, UserCredentialResolver> concurrentServiceReferenceMap = this.userResolverRef;
        synchronized (concurrentServiceReferenceMap) {
            this.userResolverRef.putReference((Object)serviceId, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setUserResolver id:" + serviceId), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedUserResolver(ServiceReference<UserCredentialResolver> ref) {
        String serviceId = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, UserCredentialResolver> concurrentServiceReferenceMap = this.userResolverRef;
        synchronized (concurrentServiceReferenceMap) {
            this.userResolverRef.putReference((Object)serviceId, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" updateUserResolver id:" + serviceId), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetUserResolver(ServiceReference<UserCredentialResolver> ref) {
        String serviceId = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, UserCredentialResolver> concurrentServiceReferenceMap = this.userResolverRef;
        synchronized (concurrentServiceReferenceMap) {
            this.userResolverRef.removeReference((Object)serviceId, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" unsetUserResolverRef id:" + serviceId), (Object[])new Object[0]);
        }
    }

    public void activate(ComponentContext cc) {
        this.ssoServiceRefs.activate(cc);
        this.userResolverRef.activate(cc);
        this.securityServiceRef.activate(cc);
        AssertionToSubject.setActivatedUserResolverRef(this.userResolverRef);
        TokenUtils.setAuthHelper(new WebProviderAuthenticatorHelper(this.securityServiceRef));
        TokenUtils.setCommonSsoService(this.ssoServiceRefs);
        TokenUtils.setSecurityServiceRef(this.securityServiceRef);
    }

    public void deactivate(ComponentContext cc) {
        this.ssoServiceRefs.deactivate(cc);
        this.userResolverRef.deactivate(cc);
        this.securityServiceRef.deactivate(cc);
    }

    public Map<String, Object> handleRequest(String requestName, Map<String, Object> requestContext) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WSSecurity handleRequest requestName:" + requestName + "requestContext:" + requestContext), (Object[])new Object[0]);
        }
        if (requestContext != null) {
            result.putAll(requestContext);
        }
        return result;
    }
}

