/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.wssecurity.cxf.interceptor.WSSecurityLibertyPluginInterceptor;
import com.ibm.ws.wssecurity.cxf.validator.UsernameTokenValidator;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.wssecurity.client.config"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, service={WSSecurityClientConfiguration.class, ConfigurationListener.class}, immediate=true, property={"service.vendor=IBM"})
public class WSSecurityClientConfiguration
implements ConfigurationListener {
    private static final TraceComponent tc = Tr.register(WSSecurityClientConfiguration.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    protected volatile ConfigurationAdmin configAdmin;
    private volatile SecurityService securityService;
    static final String KEY_ID = "id";
    static final String CFG_KEY_USER = "user";
    static final String CFG_KEY_USER_NAME = "name";
    static final String CFG_KEY_PASSWORD = "password";
    static final String CFG_KEY_PASSWORD_VALUE = "value";
    static final String CFG_KEY_CALLBACK = "callback";
    static final String CFG_KEY_NAME = "name";
    static final String CFG_KEY_PROVIDER = "provider";
    static final String CFG_KEY_ENTRY = "entry";
    static final String CFG_KEY_ENTRY_KEY = "key";
    static final String CFG_KEY_ENTRY_VALUE = "value";
    static final String WSSEC = "ws-security";
    static final String CXF_USER_NAME = "ws-security.username";
    static final String CXF_USER_PASSWORD = "ws-security.password";
    static final String CXF_CBH = "ws-security.callback-handler";
    static final String[] SPECIAL_CFG_KEYS = new String[]{"component.name", "component.id", "config.source", "config.id", "id", "service.factoryPid", "service.vendor", "service.pid"};
    private volatile String cfgUser;
    private volatile SerializableProtectedString cfgPassword;
    private volatile String cfgCallback;
    private volatile Map<String, Object> defaultConfigMap = Collections.synchronizedMap(new HashMap());
    private volatile Map<String, Object> properties;
    private final Set<String> pids = new HashSet<String>();
    static final long serialVersionUID = 3481285481316424682L;

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin configAdmin) {
        if (this.configAdmin == configAdmin) {
            this.configAdmin = null;
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    protected void unsetSecurityService(SecurityService securityService) {
        if (this.securityService == securityService) {
            this.securityService = null;
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.properties = properties;
        this.setAndValidateProperties();
        WSSecurityLibertyPluginInterceptor.setClientBindingsConfiguration(this.defaultConfigMap);
        UsernameTokenValidator.setSecurityService(this.securityService);
    }

    @Modified
    protected void modify(Map<String, Object> newProperties) {
        this.properties = newProperties;
        this.internalModify();
    }

    private synchronized void internalModify() {
        this.cfgUser = null;
        this.cfgPassword = null;
        this.cfgCallback = null;
        this.defaultConfigMap.clear();
        this.setAndValidateProperties();
        WSSecurityLibertyPluginInterceptor.setClientBindingsConfiguration(this.defaultConfigMap);
    }

    @Deactivate
    protected void deactivate() {
        UsernameTokenValidator.setSecurityService(null);
        WSSecurityLibertyPluginInterceptor.setClientBindingsConfiguration(null);
        this.cfgUser = null;
        this.cfgPassword = null;
        this.cfgCallback = null;
        this.defaultConfigMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    private void setAndValidateProperties() {
        this.pids.clear();
        String id = (String)this.properties.get(KEY_ID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default config id = ", (Object[])new Object[]{id});
        }
        Set<Map.Entry<String, Object>> entrySet = this.properties.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            Object entry_value;
            String entry_key = entry.getKey();
            if ("signatureProperties".equals(entry_key)) {
                try {
                    String sigPropsConfigPid = (String)entry.getValue();
                    this.pids.add(sigPropsConfigPid);
                    Map<String, Object> signaturePropertyMap = this.convertToMap(sigPropsConfigPid);
                    if (signaturePropertyMap != null && !signaturePropertyMap.isEmpty()) {
                        for (String key : SPECIAL_CFG_KEYS) {
                            signaturePropertyMap.remove(key);
                        }
                        this.defaultConfigMap.put("ws-security.signature.properties", signaturePropertyMap);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"signature configuration type = ", (Object[])new Object[]{signaturePropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.type")});
                        Tr.debug((TraceComponent)tc, (String)"signature configuration alias = ", (Object[])new Object[]{signaturePropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.alias")});
                        Tr.debug((TraceComponent)tc, (String)"signature configuration ks file = ", (Object[])new Object[]{signaturePropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.file")});
                        Tr.debug((TraceComponent)tc, (String)"signature configuration password = ", (Object[])new Object[]{signaturePropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.password")});
                        Tr.debug((TraceComponent)tc, (String)"signature configuration provider = ", (Object[])new Object[]{signaturePropertyMap.get("org.apache.ws.security.crypto.provider")});
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Empty ws-security client signature configuration ", (Object[])new Object[]{sigPropsConfigPid});
                }
                catch (IOException sigPropsConfigPid) {
                    void e;
                    FFDCFilter.processException((Throwable)sigPropsConfigPid, (String)"com.ibm.ws.wssecurity.internal.WSSecurityClientConfiguration", (String)"199", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Invalid ws-security client signature configuration: " + e), (Object[])new Object[0]);
                }
                continue;
            }
            if ("encryptionProperties".equals(entry_key)) {
                try {
                    String encPropsConfigPid = (String)entry.getValue();
                    this.pids.add(encPropsConfigPid);
                    Map<String, Object> encryptionPropertyMap = this.convertToMap(encPropsConfigPid);
                    if (encryptionPropertyMap != null && !encryptionPropertyMap.isEmpty()) {
                        for (String key : SPECIAL_CFG_KEYS) {
                            encryptionPropertyMap.remove(key);
                        }
                        this.defaultConfigMap.put("ws-security.encryption.properties", encryptionPropertyMap);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"encryption configuration type = ", (Object[])new Object[]{encryptionPropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.type")});
                        Tr.debug((TraceComponent)tc, (String)"encryption configuration alias = ", (Object[])new Object[]{encryptionPropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.alias")});
                        Tr.debug((TraceComponent)tc, (String)"encryption configuration ks file = ", (Object[])new Object[]{encryptionPropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.file")});
                        Tr.debug((TraceComponent)tc, (String)"encryption configuration password = ", (Object[])new Object[]{encryptionPropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.password")});
                        Tr.debug((TraceComponent)tc, (String)"encryption configuration provider = ", (Object[])new Object[]{encryptionPropertyMap.get("org.apache.ws.security.crypto.provider")});
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Empty ws-security client encryption configuration ", (Object[])new Object[]{encPropsConfigPid});
                }
                catch (IOException encPropsConfigPid) {
                    void e;
                    FFDCFilter.processException((Throwable)encPropsConfigPid, (String)"com.ibm.ws.wssecurity.internal.WSSecurityClientConfiguration", (String)"227", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Invalid ws-security client encryption configuration: " + e), (Object[])new Object[0]);
                }
                continue;
            }
            if (entry_key == null || entry_key.startsWith(".") || entry_key.startsWith("config.") || entry_key.startsWith("service.") || entry_key.equals(KEY_ID) || (entry_value = entry.getValue()) == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ws-security provider configuration entry key = ", (Object[])new Object[]{entry_key});
                Tr.debug((TraceComponent)tc, (String)"ws-security provider configuration entry value = ", (Object[])new Object[]{entry_value});
            }
            this.defaultConfigMap.put(entry_key, entry_value);
            if (CXF_USER_NAME.equals(entry_key)) {
                this.cfgUser = (String)entry_value;
                continue;
            }
            if (CXF_USER_PASSWORD.equals(entry_key)) {
                this.cfgPassword = (SerializableProtectedString)entry_value;
                continue;
            }
            if (!CXF_CBH.equals(entry_key)) continue;
            this.cfgCallback = (String)entry_value;
        }
        if (this.defaultConfigMap.isEmpty()) {
            Tr.info((TraceComponent)tc, (String)"WSSECURITY_NO_CONFIG_DEFINED", (Object[])new Object[0]);
        }
    }

    String getUser() {
        return this.cfgUser;
    }

    SerializableProtectedString getPassword() {
        return this.cfgPassword;
    }

    String getCallback() {
        return this.cfgCallback;
    }

    Map<String, Object> getDefaultConfiguration() {
        return this.defaultConfigMap;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> convertToMap(String pid) throws IOException {
        HashMap<String, Object> map;
        block5: {
            map = new HashMap<String, Object>();
            try {
                Configuration config;
                Dictionary dictionary;
                Configuration[] configs = this.configAdmin.listConfigurations("(service.pid=" + pid + ")");
                if (configs != null && configs.length != 0 && (dictionary = (config = this.configAdmin.getConfiguration(pid)).getProperties()) != null) {
                    Enumeration keys = dictionary.keys();
                    while (keys.hasMoreElements()) {
                        String strKey = (String)keys.nextElement();
                        map.put(strKey, dictionary.get(strKey));
                    }
                    return map;
                }
            }
            catch (InvalidSyntaxException configs) {
                void e;
                FFDCFilter.processException((Throwable)configs, (String)"com.ibm.ws.wssecurity.internal.WSSecurityClientConfiguration", (String)"309", (Object)this, (Object[])new Object[]{pid});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("Syntax error accesssing configuration for pid " + pid + ": " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("No configuration for pid " + pid), (Object[])new Object[0]);
        }
        return map;
    }

    public synchronized void configurationEvent(ConfigurationEvent event) {
        if (event.getType() == 1 && this.pids.contains(event.getPid())) {
            this.internalModify();
        }
    }
}

