/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.utility.utils;

import com.ibm.ws.security.utility.IFileUtility;
import com.ibm.ws.security.utility.utils.CommandUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;

public class FileUtility
implements IFileUtility {
    static final String SLASH = String.valueOf(File.separatorChar);
    private final String WLP_USER_DIR;
    private final String WLP_OUTPUT_DIR;

    public FileUtility(String WLP_USER_DIR, String WLP_OUTPUT_DIR) {
        this.WLP_USER_DIR = WLP_USER_DIR;
        this.WLP_OUTPUT_DIR = WLP_OUTPUT_DIR;
    }

    @Override
    public String getServersDirectory() {
        if (this.WLP_OUTPUT_DIR != null) {
            return this.WLP_OUTPUT_DIR + SLASH;
        }
        if (this.WLP_USER_DIR != null) {
            return this.WLP_USER_DIR + SLASH + "servers" + SLASH;
        }
        return System.getProperty("user.dir") + SLASH + "usr" + SLASH + "servers" + SLASH;
    }

    @Override
    public String getClientsDirectory() {
        if (this.WLP_USER_DIR != null) {
            return this.WLP_USER_DIR + SLASH + "clients" + SLASH;
        }
        return System.getProperty("user.dir") + SLASH + "usr" + SLASH + "clients" + SLASH;
    }

    @Override
    public boolean createParentDirectory(PrintStream stdout, File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return true;
        }
        if (!parent.exists()) {
            if (!this.createParentDirectory(stdout, parent)) {
                return false;
            }
            if (!parent.mkdir()) {
                stdout.println(CommandUtils.getMessage("fileUtility.failedDirCreate", this.resolvePath(parent)));
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public String resolvePath(String path) {
        return this.resolvePath(new File(path));
    }

    @Override
    public String resolvePath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    @Override
    public boolean exists(String path) {
        File fPath = new File(path);
        return fPath.exists();
    }

    @Override
    public boolean exists(File file) {
        return file.exists();
    }

    @Override
    public boolean isDirectory(File file) {
        return file.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeToFile(PrintStream stderr, String toWrite, File outFile) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFile);
            fos.write(toWrite.getBytes(Charset.forName("UTF-8")));
            fos.flush();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            stderr.println(e.getMessage());
        }
        catch (IOException e) {
            stderr.println(e.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }
}

