/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.gbs;

import com.ibm.ws.sib.msgstore.gbs.DeleteStack;
import com.ibm.ws.sib.msgstore.gbs.GBSDeleteHeight;
import com.ibm.ws.sib.msgstore.gbs.GBSInsertFringe;
import com.ibm.ws.sib.msgstore.gbs.GBSNode;
import com.ibm.ws.sib.msgstore.gbs.InsertStack;
import com.ibm.ws.sib.msgstore.gbs.OptimisticDepthException;

class GBSDeleteFringe {
    private static GBSDeleteFringe _singleton;

    GBSDeleteFringe() {
    }

    static GBSDeleteFringe singleInstance() {
        if (_singleton == null) {
            _singleton = new GBSDeleteFringe();
        }
        return _singleton;
    }

    void balance(int t0_depth, DeleteStack stack) {
        int ntop = stack.topIndex();
        InsertStack istack = stack.insertStack();
        DeleteStack.Linearizer lxx = stack.linearizer();
        DeleteStack.FringeNote xx = stack.fringeNote();
        xx.depthDecrease = false;
        xx.conditionalDecrease = false;
        GBSNode f = stack.node(ntop);
        if (ntop == 0) {
            f.setRightChild(this.linearize(lxx, f.rightChild()));
            return;
        }
        GBSNode g = stack.node(ntop - 1);
        boolean gLeft = true;
        if (g.rightChild() == f) {
            gLeft = false;
        }
        if (f.leftChild() == stack.node(ntop + 1)) {
            this.leftFringe(lxx, xx, istack, f, g, gLeft, t0_depth);
        } else {
            this.rightFringe(lxx, xx, istack, f, g, gLeft);
        }
        this.lastFringe(xx, g, gLeft, stack, ntop, istack);
    }

    private void leftFringe(DeleteStack.Linearizer lxx, DeleteStack.FringeNote xx, InsertStack istack, GBSNode f, GBSNode g, boolean gLeft, int t0_depth) {
        int maxBal;
        GBSNode w = f.rightChild();
        GBSNode s = f.leftChild();
        GBSNode bfather = g;
        GBSNode sh = null;
        GBSNode p = null;
        short fbalance = f.balance();
        f.clearBalance();
        if (w == null) {
            sh = this.linearize(lxx, s);
            f.setRightChild(null);
            this.combine(this.lastInList(sh), f);
            p = sh;
            xx.depthDecrease = true;
        } else {
            p = this.linearize(lxx, s);
            f.setChildren(null, null);
            this.combine(this.lastInList(p), f);
            sh = p;
            GBSNode wh = w.leftMostChild(istack);
            int zpoints = istack.index();
            if (zpoints > 0) {
                int ztop = 0;
                if (--zpoints >= t0_depth) {
                    ztop = zpoints - t0_depth + 1;
                    sh = w;
                    bfather = istack.node(ztop - 1);
                    bfather.setLeftChild(p);
                }
                wh = this.linearize(lxx, istack.node(ztop));
            }
            this.combine(this.lastInList(p), wh);
            this.leftDepth(xx, fbalance);
        }
        if (gLeft) {
            g.setLeftChild(sh);
        } else {
            g.setRightChild(sh);
        }
        boolean bLeft = true;
        if (bfather.rightChild() == p) {
            bLeft = false;
        }
        if ((maxBal = g.kFactor() - 1) < 3) {
            maxBal = 3;
        }
        istack.start(bfather, "GBSDeleteFringe.leftFringe");
        istack.setNode(1, null);
        istack.resetBalancePointIndex();
        int fpidx = 1;
        if (g.kFactor() > 2) {
            GBSInsertFringe.singleInstance().balance(g.kFactor(), istack, p, fpidx, maxBal);
        }
        xx.newg = bfather;
        xx.newf = bLeft ? bfather.leftChild() : bfather.rightChild();
    }

    private void leftDepth(DeleteStack.FringeNote xx, int fbalance) {
        switch (fbalance) {
            case -1: {
                xx.depthDecrease = true;
                break;
            }
            case 0: {
                xx.conditionalDecrease = true;
                xx.conditionalBalance = 0;
                break;
            }
            case 1: {
                xx.conditionalDecrease = true;
                xx.conditionalBalance = -1;
                break;
            }
            default: {
                throw new RuntimeException("Help!  fbalance = " + fbalance);
            }
        }
    }

    private void rightFringe(DeleteStack.Linearizer lxx, DeleteStack.FringeNote xx, InsertStack istack, GBSNode f, GBSNode g, boolean gLeft) {
        GBSNode w = f.leftChild();
        GBSNode s = f.rightChild();
        short fbalance = f.balance();
        f.clearBalance();
        if (w == null) {
            boolean bLeft = true;
            if (g.rightChild() == f) {
                bLeft = false;
            }
            f.setRightChild(this.linearize(lxx, s));
            int maxBal = f.kFactor() - 1;
            if (maxBal < 3) {
                maxBal = 3;
            }
            istack.start(g, "GBSDeleteFringe.rightFringe");
            istack.setNode(1, null);
            istack.resetBalancePointIndex();
            int fpidx = 1;
            GBSInsertFringe.singleInstance().balance(g.kFactor(), istack, f, fpidx, maxBal);
            xx.newg = g;
            xx.newf = bLeft ? g.leftChild() : g.rightChild();
            xx.depthDecrease = true;
        } else {
            xx.newg = g;
            if (g.leftChild() == f) {
                g.setLeftChild(w);
            } else {
                g.setRightChild(w);
            }
            f.setLeftChild(null);
            GBSNode p = w.rightMostChild();
            f.setRightChild(this.linearize(lxx, s));
            this.combine(p, f);
            xx.newf = w;
            this.rightDepth(xx, fbalance);
        }
    }

    private void rightDepth(DeleteStack.FringeNote xx, int fbalance) {
        switch (fbalance) {
            case 1: {
                xx.depthDecrease = true;
                break;
            }
            case 0: {
                xx.conditionalDecrease = true;
                xx.conditionalBalance = 0;
                break;
            }
            case -1: {
                xx.conditionalDecrease = true;
                xx.conditionalBalance = 1;
                break;
            }
            default: {
                throw new RuntimeException("Help!  fbalance = " + fbalance);
            }
        }
    }

    private void lastFringe(DeleteStack.FringeNote xx, GBSNode g, boolean gLeft, DeleteStack stack, int ntop, InsertStack istack) {
        if (gLeft) {
            stack.setNode(ntop, g.leftChild());
        } else {
            stack.setNode(ntop, g.rightChild());
        }
        GBSNode q = null;
        istack.start(xx.newg, "GBSDeleteFringe.lastFringe");
        istack.resetBalancePointIndex();
        GBSNode fpoint = null;
        int fdepth = 0;
        int fpidx = 0;
        for (GBSNode p = xx.newf; p != null; p = p.rightChild()) {
            ++fdepth;
            istack.push(p);
            if (fpoint == null && p.leftChild() == null) {
                fdepth = 1;
                fpoint = p;
                fpidx = istack.index();
            }
            q = p;
        }
        int maxBal = g.kFactor() + 1;
        if (g.kFactor() % 3 == 0) {
            maxBal = g.kFactor() + 2;
        }
        if (fdepth > maxBal || fdepth >= maxBal && q.isFull()) {
            GBSInsertFringe.singleInstance().balance(g.kFactor(), istack, fpoint, fpidx, maxBal);
            if (xx.conditionalDecrease) {
                stack.node(ntop).setBalance(xx.conditionalBalance);
            }
            xx.conditionalDecrease = false;
        }
        if (xx.conditionalDecrease) {
            xx.depthDecrease = true;
        }
        if (xx.depthDecrease) {
            GBSDeleteHeight.singleInstance().balance(stack, ntop);
        }
    }

    private GBSNode lastInList(GBSNode p) {
        GBSNode q = p;
        for (p = p.rightChild(); p != null; p = p.rightChild()) {
            q = p;
        }
        return q;
    }

    private GBSNode linearize(DeleteStack.Linearizer xx, GBSNode p) {
        xx.headp = null;
        xx.lastp = null;
        this.innerLinearize(xx, p);
        return xx.headp;
    }

    private void innerLinearize(DeleteStack.Linearizer xx, GBSNode p) {
        ++xx.depth;
        if (xx.depth > 47) {
            throw new OptimisticDepthException("maxDepth (47) exceeded in GBSDeleteFringe.innerLinearize().");
        }
        if (p.leftChild() != null) {
            this.innerLinearize(xx, p.leftChild());
        }
        if (xx.lastp == null) {
            xx.headp = p;
        } else {
            xx.lastp.setChildren(null, p);
        }
        xx.lastp = p;
        if (p.rightChild() != null) {
            this.innerLinearize(xx, p.rightChild());
        }
        --xx.depth;
    }

    private void combine(GBSNode p, GBSNode f) {
        int gapWid = p.width() - p.population();
        GBSNode q = p;
        p.setRightChild(f);
        if (gapWid != 0) {
            GBSNode lq = null;
            for (p = f; p != null; p = p.rightChild()) {
                q.fillFromRight();
                lq = q;
                q = p;
            }
            if (q.population() != 0) {
                q.adjustMedian();
            } else {
                lq.clearRightChild();
            }
        }
    }
}

