/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.jmf.JMFDynamicType;
import com.ibm.ws.sib.mfp.jmf.JMFEncapsulation;
import com.ibm.ws.sib.mfp.jmf.JMFEnumType;
import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFNativePart;
import com.ibm.ws.sib.mfp.jmf.JMFPrimitiveType;
import com.ibm.ws.sib.mfp.jmf.JMFRepeatedType;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFTupleType;
import com.ibm.ws.sib.mfp.jmf.JMFType;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.JMFVariantType;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.JSRegistry;

class JSNativePartCopier {
    private static TraceComponent tc = JmfTr.register(JSNativePartCopier.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");

    JSNativePartCopier() {
    }

    void copy(JMFNativePart source, JMFNativePart target, boolean deep) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(tc, "copy");
        }
        JMFSchema sourceJMFSchema = source.getJMFSchema();
        JMFType sourceJMFType = sourceJMFSchema.getJMFType();
        this.copy(sourceJMFType, source, target, null, -1, deep);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(tc, "copy");
        }
    }

    private void copy(JMFType type, JMFNativePart source, JMFNativePart target, JMFNativePart targetParent, int accessor, boolean deep) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        boolean skipPart = false;
        if (target instanceof JMFEncapsulation) {
            if (deep) {
                JMFSchema oldSchema = source.getEncodingSchema();
                targetParent.setValue(accessor, JSRegistry.instance.newNativePart(oldSchema));
                target = (JMFNativePart)targetParent.getValue(accessor);
            } else {
                skipPart = true;
            }
        }
        if (!skipPart) {
            if (type instanceof JMFDynamicType) {
                this.copyDynamic((JMFDynamicType)type, source, target, targetParent, deep);
            } else if (type instanceof JMFTupleType) {
                this.copyTuple((JMFTupleType)type, source, target, targetParent, accessor, deep);
            } else if (type instanceof JMFRepeatedType) {
                this.copyRepeated((JMFRepeatedType)type, source, target, targetParent, accessor, deep);
            } else if (type instanceof JMFEnumType) {
                this.copyEnum((JMFEnumType)type, source, target, targetParent, accessor, deep);
            } else if (type instanceof JMFVariantType) {
                this.copyVariant((JMFVariantType)type, source, target, targetParent, deep);
            } else {
                this.copyPrimitive((JMFPrimitiveType)type, source, target);
            }
        }
    }

    private void copyTuple(JMFTupleType type, JMFNativePart source, JMFNativePart target, JMFNativePart targetParent, int accessor, boolean deep) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        int numFields = type.getFieldCount();
        for (int i = 0; i < numFields; ++i) {
            JMFType field = type.getField(i);
            this.copy(field, source, target, targetParent, accessor, deep);
        }
    }

    private void copyRepeated(JMFRepeatedType type, JMFNativePart source, JMFNativePart target, JMFNativePart targetParent, int accessor, boolean deep) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        JMFType subType = type.getItemType();
        this.copy(subType, source, target, targetParent, accessor, deep);
    }

    private void copyDynamic(JMFDynamicType type, JMFNativePart source, JMFNativePart target, JMFNativePart targetParent, boolean deep) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        int accessor = type.getAccessor();
        JMFNativePart sourceSubPart = (JMFNativePart)source.getValue(accessor);
        JMFNativePart targetSubPart = (JMFNativePart)target.getValue(accessor);
        JMFSchema subSchema = sourceSubPart.getJMFSchema();
        JMFType subType = subSchema.getJMFType();
        this.copy(subType, sourceSubPart, targetSubPart, target, accessor, deep);
    }

    private void copyVariant(JMFVariantType type, JMFNativePart source, JMFNativePart target, JMFNativePart targetParent, boolean deep) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        int accessor = type.getAccessor();
        int caseVariant = (Integer)source.getValue(accessor);
        target.setInt(accessor, caseVariant);
        JMFType subType = type.getCase(caseVariant);
        this.copy(subType, source, target, target, accessor, deep);
    }

    private void copyEnum(JMFEnumType type, JMFNativePart source, JMFNativePart target, JMFNativePart targetParent, int accessor, boolean deep) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
    }

    private void copyPrimitive(JMFPrimitiveType type, JMFNativePart source, JMFNativePart target) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        int accessor = type.getAccessor();
        Object value = source.getValue(accessor);
        target.setValue(accessor, value);
    }
}

