/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.xml.ra;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jca.utils.xml.ra.RaAdminObject;
import com.ibm.ws.jca.utils.xml.ra.RaConfigProperty;
import com.ibm.ws.jca.utils.xml.ra.RaInboundResourceAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaOutboundResourceAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaSecurityPermission;
import com.ibm.ws.jca.utils.xml.ra.v10.Ra10ResourceAdapter;
import com.ibm.ws.jca.utils.xml.ra.v10.Ra10SecurityPermission;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaResourceAdapter;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@Trivial
@XmlType(propOrder={"resourceAdapterClass", "configProperties", "outboundResourceAdapter", "inboundResourceAdapter", "adminObjects", "securityPermissions"})
public class RaResourceAdapter {
    private String resourceAdapterClass;
    @XmlElement(name="config-property")
    private final List<RaConfigProperty> configProperties = new LinkedList<RaConfigProperty>();
    private RaOutboundResourceAdapter outboundResourceAdapter;
    private RaInboundResourceAdapter inboundResourceAdapter;
    @XmlElement(name="adminobject")
    private final List<RaAdminObject> adminObjects = new LinkedList<RaAdminObject>();
    private List<RaSecurityPermission> securityPermissions = new LinkedList<RaSecurityPermission>();
    @XmlID
    @XmlAttribute(name="id")
    private String id;
    @XmlTransient
    private String wlp_nlsKey;
    @XmlTransient
    private String wlp_name;
    @XmlTransient
    private String wlp_description;
    @XmlTransient
    private Boolean wlp_autoStart;

    @XmlElement(name="resourceadapter-class")
    public void setResourceAdapterClass(String rac) {
        this.resourceAdapterClass = rac;
    }

    public String getName() {
        return this.wlp_name;
    }

    public String getDescription() {
        return this.wlp_description;
    }

    public String getNLSKey() {
        return this.wlp_nlsKey;
    }

    public Boolean getAutoStart() {
        return this.wlp_autoStart;
    }

    public String getResourceAdapterClass() {
        return this.resourceAdapterClass;
    }

    public List<RaConfigProperty> getConfigProperties() {
        return this.configProperties;
    }

    public String getId() {
        return this.id;
    }

    @XmlElement(name="outbound-resourceadapter")
    public void setOutboundResourceAdapter(RaOutboundResourceAdapter outboundResourceAdapter) {
        this.outboundResourceAdapter = outboundResourceAdapter;
    }

    public RaOutboundResourceAdapter getOutboundResourceAdapter() {
        return this.outboundResourceAdapter;
    }

    @XmlElement(name="inbound-resourceadapter")
    public void setInboundResourceAdapter(RaInboundResourceAdapter inboundResourceAdapter) {
        this.inboundResourceAdapter = inboundResourceAdapter;
    }

    public RaInboundResourceAdapter getInboundResourceAdapter() {
        return this.inboundResourceAdapter;
    }

    public List<RaAdminObject> getAdminObjects() {
        return this.adminObjects;
    }

    @XmlElement(name="security-permission")
    public void setSecurityPermissions(List<RaSecurityPermission> securityPermissions) {
        this.securityPermissions = securityPermissions;
    }

    public List<RaSecurityPermission> getSecurityPermissions() {
        return this.securityPermissions;
    }

    public RaConfigProperty getConfigPropertyById(String name) {
        for (RaConfigProperty configProperty : this.configProperties) {
            if (!configProperty.getName().equals(name)) continue;
            return configProperty;
        }
        return null;
    }

    public boolean isConfigPropertyAlreadyDefined(String configPropName) {
        RaConfigProperty configProperty = this.getConfigPropertyById(configPropName);
        if (configProperty == null) {
            return false;
        }
        return configProperty.getType() != null;
    }

    public RaAdminObject getAdminObject(String adminObjectInterface, String adminObjectClass) {
        for (RaAdminObject adminObject : this.adminObjects) {
            if (!adminObject.getAdminObjectInterface().equals(adminObjectInterface) || !adminObject.getAdminObjectClass().equals(adminObjectClass)) continue;
            return adminObject;
        }
        return null;
    }

    public void copyWlpSettings(WlpRaResourceAdapter resourceAdapter) {
        this.wlp_nlsKey = resourceAdapter.getNLSKey();
        this.wlp_name = resourceAdapter.getName();
        this.wlp_description = resourceAdapter.getDescription();
        this.wlp_autoStart = resourceAdapter.getAutoStart();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RaResourceAdapter{");
        sb.append("resourceadapter-class='");
        if (this.resourceAdapterClass != null) {
            sb.append(this.resourceAdapterClass);
        }
        sb.append("'}");
        return sb.toString();
    }

    public void copyRa10Settings(Ra10ResourceAdapter ra10resourceAdapter) {
        for (Ra10SecurityPermission permission : ra10resourceAdapter.getPermissions()) {
            RaSecurityPermission securityPermission = new RaSecurityPermission();
            securityPermission.copyRa10Settings(permission);
            this.securityPermissions.add(securityPermission);
        }
        this.resourceAdapterClass = null;
        this.outboundResourceAdapter = new RaOutboundResourceAdapter();
        this.outboundResourceAdapter.copyRa10Settings(ra10resourceAdapter);
        this.inboundResourceAdapter = null;
    }
}

