/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.cdi.extensions;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.CDIHelper;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.annotation.Priority;
import javax.el.ELProcessor;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.CallerPrincipal;
import javax.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.authentication.mechanism.http.RememberMe;
import javax.security.enterprise.credential.RememberMeCredential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.RememberMeIdentityStore;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@RememberMe
@Interceptor
@Priority(value=210)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RememberMeInterceptor {
    static final long serialVersionUID = 5584166352054868707L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        Method method = invocationContext.getMethod();
        if ("validateRequest".equals(method.getName())) {
            return new RememberMeWrapper(invocationContext).interceptValidateRequest();
        }
        if ("cleanSubject".equals(method.getName())) {
            return new RememberMeWrapper(invocationContext).interceptCleanSubject();
        }
        return invocationContext.proceed();
    }

    private RememberMeIdentityStore getRememberMeIdentityStore() {
        return (RememberMeIdentityStore)CDIHelper.getBeanFromCurrentModule(RememberMeIdentityStore.class);
    }

    protected ELProcessor getELProcessorWithAppModuleBeanManagerELResolver() {
        return CDIHelper.getELProcessor();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.cdi.extensions.RememberMeInterceptor", RememberMeInterceptor.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class RememberMeWrapper {
        private final InvocationContext invocationContext;
        private final RememberMe rememberMe;
        private final ELProcessor elProcessor;
        private final HttpMessageContext httpMessageContext;
        private String cookieName = null;
        private Boolean isSecure = null;
        static final long serialVersionUID = -7106952636007392414L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public RememberMeWrapper(InvocationContext invocationContext) {
            this.invocationContext = invocationContext;
            this.rememberMe = this.getRememberMe();
            this.httpMessageContext = this.getHttpMessageContext();
            this.elProcessor = this.getELProcessorIfNeeded();
            this.cookieName = this.getCookieName();
        }

        private RememberMe getRememberMe() {
            return this.invocationContext.getTarget().getClass().getAnnotation(RememberMe.class);
        }

        private HttpMessageContext getHttpMessageContext() {
            Object[] params = this.invocationContext.getParameters();
            return (HttpMessageContext)params[2];
        }

        private ELProcessor getELProcessorIfNeeded() {
            ELProcessor elProcessor = null;
            if (this.isAnyELExpressionSet()) {
                elProcessor = RememberMeInterceptor.this.getELProcessorWithAppModuleBeanManagerELResolver();
                elProcessor.defineBean("httpMessageContext", (Object)this.httpMessageContext);
                elProcessor.defineBean("self", this.invocationContext.getTarget());
            }
            return elProcessor;
        }

        private boolean isAnyELExpressionSet() {
            return !this.rememberMe.isRememberMeExpression().isEmpty() || !this.rememberMe.cookieSecureOnlyExpression().isEmpty() || !this.rememberMe.cookieMaxAgeSecondsExpression().isEmpty() || !this.rememberMe.cookieHttpOnlyExpression().isEmpty() || this.rememberMe.cookieName().startsWith("${") || this.rememberMe.cookieName().startsWith("#{");
        }

        private String getCookieName() {
            String cookieName = this.rememberMe.cookieName();
            if (cookieName.startsWith("${") || cookieName.startsWith("#{")) {
                cookieName = (String)this.processExpression(this.elProcessor, cookieName);
            }
            return cookieName;
        }

        public AuthenticationStatus interceptValidateRequest() throws Exception {
            AuthenticationStatus status = AuthenticationStatus.SUCCESS;
            HttpServletRequest request = this.httpMessageContext.getRequest();
            ProtectedString rememberMeCookieValue = this.getRememberMeCookieValue(request);
            CredentialValidationResult result = CredentialValidationResult.INVALID_RESULT;
            RememberMeIdentityStore rememberMeIdentityStore = RememberMeInterceptor.this.getRememberMeIdentityStore();
            if (rememberMeCookieValue != null) {
                result = this.authenticateWithRememberMeCookie(request, rememberMeCookieValue, rememberMeIdentityStore);
            }
            if (!CredentialValidationResult.Status.VALID.equals((Object)result.getStatus())) {
                status = this.authenticateAndRemember(rememberMeIdentityStore);
            }
            return status;
        }

        private CredentialValidationResult authenticateWithRememberMeCookie(HttpServletRequest request, ProtectedString rememberMeCookieValue, RememberMeIdentityStore rememberMeIdentityStore) {
            RememberMeCredential credential = new RememberMeCredential(new String(rememberMeCookieValue.getChars()));
            CredentialValidationResult result = rememberMeIdentityStore.validate(credential);
            if (CredentialValidationResult.Status.VALID.equals((Object)result.getStatus())) {
                this.httpMessageContext.notifyContainerAboutLogin((Principal)result.getCallerPrincipal(), result.getCallerGroups());
            } else {
                this.removeCookie(request, this.httpMessageContext.getResponse());
            }
            return result;
        }

        private AuthenticationStatus authenticateAndRemember(RememberMeIdentityStore rememberMeIdentityStore) throws Exception {
            AuthenticationStatus status = (AuthenticationStatus)this.invocationContext.proceed();
            if (AuthenticationStatus.SUCCESS.equals((Object)status) && this.isRememberMe()) {
                ProtectedString rememberMeCookieValue = new ProtectedString(rememberMeIdentityStore.generateLoginToken((CallerPrincipal)this.httpMessageContext.getCallerPrincipal(), this.httpMessageContext.getGroups()).toCharArray());
                this.setRememberMeCookieInResponse(rememberMeCookieValue, this.httpMessageContext.getResponse());
            }
            return status;
        }

        public Void interceptCleanSubject() {
            HttpServletRequest request = this.httpMessageContext.getRequest();
            ProtectedString rememberMeCookie = this.getRememberMeCookieValue(request);
            if (rememberMeCookie != null) {
                this.removeCookie(request, this.httpMessageContext.getResponse());
                RememberMeInterceptor.this.getRememberMeIdentityStore().removeLoginToken(new String(rememberMeCookie.getChars()));
            }
            return null;
        }

        private ProtectedString getRememberMeCookieValue(HttpServletRequest request) {
            ProtectedString rememberMeCookie = null;
            Cookie[] cookies = request.getCookies();
            String[] cookieValues = CookieHelper.getCookieValues((Cookie[])cookies, (String)this.cookieName);
            if (cookieValues != null) {
                rememberMeCookie = new ProtectedString(cookieValues[0].toCharArray());
            }
            return rememberMeCookie;
        }

        private void removeCookie(HttpServletRequest request, HttpServletResponse response) {
            if (!response.isCommitted() && response instanceof IExtendedResponse) {
                ((IExtendedResponse)response).removeCookie(this.cookieName);
            }
            Cookie rememberMeInvalidationCookie = this.createRemovalCookie("", 0);
            response.addCookie(rememberMeInvalidationCookie);
        }

        private Cookie createRemovalCookie(final @Sensitive String value, int maxAge) {
            Cookie cookie = AccessController.doPrivileged(new PrivilegedAction<Cookie>(){
                static final long serialVersionUID = 2240727597913592142L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Cookie run() {
                    return new Cookie(RememberMeWrapper.this.cookieName, value);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.cdi.extensions.RememberMeInterceptor$RememberMeWrapper$1", 1.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
                }
            });
            this.setCommonCookieAttributes(maxAge, cookie);
            return cookie;
        }

        private Cookie createCookie(final ProtectedString value, int maxAge) {
            Cookie cookie = AccessController.doPrivileged(new PrivilegedAction<Cookie>(){
                static final long serialVersionUID = 8403875955057585660L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Cookie run() {
                    return new Cookie(RememberMeWrapper.this.cookieName, new String(value.getChars()));
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.cdi.extensions.RememberMeInterceptor$RememberMeWrapper$2", 2.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
                }
            });
            this.setCommonCookieAttributes(maxAge, cookie);
            return cookie;
        }

        private void setCommonCookieAttributes(int maxAge, Cookie cookie) {
            cookie.setMaxAge(maxAge);
            cookie.setPath("/");
            cookie.setSecure(this.isSecure());
            cookie.setHttpOnly(this.isHttpOnly());
        }

        private boolean isSecure() {
            if (this.isSecure == null) {
                String cookieSecureOnlyExpression = this.rememberMe.cookieSecureOnlyExpression();
                this.isSecure = cookieSecureOnlyExpression.isEmpty() ? Boolean.valueOf(this.rememberMe.cookieSecureOnly()) : (Boolean)this.processExpression(this.elProcessor, cookieSecureOnlyExpression);
            }
            return this.isSecure;
        }

        private boolean isHttpOnly() {
            String cookieHttpOnlyExpression = this.rememberMe.cookieHttpOnlyExpression();
            if (cookieHttpOnlyExpression.isEmpty()) {
                return this.rememberMe.cookieHttpOnly();
            }
            return (Boolean)this.processExpression(this.elProcessor, cookieHttpOnlyExpression);
        }

        private void setRememberMeCookieInResponse(ProtectedString rememberMeCookieValue, HttpServletResponse response) {
            Cookie rememberMeCookie = this.createCookie(rememberMeCookieValue, this.getCookieMaxAgeInSeconds());
            response.addCookie(rememberMeCookie);
        }

        private int getCookieMaxAgeInSeconds() {
            String cookieMaxAgeSecondsExpression = this.rememberMe.cookieMaxAgeSecondsExpression();
            if (cookieMaxAgeSecondsExpression.isEmpty()) {
                return this.rememberMe.cookieMaxAgeSeconds();
            }
            return (Integer)this.processExpression(this.elProcessor, cookieMaxAgeSecondsExpression);
        }

        private boolean isRememberMe() {
            AuthenticationParameters authenticationParameters;
            if (this.httpMessageContext.isAuthenticationRequest() && (authenticationParameters = this.httpMessageContext.getAuthParameters()) != null) {
                return authenticationParameters.isRememberMe();
            }
            String isRememberMeExpression = this.rememberMe.isRememberMeExpression();
            if (isRememberMeExpression.isEmpty()) {
                return this.rememberMe.isRememberMe();
            }
            return (Boolean)this.processExpression(this.elProcessor, isRememberMeExpression);
        }

        private <T> T processExpression(ELProcessor elProcessor, String expression) {
            return (T)elProcessor.eval(this.removeBrackets(expression));
        }

        private String removeBrackets(String expression) {
            if ((expression.startsWith("${") || expression.startsWith("#{")) && expression.endsWith("}")) {
                expression = expression.substring(2, expression.length() - 1);
            }
            return expression;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.cdi.extensions.RememberMeInterceptor$RememberMeWrapper", RememberMeWrapper.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
        }
    }
}

