/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrency.policy.ConcurrencyPolicy;
import com.ibm.ws.concurrent.ContextualAction;
import com.ibm.ws.concurrent.WSManagedExecutorService;
import com.ibm.ws.concurrent.ext.ConcurrencyExtensionProvider;
import com.ibm.ws.concurrent.internal.ConcurrencyService;
import com.ibm.ws.concurrent.internal.MPContextPropagationVersion;
import com.ibm.ws.concurrent.internal.ManagedCompletableFuture;
import com.ibm.ws.concurrent.internal.TaskLifeCycleCallback;
import com.ibm.ws.concurrent.internal.ThreadContextImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.threading.CompletionStageExecutor;
import com.ibm.ws.threading.PolicyExecutor;
import com.ibm.ws.threading.PolicyTaskCallback;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.ThreadContextProvider;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedTask;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.concurrent.managedExecutorService"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={ExecutorService.class, ManagedExecutor.class, ManagedExecutorService.class, ResourceFactory.class, ApplicationRecycleComponent.class}, reference={@Reference(name="ApplicationRecycleCoordinator", service=ApplicationRecycleCoordinator.class)})
public class ManagedExecutorServiceImpl
implements ExecutorService,
ManagedExecutor,
ManagedExecutorService,
CompletionStageExecutor,
ResourceFactory,
ApplicationRecycleComponent,
WSManagedExecutorService {
    private static final TraceComponent tc;
    static final String APP_RECYCLE_SERVICE = "ApplicationRecycleCoordinator";
    private static final Map<String, String> JAKARTA_SUSPEND_TRAN;
    private static final Map<String, String> JAVAX_SUSPEND_TRAN;
    private final boolean allowLifeCycleMethods;
    private final Set<String> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    private ConcurrencyService concurrencySvc;
    private final PrivilegedAction<WSContextService> contextSvcAccessor = new PrivilegedAction<WSContextService>(){
        static final long serialVersionUID = -628214180864732514L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - void declaration
         */
        @Override
        @Trivial
        public WSContextService run() {
            try {
                return (WSContextService)ManagedExecutorServiceImpl.this.contextSvcRef.getServiceWithException();
            }
            catch (IllegalStateException illegalStateException) {
                void x;
                FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.concurrent.internal.ManagedExecutorServiceImpl$2", (String)"138", (Object)this, (Object[])new Object[0]);
                throw new RejectedExecutionException((Throwable)x);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.internal.ManagedExecutorServiceImpl$2", 2.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
        }
    };
    private final AtomicServiceReference<WSContextService> contextSvcRef = new AtomicServiceReference("ContextService");
    private final AtomicReference<Map<String, String>> defaultExecutionProperties = new AtomicReference();
    volatile int eeVersion;
    private ServiceReference<JavaEEVersion> eeVersionRef;
    private final int hash;
    private final AtomicReference<String> jndiNameRef = new AtomicReference();
    final AtomicReference<PolicyExecutor> longRunningPolicyExecutorRef = new AtomicReference();
    private final WSContextService mpContextService;
    final AtomicReference<String> name = new AtomicReference();
    volatile PolicyExecutor policyExecutor;
    private final PrivilegedAction<ThreadContextProvider> tranContextProviderAccessor = new PrivilegedAction<ThreadContextProvider>(){
        static final long serialVersionUID = -5158877323443152342L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        @Trivial
        public ThreadContextProvider run() {
            return (ThreadContextProvider)ManagedExecutorServiceImpl.this.tranContextProviderRef.getService();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.internal.ManagedExecutorServiceImpl$3", 3.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
        }
    };
    private AtomicServiceReference<ThreadContextProvider> tranContextProviderRef = new AtomicServiceReference("TransactionContextProvider");
    static final long serialVersionUID = -9019141114409549531L;

    public ManagedExecutorServiceImpl() {
        this.mpContextService = null;
        this.allowLifeCycleMethods = false;
        this.hash = super.hashCode();
    }

    public ManagedExecutorServiceImpl(String name, int hash, PolicyExecutor policyExecutor, ThreadContextImpl mpThreadContext, AtomicServiceReference<ThreadContextProvider> tranContextProviderRef) {
        this.name.set(name);
        this.hash = hash;
        this.policyExecutor = policyExecutor;
        this.longRunningPolicyExecutorRef.set(policyExecutor);
        this.mpContextService = mpThreadContext;
        this.tranContextProviderRef = tranContextProviderRef;
        this.allowLifeCycleMethods = true;
        mpThreadContext.managedExecutor = this;
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.contextSvcRef.activate(context);
        this.tranContextProviderRef.activate(context);
        String jndiName = (String)properties.get("jndiName");
        this.jndiNameRef.set(jndiName);
        String xsvcName = jndiName == null ? (String)properties.get("config.displayId") : jndiName;
        this.name.set(xsvcName);
        TreeMap<String, String> execProps = new TreeMap<String, String>();
        execProps.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
        execProps.put("com.ibm.ws.concurrent.TASK_OWNER", xsvcName);
        this.defaultExecutionProperties.set(execProps);
    }

    @Modified
    protected void modified(final ComponentContext context, Map<String, Object> properties) {
        String jndiName = (String)properties.get("jndiName");
        String oldJNDIName = this.jndiNameRef.getAndSet(jndiName);
        String xsvcName = jndiName == null ? (String)properties.get("config.displayId") : jndiName;
        this.name.set(xsvcName);
        TreeMap<String, String> execProps = new TreeMap<String, String>();
        execProps.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
        execProps.put("com.ibm.ws.concurrent.TASK_OWNER", xsvcName);
        this.defaultExecutionProperties.set(execProps);
        if ((jndiName == null ? oldJNDIName != null : !jndiName.equals(oldJNDIName)) && !this.applications.isEmpty()) {
            ApplicationRecycleCoordinator appCoord = AccessController.doPrivileged(new PrivilegedAction<ApplicationRecycleCoordinator>(){
                static final long serialVersionUID = 777028227873978054L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ApplicationRecycleCoordinator run() {
                    return (ApplicationRecycleCoordinator)context.locateService(ManagedExecutorServiceImpl.APP_RECYCLE_SERVICE);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.internal.ManagedExecutorServiceImpl$4", 4.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
                }
            });
            HashSet<String> members = new HashSet<String>(this.applications);
            this.applications.removeAll(members);
            appCoord.recycleApplications(members);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        int count = this.policyExecutor.cancel(this.getIdentifier(this.policyExecutor.getIdentifier()), true);
        PolicyExecutor longRunningExecutor = this.longRunningPolicyExecutorRef.get();
        if (longRunningExecutor != null) {
            count += longRunningExecutor.cancel(this.getIdentifier(longRunningExecutor.getIdentifier()), true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(count + " submitted tasks canceled"), (Object[])new Object[0]);
        }
        this.contextSvcRef.deactivate(context);
        this.tranContextProviderRef.deactivate(context);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.allowLifeCycleMethods) {
            return this.getNormalPolicyExecutor().awaitTermination(timeout, unit);
        }
        throw new IllegalStateException(new UnsupportedOperationException("awaitTermination"));
    }

    public <U> CompletableFuture<U> completedFuture(U value) {
        return ManagedCompletableFuture.completedFuture(value, this);
    }

    public <U> CompletionStage<U> completedStage(U value) {
        return ManagedCompletableFuture.completedStage(value, this);
    }

    @Trivial
    public final <T> CompletableFuture<T> copy(CompletableFuture<T> stage) {
        return (CompletableFuture)this.copy((CompletionStage<T>)stage);
    }

    public <T> CompletionStage<T> copy(CompletionStage<T> stage) {
        if (this.mpContextService == null || !MPContextPropagationVersion.atLeast(MPContextPropagationVersion.V1_1)) {
            throw new UnsupportedOperationException();
        }
        ManagedCompletableFuture copy = ManagedCompletableFuture.JAVA8 ? new ManagedCompletableFuture(new CompletableFuture(), this, null) : new ManagedCompletableFuture(this, null);
        stage.whenComplete((result, failure) -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)stage, (TraceComponent)tc, (String)"whenComplete", (Object[])new Object[]{result, failure});
            }
            if (failure == null) {
                copy.complete(result);
            } else {
                copy.completeExceptionally((Throwable)failure);
            }
        });
        return copy;
    }

    private <T> Map.Entry<Collection<? extends Callable<T>>, TaskLifeCycleCallback[]> createCallbacks(Collection<? extends Callable<T>> tasks) {
        int numTasks = tasks.size();
        TaskLifeCycleCallback[] callbacks = new TaskLifeCycleCallback[numTasks];
        ArrayList<Callable<T>> taskUpdates = null;
        if (numTasks == 1) {
            ThreadContextDescriptor contextDescriptor;
            Callable task = tasks.iterator().next();
            if (task instanceof ContextualAction) {
                ContextualAction a = (ContextualAction)((Object)task);
                contextDescriptor = a.getContextDescriptor();
                task = (Callable)a.getAction();
                taskUpdates = Arrays.asList(task);
            } else {
                contextDescriptor = this.getContextService().captureThreadContext(this.getExecutionProperties(task), new Map[0]);
            }
            callbacks[0] = new TaskLifeCycleCallback(this, contextDescriptor);
        } else {
            HashMap<Map<String, String>, TaskLifeCycleCallback> execPropsToCallback = new HashMap<Map<String, String>, TaskLifeCycleCallback>();
            WSContextService contextSvc = null;
            int t = 0;
            for (Callable<T> task : tasks) {
                if (task instanceof ContextualAction) {
                    ContextualAction a = (ContextualAction)((Object)task);
                    taskUpdates = taskUpdates == null ? new ArrayList<Callable<T>>(tasks) : taskUpdates;
                    taskUpdates.set(t, (Callable)a.getAction());
                    callbacks[t++] = new TaskLifeCycleCallback(this, a.getContextDescriptor());
                    continue;
                }
                Map<String, String> execProps = this.getExecutionProperties(task);
                TaskLifeCycleCallback callback = (TaskLifeCycleCallback)((Object)execPropsToCallback.get(execProps));
                if (callback == null) {
                    contextSvc = contextSvc == null ? this.getContextService() : contextSvc;
                    callback = new TaskLifeCycleCallback(this, contextSvc.captureThreadContext(execProps, new Map[0]));
                    execPropsToCallback.put(execProps, callback);
                }
                callbacks[t++] = callback;
            }
        }
        return new AbstractMap.SimpleEntry<Collection<? extends Callable<T>>, TaskLifeCycleCallback[]>(taskUpdates == null ? tasks : taskUpdates, callbacks);
    }

    public Object createResource(ResourceInfo ref) throws Exception {
        ConcurrencyExtensionProvider provider;
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cData != null) {
            this.applications.add(cData.getJ2EEName().getApplication());
        }
        if ((provider = this.concurrencySvc.extensionProvider) == null) {
            return this;
        }
        return provider.provide(this, ref);
    }

    public <U> CompletableFuture<U> failedFuture(Throwable ex) {
        return ManagedCompletableFuture.failedFuture(ex, this);
    }

    public <U> CompletionStage<U> failedStage(Throwable ex) {
        return ManagedCompletableFuture.failedStage(ex, this);
    }

    public ApplicationRecycleContext getContext() {
        return null;
    }

    @Override
    public WSContextService getContextService() {
        return this.mpContextService == null ? AccessController.doPrivileged(this.contextSvcAccessor) : this.mpContextService;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.applications);
        this.applications.removeAll(members);
        return members;
    }

    @Override
    public PolicyExecutor getLongRunningPolicyExecutor() {
        return this.longRunningPolicyExecutorRef.get();
    }

    @Override
    public PolicyExecutor getNormalPolicyExecutor() {
        return this.policyExecutor;
    }

    @Override
    public void execute(Runnable command) {
        this.submit(command, null);
    }

    final Map<String, String> getExecutionProperties(Object task) {
        Map<String, String> execProps;
        if (task == null) {
            throw new NullPointerException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1111.task.invalid", (Object[])new Object[]{null}));
        }
        Map<String, String> map = execProps = task instanceof ManagedTask ? ((ManagedTask)task).getExecutionProperties() : null;
        if (execProps == null) {
            execProps = this.defaultExecutionProperties.get();
        } else {
            execProps = new TreeMap<String, String>(execProps);
            String tranPropKey = "jakarta.enterprise.concurrent.TRANSACTION";
            String tranProp = execProps.remove("jakarta.enterprise.concurrent.TRANSACTION");
            if (tranProp == null) {
                tranPropKey = "javax.enterprise.concurrent.TRANSACTION";
                tranProp = execProps.remove("javax.enterprise.concurrent.TRANSACTION");
            }
            if (tranProp != null && !"SUSPEND".equals(tranProp)) {
                throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1130.xprop.value.invalid", (Object[])new Object[]{this.name, tranPropKey, tranProp}));
            }
            if (!execProps.containsKey("com.ibm.ws.concurrent.DEFAULT_CONTEXT")) {
                execProps.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
            }
            if (!execProps.containsKey("com.ibm.ws.concurrent.TASK_OWNER")) {
                execProps.put("com.ibm.ws.concurrent.TASK_OWNER", this.name.get());
            }
        }
        return execProps;
    }

    @Trivial
    final String getIdentifier(String policyExecutorIdentifier) {
        return policyExecutorIdentifier.startsWith("managed") ? policyExecutorIdentifier : this.name.get() + " (" + policyExecutorIdentifier + ')';
    }

    public ThreadContext getThreadContext() {
        if (this.mpContextService == null || !MPContextPropagationVersion.atLeast(MPContextPropagationVersion.V1_1)) {
            throw new UnsupportedOperationException();
        }
        return (ThreadContext)this.mpContextService;
    }

    @Trivial
    public int hashCode() {
        return this.hash;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Map.Entry<Collection<Callable<T>>, TaskLifeCycleCallback[]> entry = this.createCallbacks(tasks);
        tasks = entry.getKey();
        PolicyTaskCallback[] callbacks = entry.getValue();
        PolicyExecutor executor = callbacks.length > 0 ? callbacks[callbacks.length - 1].policyExecutor : this.policyExecutor;
        return executor.invokeAll(tasks, callbacks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Map.Entry<Collection<Callable<T>>, TaskLifeCycleCallback[]> entry = this.createCallbacks(tasks);
        tasks = entry.getKey();
        PolicyTaskCallback[] callbacks = entry.getValue();
        PolicyExecutor executor = callbacks.length > 0 ? callbacks[0].policyExecutor : this.policyExecutor;
        return executor.invokeAll(tasks, callbacks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        Map.Entry<Collection<Callable<T>>, TaskLifeCycleCallback[]> entry = this.createCallbacks(tasks);
        tasks = entry.getKey();
        PolicyTaskCallback[] callbacks = entry.getValue();
        PolicyExecutor executor = callbacks.length > 0 ? callbacks[0].policyExecutor : this.policyExecutor;
        return (T)executor.invokeAny(tasks, callbacks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Map.Entry<Collection<Callable<T>>, TaskLifeCycleCallback[]> entry = this.createCallbacks(tasks);
        tasks = entry.getKey();
        PolicyTaskCallback[] callbacks = entry.getValue();
        PolicyExecutor executor = callbacks.length > 0 ? callbacks[0].policyExecutor : this.policyExecutor;
        return (T)executor.invokeAny(tasks, callbacks, timeout, unit);
    }

    @Override
    @Trivial
    public boolean isShutdown() {
        if (this.allowLifeCycleMethods) {
            return this.getNormalPolicyExecutor().isShutdown();
        }
        throw new IllegalStateException(new UnsupportedOperationException("isShutdown"));
    }

    @Override
    @Trivial
    public boolean isTerminated() {
        if (this.allowLifeCycleMethods) {
            return this.getNormalPolicyExecutor().isTerminated();
        }
        throw new IllegalStateException(new UnsupportedOperationException("isTerminated"));
    }

    public <U> CompletableFuture<U> newIncompleteFuture() {
        if (ManagedCompletableFuture.JAVA8) {
            return new ManagedCompletableFuture(new CompletableFuture(), this, null);
        }
        return new ManagedCompletableFuture(this, null);
    }

    public CompletableFuture<Void> runAsync(Runnable runnable) {
        return ManagedCompletableFuture.runAsync(runnable, this);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, target="(id=unbound)")
    protected void setConcurrencyPolicy(ConcurrencyPolicy svc) {
        this.policyExecutor = svc.getExecutor();
    }

    @Reference(policy=ReferencePolicy.STATIC)
    protected void setConcurrencyService(ConcurrencyService svc) {
        this.concurrencySvc = svc;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, target="(id=unbound)")
    protected void setContextService(ServiceReference<WSContextService> ref) {
        this.contextSvcRef.setReference(ref);
    }

    @Reference(service=JavaEEVersion.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEEVersion(ServiceReference<JavaEEVersion> ref) {
        String version = (String)ref.getProperty("version");
        if (version == null) {
            this.eeVersion = 0;
        } else {
            int dot = version.indexOf(46);
            String major = dot > 0 ? version.substring(0, dot) : version;
            this.eeVersion = Integer.parseInt(major);
        }
        this.eeVersionRef = ref;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, target="(id=unbound)")
    protected void setLongRunningPolicy(ConcurrencyPolicy svc) {
        this.longRunningPolicyExecutorRef.set(svc.getExecutor());
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, target="(component.name=com.ibm.ws.transaction.context.provider)")
    protected void setTransactionContextProvider(ServiceReference<ThreadContextProvider> ref) {
        this.tranContextProviderRef.setReference(ref);
    }

    @Override
    @Trivial
    public void shutdown() {
        if (!this.allowLifeCycleMethods) {
            throw new IllegalStateException(new UnsupportedOperationException("shutdown"));
        }
        this.getNormalPolicyExecutor().shutdown();
    }

    @Override
    @Trivial
    public List<Runnable> shutdownNow() {
        if (this.allowLifeCycleMethods) {
            return this.getNormalPolicyExecutor().shutdownNow();
        }
        throw new IllegalStateException(new UnsupportedOperationException("shutdownNow"));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        ThreadContextDescriptor contextDescriptor;
        Map<String, String> execProps = this.getExecutionProperties(task);
        if (task instanceof ContextualAction) {
            ContextualAction a = (ContextualAction)((Object)task);
            contextDescriptor = a.getContextDescriptor();
            task = (Callable)a.getAction();
        } else {
            WSContextService contextSvc = this.getContextService();
            contextDescriptor = contextSvc.captureThreadContext(execProps, new Map[0]);
        }
        TaskLifeCycleCallback callback = new TaskLifeCycleCallback(this, contextDescriptor);
        return callback.policyExecutor.submit(task, (PolicyTaskCallback)callback);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        ThreadContextDescriptor contextDescriptor;
        Map<String, String> execProps = this.getExecutionProperties(task);
        if (task instanceof ContextualAction) {
            ContextualAction a = (ContextualAction)((Object)task);
            contextDescriptor = a.getContextDescriptor();
            task = (Runnable)a.getAction();
        } else {
            WSContextService contextSvc = this.getContextService();
            contextDescriptor = contextSvc.captureThreadContext(execProps, new Map[0]);
        }
        TaskLifeCycleCallback callback = new TaskLifeCycleCallback(this, contextDescriptor);
        return callback.policyExecutor.submit(task, result, (PolicyTaskCallback)callback);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(task, null);
    }

    public <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return ManagedCompletableFuture.supplyAsync(supplier, this);
    }

    com.ibm.wsspi.threadcontext.ThreadContext suspendTransaction() {
        com.ibm.wsspi.threadcontext.ThreadContext suspendedTranSnapshot;
        Map<String, String> XPROPS_SUSPEND_TRAN = this.eeVersion < 9 ? JAVAX_SUSPEND_TRAN : JAKARTA_SUSPEND_TRAN;
        ThreadContextProvider tranContextProvider = AccessController.doPrivileged(this.tranContextProviderAccessor);
        com.ibm.wsspi.threadcontext.ThreadContext threadContext = suspendedTranSnapshot = tranContextProvider == null ? null : tranContextProvider.captureThreadContext(XPROPS_SUSPEND_TRAN, null);
        if (suspendedTranSnapshot != null) {
            suspendedTranSnapshot.taskStarting();
        }
        return suspendedTranSnapshot;
    }

    @Trivial
    public String toString() {
        String s = this.name.get();
        return s.startsWith("ManagedExecutor@") ? s : "ManagedExecutor@" + Integer.toHexString(this.hashCode()) + ' ' + s;
    }

    protected void unsetConcurrencyPolicy(ConcurrencyPolicy svc) {
    }

    protected void unsetConcurrencyService(ConcurrencyService svc) {
    }

    protected void unsetContextService(ServiceReference<WSContextService> ref) {
        this.contextSvcRef.unsetReference(ref);
    }

    protected void unsetEEVersion(ServiceReference<JavaEEVersion> ref) {
        if (this.eeVersionRef == ref) {
            this.eeVersionRef = null;
            this.eeVersion = 0;
        }
    }

    protected void unsetLongRunningPolicy(ConcurrencyPolicy svc) {
        this.longRunningPolicyExecutorRef.compareAndSet(svc.getExecutor(), null);
    }

    protected void unsetTransactionContextProvider(ServiceReference<ThreadContextProvider> ref) {
        this.tranContextProviderRef.unsetReference(ref);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = -332648030823886061L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                ForkJoinPool.commonPool();
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.internal.ManagedExecutorServiceImpl$1", 1.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
            }
        });
        tc = Tr.register(ManagedExecutorServiceImpl.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
        JAKARTA_SUSPEND_TRAN = Collections.singletonMap("jakarta.enterprise.concurrent.TRANSACTION", "SUSPEND");
        JAVAX_SUSPEND_TRAN = Collections.singletonMap("javax.enterprise.concurrent.TRANSACTION", "SUSPEND");
    }
}

