/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.cdi.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxws.ImplBeanCustomizer;
import com.ibm.ws.jaxws.cdi.component.JAXWSCDIServiceImplByJndi;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="ImplBeanCustomizer", immediate=true, property={"service.vendor=IBM"})
public class JaxWsImplBeanCDICustomizer
implements ImplBeanCustomizer {
    private static final TraceComponent tc = Tr.register(JaxWsImplBeanCDICustomizer.class, null, null);
    private final AtomicServiceReference<ManagedObjectService> managedObjectServiceRef = new AtomicServiceReference("managedObjectService");
    static final long serialVersionUID = -4949292008513482108L;

    private <T> T getBeanFromCDI(Class<T> clazz, Container container) {
        if (!this.isCDIEnabled()) {
            return null;
        }
        ManagedObject<?> newServiceObject = null;
        newServiceObject = this.getClassFromManagedObject(clazz, container);
        if (newServiceObject != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Get instance from CDI " + clazz.getName()), (Object[])new Object[0]);
            }
            return (T)newServiceObject.getObject();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Get instance from CDI is null , use from ws for " + clazz.getName()), (Object[])new Object[0]);
        }
        return null;
    }

    @FFDCIgnore(value={Exception.class})
    private ManagedObject<?> getClassFromManagedObject(Class<?> clazz, Container container) {
        ManagedObject bean;
        block3: {
            ManagedObjectFactory<?> managedObjectFactory = this.getManagedObjectFactory(clazz, container);
            bean = null;
            try {
                bean = managedObjectFactory.createManagedObject();
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Couldn't create object instance from ManagedObjectFactory for : " + clazz.getName() + ", but ignore the FFDC: " + e.toString()), (Object[])new Object[0]);
            }
        }
        if (bean == null) {
            return null;
        }
        return bean;
    }

    @FFDCIgnore(value={NameNotFoundException.class})
    private BeanManager getBeanManager() {
        BeanManager manager;
        block4: {
            manager = null;
            try {
                InitialContext initialContext = new InitialContext();
                manager = (BeanManager)initialContext.lookup("java:comp/BeanManager");
                JAXWSCDIServiceImplByJndi.setBeanManager(manager);
            }
            catch (NameNotFoundException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Couldn't get BeanManager through JNDI: java:comp/BeanManager, but ignore the FFDC: " + e.toString()), (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxws.cdi.component.JaxWsImplBeanCDICustomizer", (String)"140", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Couldn't get BeanManager through JNDI: java:comp/BeanManager. " + e.toString()), (Object[])new Object[0]);
            }
        }
        return manager;
    }

    private boolean isCDIEnabled() {
        BeanManager beanManager = this.getBeanManager();
        return beanManager != null;
    }

    public <T> T onPrepareImplBean(Class<T> cls, Container container) {
        T instance = null;
        instance = this.getBeanFromCDI(cls, container);
        return instance;
    }

    @Activate
    protected void activate(ComponentContext cContext, Map<String, Object> properties) throws Exception {
        this.managedObjectServiceRef.activate(cContext);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.managedObjectServiceRef.deactivate(cc);
    }

    @Reference(name="managedObjectService", service=ManagedObjectService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setManagedObjectService(ServiceReference<ManagedObjectService> ref) {
        this.managedObjectServiceRef.setReference(ref);
    }

    protected void unsetManagedObjectService(ServiceReference<ManagedObjectService> ref) {
        this.managedObjectServiceRef.unsetReference(ref);
    }

    /*
     * WARNING - void declaration
     */
    private ManagedObjectFactory<?> getManagedObjectFactory(Class<?> clazz, Container container) {
        ManagedObjectFactory mof;
        block5: {
            if (container == null) {
                return null;
            }
            mof = null;
            try {
                ManagedObjectService mos = (ManagedObjectService)this.managedObjectServiceRef.getServiceWithException();
                if (mos == null) {
                    return null;
                }
                ModuleMetaData mmd = JaxWsMetaDataManager.getModuleMetaData();
                mof = mos.createManagedObjectFactory(mmd, clazz, true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Successfully to create ManagedObjectFactory for class: " + clazz.getName()), (Object[])new Object[0]);
                }
            }
            catch (ManagedObjectException mos) {
                void e;
                FFDCFilter.processException((Throwable)mos, (String)"com.ibm.ws.jaxws.cdi.component.JaxWsImplBeanCDICustomizer", (String)"223", (Object)this, (Object[])new Object[]{clazz, container});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("Fail to create ManagedObjectFactory for class: " + clazz.getName() + " Exception is: " + e.toString()), (Object[])new Object[0]);
            }
        }
        return mof;
    }
}

