/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.richclient.buffer.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBufferPool;
import com.ibm.ws.sib.jfapchannel.impl.CommsClientServiceFacade;
import com.ibm.ws.sib.jfapchannel.richclient.buffer.impl.RichByteBufferImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;

public class RichByteBufferPool
extends WsByteBufferPool {
    private static final TraceComponent tc = SibTr.register(RichByteBufferPool.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private WsByteBufferPoolManager actualPoolManager = CommsClientServiceFacade.getBufferPoolManager();
    private ObjectPool byteBufferWrapperPool = new ObjectPool("WsByteBufferWrapperPool", 100);

    @Override
    public WsByteBuffer allocate(int size) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"allocate", (Object)size);
        }
        com.ibm.wsspi.bytebuffer.WsByteBuffer actualBuffer = this.actualPoolManager.allocate(size);
        RichByteBufferImpl returnBuffer = this.getFromPool();
        returnBuffer.reset(actualBuffer, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"allocate", (Object)returnBuffer);
        }
        return returnBuffer;
    }

    @Override
    public WsByteBuffer allocateDirect(int size) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"allocateDirect", (Object)size);
        }
        com.ibm.wsspi.bytebuffer.WsByteBuffer actualBuffer = this.actualPoolManager.allocateDirect(size);
        RichByteBufferImpl returnBuffer = this.getFromPool();
        returnBuffer.reset(actualBuffer, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"allocateDirect", (Object)returnBuffer);
        }
        return returnBuffer;
    }

    @Override
    public WsByteBuffer wrap(byte[] byteArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"wrap", (Object)byteArray);
        }
        com.ibm.wsspi.bytebuffer.WsByteBuffer actualBuffer = this.actualPoolManager.wrap(byteArray);
        RichByteBufferImpl returnBuffer = this.getFromPool();
        returnBuffer.reset(actualBuffer, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"wrap", (Object)returnBuffer);
        }
        return returnBuffer;
    }

    @Override
    public WsByteBuffer wrap(byte[] byteArray, int offset, int length) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"wrap", (Object)new Object[]{byteArray, offset, length});
        }
        com.ibm.wsspi.bytebuffer.WsByteBuffer actualBuffer = this.actualPoolManager.wrap(byteArray, offset, length);
        RichByteBufferImpl returnBuffer = this.getFromPool();
        returnBuffer.reset(actualBuffer, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"wrap", (Object)returnBuffer);
        }
        return returnBuffer;
    }

    public WsByteBuffer wrap(com.ibm.wsspi.bytebuffer.WsByteBuffer realBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"wrap", (Object)realBuffer);
        }
        RichByteBufferImpl returnBuffer = null;
        if (realBuffer != null) {
            returnBuffer = this.getFromPool();
            returnBuffer.reset(realBuffer, this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"wrap", (Object)returnBuffer);
        }
        return returnBuffer;
    }

    RichByteBufferImpl getFromPool() {
        RichByteBufferImpl buffer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getFromPool");
        }
        if ((buffer = (RichByteBufferImpl)this.byteBufferWrapperPool.remove()) == null) {
            buffer = new RichByteBufferImpl();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getFromPool", (Object)buffer);
        }
        return buffer;
    }

    void release(RichByteBufferImpl handler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"release", (Object)handler);
        }
        this.byteBufferWrapperPool.add((Object)handler);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"release");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/jfapchannel/buffer/impl/RichByteBufferPool.java, SIB.comms, WASX.SIB, uu1215.01 1.2");
        }
    }
}

