/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl.octracker;

import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.LinkLevelState;
import com.ibm.ws.sib.jfapchannel.framework.Framework;
import com.ibm.ws.sib.jfapchannel.impl.OutboundConnection;
import com.ibm.ws.sib.jfapchannel.impl.octracker.EndPointDescriptor;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.LinkedList;

public class IdleConnectionPool
implements AlarmListener {
    private static final TraceComponent tc = SibTr.register(IdleConnectionPool.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static IdleConnectionPool instance = null;
    private static final int DEFAULT_CONNECTION_CLOSE_TIMEOUT = 10000;
    private int connectionCloseTimeout;
    private final HashMap<EndPointDescriptor, LinkedList<Object[]>> descriptorToConnectionListMap = new HashMap();

    private IdleConnectionPool() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.connectionCloseTimeout = 10000;
        try {
            this.connectionCloseTimeout = Integer.parseInt(RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.CONNECTION_CLOSE_TIMEOUT", (String)"10000"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.connectionCloseTimeout < 0) {
            this.connectionCloseTimeout = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("connection close timeout = " + this.connectionCloseTimeout));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(OutboundConnection outboundConnection, EndPointDescriptor descriptor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"add", (Object)new Object[]{outboundConnection, descriptor});
        }
        if (this.connectionCloseTimeout == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"close timeout == 0, closing immediately");
            }
            outboundConnection.physicalClose(true);
        } else {
            LinkedList<Object> connectionList = null;
            Object[] listEntry = null;
            IdleConnectionPool idleConnectionPool = this;
            synchronized (idleConnectionPool) {
                connectionList = this.descriptorToConnectionListMap.get(descriptor);
                if (connectionList == null) {
                    connectionList = new LinkedList();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("pool does not contain other connections for this endpoint, adding new list: " + connectionList));
                    }
                    this.descriptorToConnectionListMap.put(descriptor, connectionList);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("connections already present in list: " + connectionList + " are"), (Object)connectionList.toArray());
                }
                AlarmValid alarmValid = new AlarmValid();
                listEntry = new Object[]{outboundConnection, alarmValid};
                connectionList.addLast(listEntry);
            }
            AlarmManager alarmManager = Framework.getInstance().getAlarmManager();
            AlarmManager.createDeferrable((long)this.connectionCloseTimeout, (AlarmListener)this, (Object)new Object[]{connectionList, listEntry});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"add");
        }
    }

    public synchronized OutboundConnection remove(EndPointDescriptor descriptor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove", (Object)descriptor);
        }
        LinkedList<Object[]> connectionList = this.descriptorToConnectionListMap.get(descriptor);
        OutboundConnection connection = null;
        if (connectionList != null && connectionList.size() > 0) {
            Object[] connEntry = connectionList.removeFirst();
            connection = (OutboundConnection)connEntry[0];
            ((AlarmValid)connEntry[1]).invalidate();
            LinkLevelState lls = (LinkLevelState)connection.getAttachment();
            if (lls != null) {
                lls.reset();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove", connection);
        }
        return connection;
    }

    public static IdleConnectionPool getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object alarmContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm", (Object)alarmContext);
        }
        boolean alarmValid = false;
        boolean presentInConnectionList = false;
        Object[] listEntry = null;
        IdleConnectionPool idleConnectionPool = this;
        synchronized (idleConnectionPool) {
            Object[] contextArray = (Object[])alarmContext;
            LinkedList connectionList = (LinkedList)contextArray[0];
            listEntry = (Object[])contextArray[1];
            alarmValid = ((AlarmValid)listEntry[1]).isValid();
            if (alarmValid) {
                presentInConnectionList = connectionList.remove(listEntry);
            }
        }
        if (presentInConnectionList) {
            OutboundConnection connection = (OutboundConnection)listEntry[0];
            connection.physicalClose(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"alarm");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/octracker/IdleConnectionPool.java, SIB.comms, WASX.SIB, uu1215.01 1.16");
        }
        instance = new IdleConnectionPool();
    }

    private static class AlarmValid {
        private boolean valid = true;

        private AlarmValid() {
        }

        protected synchronized boolean isValid() {
            return this.valid;
        }

        protected synchronized void invalidate() {
            this.valid = false;
        }
    }
}

