/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.IdTableFullException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.Iterator;

public class ConversationTable {
    private static final TraceComponent tc = SibTr.register(ConversationTable.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private final HashMap<ImmutableKey, ConversationImpl> idToConvTable;
    private short lastAllocatedId = 0;
    private final ConversationImpl reservedObject = new ConversationImpl();
    private final MutableKey mutableKey = new MutableKey();

    private void debugTraceTable() {
        Iterator<ImmutableKey> keyIterator = this.idToConvTable.keySet().iterator();
        SibTr.debug((Object)this, (TraceComponent)tc, (String)(this.getClass().toString() + "@" + this.hashCode()));
        while (keyIterator.hasNext()) {
            ImmutableKey key = keyIterator.next();
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("[key: " + key.getValue() + "] -> [value:" + this.idToConvTable.get(key) + "]"));
        }
    }

    public ConversationTable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.idToConvTable = new HashMap();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public synchronized boolean contains(int id) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"contains", (Object)("" + id));
        }
        this.mutableKey.setValue(id);
        boolean returnValue = this.idToConvTable.containsKey(this.mutableKey);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"contains", (Object)("" + returnValue));
        }
        return returnValue;
    }

    public synchronized void add(ConversationImpl c) {
        int id;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"add", (Object)c);
        }
        if (this.contains(id = c.getId())) {
            this.mutableKey.setValue(id);
            if (this.idToConvTable.get(this.mutableKey) == this.reservedObject) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("entry present but reserved: " + id));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("table already contains key of " + id));
                    this.debugTraceTable();
                }
                throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"CONVERSATIONTABLE_INTERNAL_SICJ0048", null, (String)"CONVERSATIONTABLE_INTERNAL_SICJ0048"));
            }
        }
        this.idToConvTable.put(new ImmutableKey(id), c);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"add", (Object)("[key: " + id + "] -> [value: " + c + "]"));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"add");
        }
    }

    public synchronized ConversationImpl get(int id) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"get", (Object)("" + id));
        }
        this.mutableKey.setValue(id);
        ConversationImpl retValue = this.idToConvTable.get(this.mutableKey);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"get", (Object)retValue);
        }
        return retValue;
    }

    public synchronized boolean remove(int id) {
        boolean result;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove", (Object)("" + id));
        }
        if (result = this.contains(id)) {
            this.mutableKey.setValue(id);
            this.idToConvTable.remove(this.mutableKey);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove", (Object)("" + result));
        }
        return result;
    }

    public synchronized Iterator iterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"iterator");
        }
        Iterator<ConversationImpl> returnValue = this.idToConvTable.values().iterator();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"iterator", returnValue);
        }
        return returnValue;
    }

    public synchronized void clear() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clear");
        }
        this.idToConvTable.clear();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clear");
        }
    }

    public synchronized int reserveId() throws IdTableFullException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reserveId");
        }
        boolean found = false;
        boolean full = false;
        short id = (short)(this.lastAllocatedId + 1);
        while (!found && !full) {
            if (id == 0) {
                id = 1;
            }
            full = id == this.lastAllocatedId;
            found = !this.contains(id);
            if (found) continue;
            id = (short)(id + 1);
        }
        if (!found) {
            throw new IdTableFullException();
        }
        this.idToConvTable.put(new ImmutableKey(id), this.reservedObject);
        this.lastAllocatedId = id;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reserveId", (Object)("" + id));
        }
        return id;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/ConversationTable.java, SIB.comms, WASX.SIB, uu1215.01 1.18");
        }
    }

    private class MutableKey
    extends ImmutableKey {
        public MutableKey() {
            super(0);
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    private class ImmutableKey {
        protected int value;

        public ImmutableKey(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            boolean result = o == null ? false : (o instanceof ImmutableKey ? this.value == ((ImmutableKey)o).value : false);
            return result;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

