/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.Transaction;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelper;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.Queue;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

public class LockedMessageEnumerationImpl
implements LockedMessageEnumeration {
    private static final TraceComponent tc = SibTr.register(LockedMessageEnumerationImpl.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private ConsumerSessionProxy consumerSession = null;
    private JsMessage[] messages = null;
    private int nextIndex = 0;
    ConversationHelper convHelper = null;
    private volatile boolean invalid = false;
    private Thread owningThread = null;
    private Object lmeOperationMonitor;

    public LockedMessageEnumerationImpl(ProxyQueue proxyQueue, Queue queue, JsMessage[] messages, Thread owningThread, Object lmeOperationMonitor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{proxyQueue, queue, messages, owningThread});
        }
        this.messages = new JsMessage[messages.length];
        System.arraycopy(messages, 0, this.messages, 0, messages.length);
        this.consumerSession = (ConsumerSessionProxy)proxyQueue.getDestinationSessionProxy();
        this.convHelper = proxyQueue.getConversationHelper();
        this.owningThread = owningThread;
        this.lmeOperationMonitor = lmeOperationMonitor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public LockedMessageEnumerationImpl(ConversationHelper convHelper, ConsumerSessionProxy session, JsMessage[] messages, Thread owningThread) {
        this.convHelper = convHelper;
        this.consumerSession = session;
        this.messages = new JsMessage[messages.length];
        System.arraycopy(messages, 0, this.messages, 0, messages.length);
        this.owningThread = owningThread;
        this.lmeOperationMonitor = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage nextLocked() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"nextLocked");
        }
        JsMessage retMsg = null;
        Object object = this.lmeOperationMonitor;
        synchronized (object) {
            this.checkValid();
            while (this.nextIndex != this.messages.length) {
                retMsg = this.messages[this.nextIndex];
                ++this.nextIndex;
                if (retMsg == null) continue;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"nextLocked", (Object)retMsg);
        }
        return retMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockCurrent() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIMessageNotLockedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockCurrent");
        }
        Object object = this.lmeOperationMonitor;
        synchronized (object) {
            this.checkValid();
            if (this.nextIndex == 0 || this.messages[this.nextIndex - 1] == null) {
                throw new SIIncorrectCallException(nls.getFormattedMessage("LME_UNLOCK_INVALID_MSG_SICO1017", null, null));
            }
            JsMessage retMsg = this.messages[this.nextIndex - 1];
            if (CommsUtils.isRecoverable((SIBusMessage)retMsg, this.consumerSession.getUnrecoverableReliability())) {
                this.convHelper.unlockSet(new SIMessageHandle[]{retMsg.getMessageHandle()});
            }
            this.messages[this.nextIndex - 1] = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockCurrent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCurrent(SITransaction transaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIMessageNotLockedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteCurrent", (Object)transaction);
        }
        Object object = this.lmeOperationMonitor;
        synchronized (object) {
            this.checkValid();
            if (this.nextIndex == 0 || this.messages[this.nextIndex - 1] == null) {
                throw new SIIncorrectCallException(nls.getFormattedMessage("LME_DELETE_INVALID_MSG_SICO1018", null, null));
            }
            JsMessage retMsg = this.messages[this.nextIndex - 1];
            if (CommsUtils.isRecoverable((SIBusMessage)retMsg, this.consumerSession.getUnrecoverableReliability())) {
                JsMessage[] msgs = new JsMessage[]{retMsg};
                if (transaction != null) {
                    SITransaction sITransaction = transaction;
                    synchronized (sITransaction) {
                        if (!((Transaction)transaction).isValid()) {
                            throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                        }
                        this.deleteMessages(msgs, transaction);
                    }
                } else {
                    this.deleteMessages(msgs, null);
                }
            }
            this.messages[this.nextIndex - 1] = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteCurrent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSeen(SITransaction transaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIMessageNotLockedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteSeen", (Object)transaction);
        }
        Object object = this.lmeOperationMonitor;
        synchronized (object) {
            this.checkValid();
            int numSeenMsgs = this.getSeenMessageCount();
            if (numSeenMsgs > 0) {
                JsMessage[] seenRecoverableMessages = new JsMessage[numSeenMsgs];
                int numOfMessagesNeedingDeleting = 0;
                for (int i = 0; i < this.nextIndex; ++i) {
                    if (this.messages[i] == null) continue;
                    if (CommsUtils.isRecoverable((SIBusMessage)this.messages[i], this.consumerSession.getUnrecoverableReliability())) {
                        seenRecoverableMessages[numOfMessagesNeedingDeleting] = this.messages[i];
                        ++numOfMessagesNeedingDeleting;
                    }
                    this.messages[i] = null;
                }
                if (numOfMessagesNeedingDeleting > 0) {
                    if (transaction != null) {
                        SITransaction sITransaction = transaction;
                        synchronized (sITransaction) {
                            if (!((Transaction)transaction).isValid()) {
                                throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
                            }
                            this.deleteMessages(seenRecoverableMessages, transaction);
                        }
                    } else {
                        this.deleteMessages(seenRecoverableMessages, null);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteSeen");
        }
    }

    private void deleteMessages(JsMessage[] messagesToDelete, SITransaction transaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIMessageNotLockedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteMessages");
        }
        int priority = 7;
        if (transaction != null) {
            Transaction commsTransaction = (Transaction)transaction;
            priority = commsTransaction.getLowestMessagePriority();
            commsTransaction.associateConsumer(this.consumerSession);
        }
        SIMessageHandle[] messageHandles = new SIMessageHandle[messagesToDelete.length];
        for (int x = 0; x < messagesToDelete.length; ++x) {
            if (messagesToDelete[x] == null) continue;
            messageHandles[x] = messagesToDelete[x].getMessageHandle();
        }
        this.convHelper.deleteMessages(messageHandles, transaction, priority);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteMessages");
        }
    }

    public void resetCursor() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"resetCursor");
        }
        this.nextIndex = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"resetCursor");
        }
    }

    public int getRemainingMessageCount() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRemainingMessageCount");
        }
        this.checkValid();
        int remain = this.getUnSeenMessageCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRemainingMessageCount", (Object)("" + remain));
        }
        return remain;
    }

    private int getSeenMessageCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSeenMessageCount");
        }
        int seenMsgs = 0;
        for (int x = 0; x < this.nextIndex; ++x) {
            if (this.messages[x] == null) continue;
            ++seenMsgs;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSeenMessageCount", (Object)("" + seenMsgs));
        }
        return seenMsgs;
    }

    private int getUnSeenMessageCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUnseenMessageCount");
        }
        int remain = 0;
        for (int x = this.nextIndex; x < this.messages.length; ++x) {
            if (this.messages[x] == null) continue;
            ++remain;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUnseenMessageCount", (Object)("" + remain));
        }
        return remain;
    }

    public void unlockUnseen() throws SIResourceException, SIConnectionDroppedException, SIConnectionLostException, SIIncorrectCallException, SIMessageNotLockedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockUnseen");
        }
        SIMessageHandle[] idsToUnlock = new SIMessageHandle[this.getUnSeenMessageCount()];
        int arrayPos = 0;
        for (int startingIndex = this.nextIndex; startingIndex < this.messages.length; ++startingIndex) {
            if (this.messages[startingIndex] == null) continue;
            if (CommsUtils.isRecoverable((SIBusMessage)this.messages[startingIndex], this.consumerSession.getUnrecoverableReliability())) {
                idsToUnlock[arrayPos] = this.messages[startingIndex].getMessageHandle();
                ++arrayPos;
            }
            this.messages[startingIndex] = null;
        }
        if (idsToUnlock.length != arrayPos) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"compacting array");
            }
            SIMessageHandle[] tempArray = new SIMessageHandle[arrayPos];
            System.arraycopy(idsToUnlock, 0, tempArray, 0, arrayPos);
            idsToUnlock = tempArray;
        }
        this.convHelper.unlockSet(idsToUnlock);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockUnseen");
        }
    }

    public ConsumerSession getConsumerSession() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerSession");
        }
        this.checkValid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerSession");
        }
        return this.consumerSession;
    }

    private void checkValid() throws SISessionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkValid");
        }
        if (this.invalid || this.consumerSession.isClosed() || Thread.currentThread() != this.owningThread) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"not valid", (Object)this);
            }
            this.invalid = true;
            throw new SISessionUnavailableException(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkValid");
        }
    }

    protected void markInvalid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"markInvalid");
        }
        this.invalid = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"markInvalid");
        }
    }

    public String toString() {
        String arrContents = "[ ";
        for (int x = 0; x < this.messages.length; ++x) {
            arrContents = x == this.nextIndex ? arrContents + "* " + this.messages[x] : arrContents + this.messages[x];
            arrContents = x == this.messages.length - 1 ? arrContents + " ]" : arrContents + ", ";
        }
        return "LockedMessageEnumerationImpl@" + Integer.toHexString(this.hashCode()) + "- contents: " + arrContents + ", invalid: " + this.invalid + ", nextIndex: " + this.nextIndex + ", consumerSession: " + this.consumerSession + ", owningThread: " + this.owningThread + ", currentThread: " + Thread.currentThread();
    }

    public boolean hasNext() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIIncorrectCallException {
        boolean hasNext;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasNext");
        }
        boolean bl = hasNext = this.getRemainingMessageCount() > 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasNext", (Object)("" + hasNext));
        }
        return hasNext;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/impl/LockedMessageEnumerationImpl.java, SIB.comms, WASX.SIB, uu1215.01 1.53");
        }
    }
}

