/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.linkedlist2;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.utils.linkedlist2.Entry;
import com.ibm.ws.sib.utils.ras.SibTr;

public class LinkedList {
    protected Entry first = null;
    protected Entry last = null;
    private static final TraceComponent tc = SibTr.register(LinkedList.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public Entry put(Entry entry) {
        return this.insertAtBottom(entry);
    }

    public Entry insertAtBottom(Entry entry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"insertAtBottom", (Object)new Object[]{entry});
        }
        if (entry.parentList == null) {
            if (this.last == null) {
                entry.previous = null;
                entry.next = null;
                this.first = entry;
                this.last = entry;
                entry.parentList = this;
            } else {
                this.insertAfter(entry, this.last);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"insertAtBottom", (Object)entry);
            }
            return entry;
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList", "1:127:1.3"}, null));
        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList.insertAtBottom", (String)"1:133:1.3", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList", "1:140:1.3"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"insertAtBottom", (Object)((Object)e));
        }
        throw e;
    }

    public Entry insertAtTop(Entry entry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"insertAtTop", (Object)new Object[]{entry});
        }
        if (entry.parentList == null) {
            if (this.first == null) {
                entry.previous = null;
                entry.next = null;
                this.last = entry;
            } else {
                entry.previous = null;
                entry.next = this.first;
                this.first.previous = entry;
            }
            this.first = entry;
            entry.parentList = this;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"insertAtTop", (Object)entry);
            }
            return entry;
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList", "1:201:1.3"}, null));
        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList.insertAtTop", (String)"1:207:1.3", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList", "1:214:1.3"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"insertAtTop", (Object)((Object)e));
        }
        throw e;
    }

    public Entry insertAfter(Entry newEntry, Entry insertAfter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"insertAfter", (Object)new Object[]{newEntry, insertAfter});
        }
        Entry insertedEntry = null;
        if (newEntry != null && insertAfter != null) {
            insertedEntry = insertAfter.insertAfter(newEntry);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"insertAfter", (Object)insertedEntry);
        }
        return insertedEntry;
    }

    public boolean contains(Entry entry) {
        boolean contains;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"contains", (Object)new Object[]{entry});
        }
        boolean bl = contains = entry != null && entry.parentList == this;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"contains");
        }
        return contains;
    }

    public Entry remove(Entry removePointer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{removePointer});
        }
        Entry removedEntry = null;
        if (!this.contains(removePointer)) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList", "1:291:1.3"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList.remove", (String)"1:297:1.3", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.LinkedList", "1:304:1.3"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"remove", (Object)((Object)e));
            }
            throw e;
        }
        removedEntry = removePointer.remove();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove", (Object)removedEntry);
        }
        return removedEntry;
    }

    public Entry getFirst() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getFirst");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getFirst", (Object)this.first);
        }
        return this.first;
    }

    public Entry getLast() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLast");
            SibTr.exit((TraceComponent)tc, (String)"getLast", (Object)this.last);
        }
        return this.last;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(indent);
        buffer.append("Head");
        String entryIndent = indent + "  ";
        Entry printPointer = this.first;
        while (printPointer != null) {
            buffer.append("\n");
            buffer.append(printPointer.toString(entryIndent));
            printPointer = printPointer.next;
        }
        buffer.append("\n");
        buffer.append(indent);
        buffer.append("Tail");
        return buffer.toString();
    }
}

