/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPInvalidRuntimeIDException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.LocalizationPoint;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLocalQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueueControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPXmitPoint;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.MediatedMessageHandlerControl;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Iterator;

public class Queue
extends MediatedMessageHandlerControl
implements SIMPQueueControllable {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(Queue.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public Queue(MessageProcessor messageProcessor, BaseDestinationHandler destination) {
        super(messageProcessor, destination);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Queue", (Object)new Object[]{messageProcessor, destination});
            SibTr.exit((TraceComponent)tc, (String)"Queue", (Object)this);
        }
    }

    public SIMPLocalQueuePointControllable getLocalQueuePointControl() throws SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalQueuePointControl");
        }
        this.assertMessageHandlerNotCorrupt();
        SIMPLocalQueuePointControllable control = null;
        LocalizationPoint is = this.baseDest.getLocalLocalizationPoint();
        if (is != null) {
            control = (SIMPLocalQueuePointControllable)is.getControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalQueuePointControl", (Object)control);
        }
        return control;
    }

    public SIMPIterator getRemoteQueuePointIterator() throws SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteQueuePointIterator");
        }
        this.assertMessageHandlerNotCorrupt();
        Index index = this.baseDest.getRemoteQueuePoints();
        SIMPIterator itr = index.iterator();
        BasicSIMPIterator returnItr = new BasicSIMPIterator((Iterator)itr);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteQueuePointIterator", (Object)returnItr);
        }
        return returnItr;
    }

    public SIMPRemoteQueuePointControllable getRemoteQueuePointControlByID(String id) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteQueuePointControlByID", (Object)id);
        }
        this.assertMessageHandlerNotCorrupt();
        SIMPIterator remoteQueuePoints = this.getRemoteQueuePointIterator();
        SIMPRemoteQueuePointControllable rqp = null;
        while (remoteQueuePoints.hasNext()) {
            SIMPXmitPoint nextRqp = (SIMPXmitPoint)remoteQueuePoints.next();
            String rqpID = nextRqp.getId();
            if (!id.equals(rqpID)) continue;
            rqp = (SIMPRemoteQueuePointControllable)nextRqp;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteQueuePointControlByID", rqp);
        }
        return rqp;
    }

    public SIMPRemoteQueuePointControllable getRemoteQueuePointControlByMEUuid(String id) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteQueuePointControlByMEUuid", (Object)new Object[]{id});
        }
        this.assertMessageHandlerNotCorrupt();
        SIBUuid8 uuid = null;
        try {
            uuid = new SIBUuid8(id);
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.Queue.getRemoteQueuePointControlByMEUuid", (String)"1:172:1.30", (Object)this);
            SIMPInvalidRuntimeIDException finalE = new SIMPInvalidRuntimeIDException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"Queue.getRemoteQueuePointControlByMEUuid", "1:180:1.30", e, id}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"Queue.getRemoteQueuePointControlByMEUuid", "1:188:1.30", e, id});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRemoteQueuePointControlByMEUuid", (Object)((Object)finalE));
            }
            throw finalE;
        }
        SIMPRemoteQueuePointControllable remote = this.baseDest.getRemoteQueuePointControl(uuid, false);
        if (remote == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"Queue.getRemoteQueuePointControlByMEUuid", "1:204:1.30", id}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"Queue.getRemoteQueuePointControlByMEUuid", "1:211:1.30", id});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRemoteQueuePointControlByMEUuid", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteQueuePointControlByMEUuid", (Object)remote);
        }
        return remote;
    }
}

