/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.impl.BusHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.runtime.SIMPForeignBusControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPMessageProcessorControllable;
import com.ibm.ws.sib.processor.runtime.SIMPVirtualLinkControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.LocalQueuePoint;
import com.ibm.ws.sib.processor.runtime.impl.MessageProcessorControl;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Map;

public class ForeignBus
extends AbstractControlAdapter
implements SIMPForeignBusControllable {
    private MessageProcessorControl _mpControl;
    private MessageProcessor _messageProcessor;
    private DestinationManager _destinationManager;
    private BusHandler _foreignBus;
    private static final TraceComponent tc = SibTr.register(LocalQueuePoint.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public ForeignBus(MessageProcessor messageProcessor, BusHandler foreignBus) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ForeignBus", (Object)new Object[]{messageProcessor, foreignBus});
        }
        this._mpControl = (MessageProcessorControl)messageProcessor.getControlAdapter();
        this._destinationManager = messageProcessor.getDestinationManager();
        this._messageProcessor = messageProcessor;
        this._foreignBus = foreignBus;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ForeignBus", (Object)this);
        }
    }

    public SIMPIterator getProducerIterator() {
        return null;
    }

    public SIMPVirtualLinkControllable getVirtualLinkControlAdapter() {
        return (SIMPVirtualLinkControllable)this._foreignBus.getResolvedDestinationHandler().getControlAdapter();
    }

    public SIMPMessageProcessorControllable getMessageProcessor() {
        return this._mpControl;
    }

    public boolean isLocal() {
        boolean isLocal;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLocal");
        }
        boolean bl = isLocal = this._foreignBus.getResolvedDestinationHandler().getLocalLocalizationPoint() != null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isLocal", (Object)new Boolean(isLocal));
        }
        return isLocal;
    }

    public boolean isAlias() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAlias");
            SibTr.exit((TraceComponent)tc, (String)"isAlias", (Object)Boolean.TRUE);
        }
        return true;
    }

    public boolean isForeign() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isForeign");
            SibTr.exit((TraceComponent)tc, (String)"isForeign", (Object)Boolean.FALSE);
        }
        return false;
    }

    public SIBUuid12 getUUID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUUID");
        }
        SIBUuid12 uuid = this._foreignBus.getUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUUID", (Object)uuid);
        }
        return uuid;
    }

    public String getDescription() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDescription");
        }
        String desc = this._foreignBus.getDescription();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDescription", (Object)desc);
        }
        return desc;
    }

    public Map getDestinationContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationContext");
        }
        Map context = this._foreignBus.getDefinition().getDestinationContext();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationContext", (Object)context);
        }
        return context;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._foreignBus == null || !this._foreignBus.isInStore()) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"ForeignBus.assertValidControllable", "1:205:1.22", this._foreignBus}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._destinationManager = null;
        this._foreignBus = null;
        this._mpControl = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
    }

    public SIMPIterator getBrowserIterator() {
        return null;
    }

    public SIMPIterator getConsumerIterator() {
        return null;
    }

    public boolean isSystem() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSystem");
        }
        boolean isSystem = this._foreignBus.isSystem();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSystem", (Object)new Boolean(isSystem));
        }
        return isSystem;
    }

    public boolean isTemporary() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTemporary");
        }
        boolean isTemporary = this._foreignBus.isTemporary();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isTemporary", (Object)new Boolean(isTemporary));
        }
        return isTemporary;
    }

    public String getState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        String state = this._destinationManager.getForeignBusIndex().getState(this._foreignBus).toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState", (Object)state);
        }
        return state;
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        String name = this._foreignBus.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)name);
        }
        return name;
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        String id = this.getUUID().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)id);
        }
        return id;
    }

    public ForeignBusDefinition getForeignBusDefinition() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignBusDefinition");
        }
        ForeignBusDefinition busDef = this._messageProcessor.getForeignBus(this.getName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getForeignBusDefinition", (Object)busDef);
        }
        return busDef;
    }

    public int getDefaultPriority() {
        return this._foreignBus.getDefaultPriority();
    }

    public Reliability getDefaultReliability() {
        return this._foreignBus.getDefaultReliability();
    }

    public boolean isSendAllowed() {
        return this._foreignBus.isSendAllowed();
    }
}

