/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.ControllableProxySubscription;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.items.SIMPItem;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.processor.proxyhandler.Neighbours;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public final class MESubscription
extends SIMPItem {
    static final int NOP = 0;
    static final int SUBSCRIBE = 1;
    static final int UNSUBSCRIBE = 2;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(MESubscription.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 1;
    private String _topic;
    private SIBUuid12 _topicSpaceUuid;
    private String _topicSpaceName;
    private String _foreignTopicSpaceName;
    private int _refCount;
    private boolean _marked = false;
    private MultiMEProxyHandler _proxyHandler;
    private PubSubOutputHandler _handler;
    private Neighbour _neighbour;
    private Neighbours _neighbours;
    DestinationHandler _destination;
    private boolean _foreignSecuredProxy;
    private String _meSubUserId;
    private ControllableProxySubscription _controllableProxySubscription = null;

    public MESubscription() {
    }

    MESubscription(SIBUuid12 topicSpaceUuid, String topicSpaceName, String topic, String foreignTopicSpace) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MESubscription", (Object)new Object[]{topicSpaceUuid, topicSpaceName, topic, foreignTopicSpace});
        }
        this._topicSpaceUuid = topicSpaceUuid;
        this._topic = topic;
        this._foreignTopicSpaceName = foreignTopicSpace;
        this._foreignSecuredProxy = false;
        this._meSubUserId = null;
        this._topicSpaceName = topicSpaceName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MESubscription", (Object)((Object)this));
        }
    }

    MESubscription(SIBUuid12 topicSpaceUuid, String topicSpaceName, String topic, String foreignTopicSpace, boolean foreignSecuredProxy, String mESubUserId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MESubscription", (Object)new Object[]{topicSpaceUuid, topicSpaceName, topic, foreignTopicSpace, new Boolean(foreignSecuredProxy), mESubUserId});
        }
        this._topicSpaceUuid = topicSpaceUuid;
        this._topic = topic;
        this._foreignTopicSpaceName = foreignTopicSpace;
        this._foreignSecuredProxy = foreignSecuredProxy;
        this._meSubUserId = mESubUserId;
        this._topicSpaceName = topicSpaceName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MESubscription", (Object)((Object)this));
        }
    }

    int addRef() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addRef");
        }
        int ret = 0;
        if (this._refCount++ == 0) {
            ret = 1;
        }
        this.checkRefCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addRef", (Object)(String.valueOf(ret) + ":" + String.valueOf(this._refCount)));
        }
        return ret;
    }

    int removeRef() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeRef");
        }
        int ret = 0;
        if (--this._refCount == 0) {
            ret = 2;
        }
        this.checkRefCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeRef", (Object)(String.valueOf(ret) + ":" + String.valueOf(this._refCount)));
        }
        return ret;
    }

    final String getTopic() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopic");
            SibTr.exit((TraceComponent)tc, (String)"getTopic", (Object)this._topic);
        }
        return this._topic;
    }

    private final void checkRefCount() {
        if (this._refCount < 0) {
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:298:1.55"});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:305:1.55"}, null));
        }
    }

    final SIBUuid12 getTopicSpaceUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpaceUuid");
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpaceUuid", (Object)this._topicSpaceUuid);
        }
        return this._topicSpaceUuid;
    }

    final String getTopicSpaceName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpaceName");
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpaceName", (Object)this._topicSpaceName);
        }
        return this._topicSpaceName;
    }

    final String getMESubUserId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMESubUserId");
            SibTr.exit((TraceComponent)tc, (String)"getMESubUserId", (Object)this._meSubUserId);
        }
        return this._meSubUserId;
    }

    public void setMESubUserId(String userId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMESubUserId", (Object)userId);
        }
        this._meSubUserId = userId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMESubUserId");
        }
    }

    final boolean isForeignSecuredProxy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isForeignSecuredProxy");
            SibTr.exit((TraceComponent)tc, (String)"isForeignSecuredProxy", (Object)new Boolean(this._foreignSecuredProxy));
        }
        return this._foreignSecuredProxy;
    }

    public void setForeignSecuredProxy(boolean isFSP) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setForeignSecuredProxy", (Object)new Boolean(isFSP));
        }
        this._foreignSecuredProxy = isFSP;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setForeignSecuredProxy");
        }
    }

    void mark() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"mark");
            SibTr.exit((TraceComponent)tc, (String)"mark");
        }
        this._marked = true;
    }

    void unmark() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unmark");
            SibTr.exit((TraceComponent)tc, (String)"unmark");
        }
        this._marked = false;
    }

    boolean isMarked() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isMarked");
            SibTr.exit((TraceComponent)tc, (String)"isMarked", (Object)new Boolean(this._marked));
        }
        return this._marked;
    }

    public String toString() {
        return "MESubscription to topicspace " + this._topicSpaceUuid + " topic " + this._topic + " Count " + this._refCount;
    }

    public int getStorageStrategy() {
        return 4;
    }

    protected void registerForPostCommit(MultiMEProxyHandler proxyHandler, DestinationHandler destination, PubSubOutputHandler handler, Neighbour neighbour) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForPostCommit", (Object)new Object[]{proxyHandler, destination, handler, neighbour});
        }
        this._proxyHandler = proxyHandler;
        this._destination = destination;
        this._handler = handler;
        this._neighbour = neighbour;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForPostCommit");
        }
    }

    protected void registerForPostCommit(Neighbour neighbour, Neighbours neighbours) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForPostCommit", (Object)new Object[]{neighbour, neighbours});
        }
        this._proxyHandler = null;
        this._destination = null;
        this._handler = null;
        this._neighbour = neighbour;
        this._neighbours = neighbours;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForPostCommit");
        }
    }

    public void eventPostCommitAdd(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostCommitAdd(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)transaction);
        }
        try {
            if (this._proxyHandler != null) {
                this._controllableProxySubscription = this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().addPubSubOutputHandlerMatchTarget(this._handler, this._topicSpaceUuid, this._topic, this._foreignSecuredProxy, this._meSubUserId);
            }
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.MESubscription.eventPostCommitAdd", (String)"1:557:1.55", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:564:1.55", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:574:1.55", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd");
        }
    }

    public void eventPostCommitRemove(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostCommitRemove(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitRemove", (Object)transaction);
        }
        if (this._proxyHandler != null) {
            this._destination.getSubscriptionIndex().remove(this._controllableProxySubscription);
            this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().removePubSubOutputHandlerMatchTarget(this._controllableProxySubscription);
        }
        if (this._handler != null && (this._handler.getTopics() == null || this._handler.getTopics().length == 0)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Deleting PubSubOutputHandler " + this._handler));
            }
            this._destination.deletePubSubOutputHandler(this._neighbour.getUUID());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove");
        }
    }

    public void eventPostRollbackAdd(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostRollbackAdd(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)transaction);
        }
        if (this._handler != null) {
            this._handler.removeTopic(this._topic);
            if (this._handler.getTopics() == null || this._handler.getTopics().length == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Deleting PubSubOutputHandler " + this._handler));
                }
                this._destination.deletePubSubOutputHandler(this._neighbour.getUUID());
            }
        } else if (this._neighbours != null) {
            this._neighbours.removeTopicSpaceReference(this._neighbour.getUUID(), this, this._topicSpaceUuid, this._topic);
        }
        this._neighbour.removeSubscription(this._topicSpaceUuid, this._topic);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackAdd");
        }
    }

    public void eventPostRollbackRemove(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostRollbackRemove(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)transaction);
        }
        this._neighbour.addSubscription(this._topicSpaceUuid, this._topic, this);
        if (this._handler != null) {
            this._handler.addTopic(this._topic);
        } else if (this._neighbours != null) {
            this._neighbours.addTopicSpaceReference(this._neighbour.getUUID(), this._topicSpaceUuid, this._topic, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove");
        }
    }

    public void eventPostCommitUpdate(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostCommitAdd(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitUpdate", (Object)transaction);
        }
        if (this._proxyHandler != null) {
            this._destination.getSubscriptionIndex().remove(this._controllableProxySubscription);
            this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().removePubSubOutputHandlerMatchTarget(this._controllableProxySubscription);
        }
        try {
            if (this._proxyHandler != null) {
                this._controllableProxySubscription = this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().addPubSubOutputHandlerMatchTarget(this._handler, this._topicSpaceUuid, this._topic, this._foreignSecuredProxy, this._meSubUserId);
            }
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.MESubscription.eventPostCommitUpdate", (String)"1:738:1.55", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:745:1.55", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostCommitUpdate", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:755:1.55", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitUpdate");
        }
    }

    @Override
    public void restore(ObjectInputStream ois, int dataVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{ois, new Integer(dataVersion)});
        }
        try {
            HashMap hm = (HashMap)ois.readObject();
            this._topicSpaceUuid = new SIBUuid12((String)hm.get("iTopicSpace"));
            this._topic = (String)hm.get("iTopic");
            this._foreignTopicSpaceName = (String)hm.get("iForeignTopicSpaceName");
            if (hm.containsKey("isForeignSecuredProxy")) {
                this._foreignSecuredProxy = (Boolean)hm.get("isForeignSecuredProxy");
                this._meSubUserId = (String)hm.get("MESubUserId");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.MESubscription.restore", (String)"1:792:1.55", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:804:1.55", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    @Override
    public int getPersistentVersion() {
        return 1;
    }

    @Override
    public void getPersistentData(ObjectOutputStream oos) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)oos);
        }
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("iTopicSpace", this._topicSpaceUuid.toString());
            hm.put("iTopic", this._topic);
            hm.put("iForeignTopicSpaceName", this._foreignTopicSpaceName);
            hm.put("isForeignSecuredProxy", new Boolean(this._foreignSecuredProxy));
            hm.put("MESubUserId", this._meSubUserId);
            oos.writeObject(hm);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.MESubscription.getPersistentData", (String)"1:848:1.55", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:855:1.55", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:865:1.55", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.taggedValue("topicSpaceUuid", (Object)this._topicSpaceUuid);
        writer.newLine();
        writer.taggedValue("topic", (Object)this._topic);
        writer.newLine();
        writer.taggedValue("foreignTopicSpace", (Object)this._foreignTopicSpaceName);
        writer.newLine();
        writer.taggedValue("secured", (Object)this._foreignSecuredProxy);
        writer.newLine();
        writer.taggedValue("subUserId", (Object)this._meSubUserId);
    }

    final String getForeignTSName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignTSName");
            SibTr.exit((TraceComponent)tc, (String)"getForeignTSName", (Object)this._foreignTopicSpaceName);
        }
        return this._foreignTopicSpaceName;
    }

    public void setMatchspaceSub(ControllableProxySubscription sub) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMatchspaceSub", (Object)sub);
        }
        this._controllableProxySubscription = sub;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMatchspaceSub");
        }
    }

    public ControllableProxySubscription getMatchspaceSub() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMatchspaceSub");
            SibTr.exit((TraceComponent)tc, (String)"getMatchspaceSub", (Object)this._controllableProxySubscription);
        }
        return this._controllableProxySubscription;
    }
}

