/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.matchspace.MatchTarget;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.matching.ConsumerMonitorRegistrar;
import com.ibm.ws.sib.processor.matching.MessageProcessorMatching;
import com.ibm.ws.sib.processor.matching.MonitoredConsumer;
import com.ibm.ws.sib.processor.matching.SubscriptionRegistrar;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSetChangeCallback;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ConsumerMonitoring {
    private static final TraceComponent tc = SibTr.register(ConsumerMonitoring.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ConsumerMonitorRegistrar _consumerMonitorRegistrar;
    private SubscriptionRegistrar _subscriptionRegistrar;

    public ConsumerMonitoring(MessageProcessor messageProcessor, MessageProcessorMatching mpm) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ConsumerMonitoring", (Object)new Object[]{messageProcessor, mpm});
        }
        this._consumerMonitorRegistrar = new ConsumerMonitorRegistrar(messageProcessor, mpm);
        this._subscriptionRegistrar = new SubscriptionRegistrar(mpm);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConsumerMonitoring", (Object)this);
        }
    }

    public void addConsumer(Object key, String topic, String selectorString, MatchTarget target, boolean isWildcarded) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumer", (Object)new Object[]{key, topic, selectorString, target, new Boolean(isWildcarded)});
        }
        boolean selector = false;
        MonitoredConsumer mc = (MonitoredConsumer)target;
        if (selectorString != null && selectorString.trim().length() != 0) {
            selector = true;
        }
        if (selector) {
            if (this._subscriptionRegistrar.isKnownSelectorExpression(topic, isWildcarded)) {
                this.addConsumerForKnownTopicExpr(topic, selector, isWildcarded, mc, true);
            } else if (this._subscriptionRegistrar.isKnownNonSelectorExpression(topic, isWildcarded)) {
                this._subscriptionRegistrar.addNewConsumerForExpression(topic, mc, selector, isWildcarded);
                this.addConsumerForKnownTopicExpr(topic, selector, isWildcarded, mc, false);
            } else {
                this._subscriptionRegistrar.addNewConsumerForExpression(topic, mc, selector, isWildcarded);
                this.addConsumerForNewTopicExpr(topic, isWildcarded, mc);
            }
        } else if (this._subscriptionRegistrar.isKnownNonSelectorExpression(topic, isWildcarded)) {
            this.addConsumerForKnownTopicExpr(topic, selector, isWildcarded, mc, true);
        } else if (this._subscriptionRegistrar.isKnownSelectorExpression(topic, isWildcarded)) {
            this._subscriptionRegistrar.addNewConsumerForExpression(topic, mc, selector, isWildcarded);
            this.addConsumerForKnownTopicExpr(topic, selector, isWildcarded, mc, false);
        } else {
            this._subscriptionRegistrar.addNewConsumerForExpression(topic, mc, selector, isWildcarded);
            this.addConsumerForNewTopicExpr(topic, isWildcarded, mc);
        }
        if (selector) {
            mc.setSelector();
        }
        if (isWildcarded) {
            mc.setWildcarded();
        }
        mc.setTopic(topic);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumer");
        }
    }

    public void removeConsumer(MonitoredConsumer mc) {
        boolean removed;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumer", (Object)new Object[]{mc});
        }
        boolean selector = mc.isSelector();
        boolean isWildcarded = mc.isWildcarded();
        String topic = mc.getTopic();
        ArrayList consumerList = this._subscriptionRegistrar.getConsumerListForExpression(topic, selector, isWildcarded);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Found existing entry with list: " + consumerList + ", of size: " + consumerList.size()));
        }
        if (!(removed = consumerList.remove(mc))) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeConsumer", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitoring", "1:248:1.7"});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitoring", "1:256:1.7"}, null));
        }
        if (consumerList.isEmpty()) {
            this._subscriptionRegistrar.removeConsumerListForExpression(topic, selector, isWildcarded);
        }
        ArrayList exactMonitorList = (ArrayList)mc.getMatchingExactMonitorList();
        ArrayList wildcardMonitorList = (ArrayList)mc.getMatchingWildcardMonitorList();
        this._consumerMonitorRegistrar.removeConsumerFromRegisteredMonitors(mc, exactMonitorList, wildcardMonitorList);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumer");
        }
    }

    public boolean registerConsumerSetMonitor(ConnectionImpl connection, DestinationHandler topicSpace, SIBUuid12 topicSpaceUuid, String discriminatorExpression, String combinedExpression, ConsumerSetChangeCallback callback, boolean isWildcarded, String wildcardStem, MessageProcessorMatching mpm) throws SIDiscriminatorSyntaxException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)new Object[]{connection, topicSpace, topicSpaceUuid, discriminatorExpression, combinedExpression, callback, new Boolean(isWildcarded), wildcardStem});
        }
        boolean areConsumers = false;
        if (this._consumerMonitorRegistrar.checkExistingExpression(combinedExpression, isWildcarded)) {
            areConsumers = this._consumerMonitorRegistrar.registerCallbackOnExistingExpression(connection, combinedExpression, isWildcarded, callback);
        } else {
            HashSet localConsumers = new HashSet();
            HashSet remoteConsumers = new HashSet();
            if (!isWildcarded) {
                mpm.retrieveNonSelectorConsumers(topicSpace, discriminatorExpression, localConsumers, remoteConsumers);
                this._subscriptionRegistrar.findMatchingSelectorSubs(combinedExpression, localConsumers);
            } else {
                this._subscriptionRegistrar.findCandidateSubsForWildcardExpr(combinedExpression, wildcardStem, localConsumers);
            }
            areConsumers = this.registerCallbackOnNewExpression(connection, combinedExpression, isWildcarded, callback, localConsumers, remoteConsumers);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)new Boolean(areConsumers));
        }
        return areConsumers;
    }

    private boolean registerCallbackOnNewExpression(ConnectionImpl connection, String topicExpression, boolean isWildcarded, ConsumerSetChangeCallback callback, Set localConsumers, Set remoteConsumers) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerCallbackOnNewExpression", (Object)new Object[]{connection, topicExpression, new Boolean(isWildcarded), callback, localConsumers, remoteConsumers});
        }
        boolean areConsumers = false;
        ArrayList matchingConsumers = new ArrayList();
        if (localConsumers != null || remoteConsumers != null) {
            if (localConsumers != null) {
                matchingConsumers.addAll(localConsumers);
            }
            if (remoteConsumers != null) {
                matchingConsumers.addAll(remoteConsumers);
            }
        }
        boolean bl = areConsumers = !matchingConsumers.isEmpty();
        if (areConsumers) {
            for (MonitoredConsumer mc : matchingConsumers) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Add registration to consumer: " + mc));
                }
                if (isWildcarded) {
                    mc.addMatchingWildcardMonitor(topicExpression);
                    continue;
                }
                mc.addMatchingExactMonitor(topicExpression);
            }
        }
        this._consumerMonitorRegistrar.registerCallbackOnNewExpression(connection, topicExpression, isWildcarded, callback, matchingConsumers);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerCallbackOnNewExpression", (Object)new Boolean(areConsumers));
        }
        return areConsumers;
    }

    public void deregisterConsumerSetMonitor(ConnectionImpl connection, ConsumerSetChangeCallback callback) throws SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterConsumerSetMonitor", (Object)new Object[]{connection, callback});
        }
        this._consumerMonitorRegistrar.deregisterMonitor(connection, callback);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterConsumerSetMonitor");
        }
    }

    public void removeConsumerSetMonitors(ConnectionImpl connection) throws SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerSetMonitors", (Object)new Object[]{connection});
        }
        this._consumerMonitorRegistrar.removeConsumerSetMonitors(connection);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerSetMonitors");
        }
    }

    private void addConsumerForKnownTopicExpr(String topic, boolean selector, boolean isWildcarded, MonitoredConsumer mc, boolean matchedOnSelector) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumerForKnownTopicExpr", (Object)new Object[]{topic, new Boolean(selector), new Boolean(isWildcarded), mc, new Boolean(matchedOnSelector)});
        }
        ArrayList consumerList = null;
        consumerList = matchedOnSelector ? this._subscriptionRegistrar.getConsumerListForExpression(topic, selector, isWildcarded) : this._subscriptionRegistrar.getConsumerListForExpression(topic, !selector, isWildcarded);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Found existing entry with list: " + consumerList + ", of size: " + consumerList.size()));
        }
        MonitoredConsumer existingmc = (MonitoredConsumer)consumerList.get(0);
        ArrayList exactMonitorList = (ArrayList)existingmc.getMatchingExactMonitorList();
        mc.setMatchingExactMonitorList(exactMonitorList);
        ArrayList wildcardMonitorList = (ArrayList)existingmc.getMatchingWildcardMonitorList();
        mc.setMatchingWildcardMonitorList(wildcardMonitorList);
        if (matchedOnSelector) {
            consumerList.add(mc);
        }
        this._consumerMonitorRegistrar.addConsumerToRegisteredMonitors(mc, exactMonitorList, wildcardMonitorList);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumerForKnownTopicExpr");
        }
    }

    private void addConsumerForNewTopicExpr(String topicExpression, boolean isWildcarded, MonitoredConsumer mc) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumerForNewTopicExpr", (Object)new Object[]{topicExpression, new Boolean(isWildcarded), mc});
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Add new reference");
        }
        if (isWildcarded) {
            this._consumerMonitorRegistrar.matchNewWildcardConsumerToMonitors(topicExpression, mc);
        } else {
            this._consumerMonitorRegistrar.matchNewExactConsumerToMonitors(topicExpression, mc);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumerForNewTopicExpr");
        }
    }

    public ConsumerMonitorRegistrar getConsumerMonitorRegistrar() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerMonitorRegistrar");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerMonitorRegistrar", (Object)this._consumerMonitorRegistrar);
        }
        return this._consumerMonitorRegistrar;
    }

    public SubscriptionRegistrar getSubscriptionRegistrar() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionRegistrar");
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionRegistrar", (Object)this._subscriptionRegistrar);
        }
        return this._subscriptionRegistrar;
    }
}

