/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.io;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.comms.ConnectionMetaData;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.comms.ProtocolVersion;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.processor.io.MPIO;
import com.ibm.ws.sib.processor.io.MPIOMsgDebug;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.io.UnsupportedEncodingException;

public class MPConnection {
    private static final TraceComponent tc = SibTr.register(MPConnection.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MEConnection connection;
    private SIBUuid8 remoteUuid;
    private MPIO mpio;

    public MPConnection(MPIO mpio, MEConnection connection, SIBUuid8 remoteUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MPConnection", (Object)new Object[]{mpio, connection, remoteUuid});
        }
        this.mpio = mpio;
        this.connection = connection;
        this.remoteUuid = remoteUuid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MPConnection", (Object)this);
        }
    }

    void send(AbstractMessage aMessage, int priority) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"send", (Object)new Object[]{this, aMessage, new Integer(priority), "verboseMsg OUT : " + aMessage.toVerboseString()});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            MPIOMsgDebug.debug(tc, aMessage, priority);
        }
        try {
            this.connection.send(aMessage, priority);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"send", (Object)"Message accepted by Comms");
            }
        }
        catch (SIConnectionDroppedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"send", (Object)"Message refused by Comms: Connection Dropped");
            }
            this.mpio.error(this.connection, e);
        }
        catch (SIConnectionUnavailableException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"send", (Object)"Message refused by Comms: Connection Unavailable");
            }
            this.mpio.error(this.connection, e);
        }
        catch (SIConnectionLostException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"send", (Object)"Message refused by Comms: Connection Lost");
            }
            this.mpio.error(this.connection, e);
        }
        catch (MessageEncodeFailedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"send", (Object)"Message refused by Comms: Msg Encode Failed");
            }
            this.mpio.error(this.connection, e);
        }
        catch (MessageCopyFailedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"send", (Object)"Message refused by Comms: Msg Copy Failed");
            }
            this.mpio.error(this.connection, e);
        }
        catch (UnsupportedEncodingException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"send", (Object)"Message refused by Comms: Msg Encoding Failed");
            }
            this.mpio.error(this.connection, e);
        }
        catch (IncorrectMessageTypeException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"send", (Object)"Message refused by Comms: Incorrect Message Type");
            }
            this.mpio.error(this.connection, e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"send");
        }
    }

    public boolean equals(Object conn) {
        if (conn != null && conn instanceof MPConnection) {
            MPConnection mpConn = (MPConnection)conn;
            return mpConn.connection.equals(this.connection);
        }
        return false;
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public SIBUuid8 getRemoteMEUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteMEUuid");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteMEUuid", (Object)this.remoteUuid);
        }
        return this.remoteUuid;
    }

    public ProtocolVersion getVersion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getVersion");
        }
        ProtocolVersion version = ProtocolVersion.UNKNOWN;
        ConnectionMetaData connMetaData = this.connection.getMetaData();
        if (connMetaData != null) {
            version = connMetaData.getProtocolVersion();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getVersion", (Object)version);
        }
        return version;
    }
}

