/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlCardinalityInfo;
import com.ibm.ws.sib.mfp.control.ControlCreateDurable;
import com.ibm.ws.sib.mfp.control.ControlCreateStream;
import com.ibm.ws.sib.mfp.control.ControlDeleteDurable;
import com.ibm.ws.sib.mfp.control.ControlDurableConfirm;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.processor.MPSelectionCriteriaFactory;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.DurableConstants;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.HashMap;
import java.util.Map;

public class DurableOutputHandler
implements ControlHandler,
DurableConstants {
    private static final TraceComponent tc = SibTr.register(DurableOutputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    private DurableOutputHandler() {
    }

    @Override
    public void handleControlMessage(SIBUuid8 sourceMEUuid, ControlMessage cMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{sourceMEUuid, cMsg});
        }
        InvalidOperationException e = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableOutputHandler", "1:112:1.45.1.1"}, null));
        FFDCFilter.processException((Throwable)((Object)e), (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.handleControlMessage", (String)"1:119:1.45.1.1", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableOutputHandler", "1:127:1.45.1.1"});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage", (Object)((Object)e));
        }
        throw e;
    }

    public static void staticHandleControlMessage(ControlMessage cMsg, DestinationManager DM, MessageProcessor MP) {
        ControlMessageType type;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"staticHandleControlMessage", (Object)new Object[]{cMsg, DM, MP});
        }
        if ((type = cMsg.getControlMessageType()) == ControlMessageType.CREATEDURABLE) {
            DurableOutputHandler.handleCreateDurable(DM, (ControlCreateDurable)cMsg, MP);
        } else if (type == ControlMessageType.DELETEDURABLE) {
            DurableOutputHandler.handleDeleteDurable(DM, (ControlDeleteDurable)cMsg, MP);
        } else if (type == ControlMessageType.CREATESTREAM) {
            DurableOutputHandler.handleCreateStream(DM, (ControlCreateStream)cMsg, MP);
        } else {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableOutputHandler", "1:173:1.45.1.1"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.staticHandleControlMessage", (String)"1:180:1.45.1.1", DurableOutputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableOutputHandler", "1:187:1.45.1.1"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"staticHandleControlMessage", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"staticHandleControlMessage");
        }
    }

    protected static void handleCreateDurable(DestinationManager DM, ControlCreateDurable msg, MessageProcessor MP) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleCreateDurable", (Object)new Object[]{DM, msg, MP});
        }
        int status = 2;
        SIBUuid12 handlerID = msg.getGuaranteedTargetDestinationDefinitionUUID();
        String subName = msg.getDurableSubName();
        String discriminator = msg.getDurableDiscriminator();
        String selectorString = msg.getDurableSelector();
        SelectorDomain selectorDomain = SelectorDomain.getSelectorDomain((int)msg.getDurableSelectorDomain());
        HashMap<String, Map> selectorProperties = null;
        Map selectorNamespaceMap = msg.getDurableSelectorNamespaceMap();
        if (selectorNamespaceMap != null) {
            selectorProperties = new HashMap<String, Map>();
            selectorProperties.put("namespacePrefixMappings", selectorNamespaceMap);
        }
        String user = msg.getSecurityUserid();
        boolean isSIBServerSubject = msg.isSecurityUseridSentBySystem();
        try {
            BaseDestinationHandler handler = (BaseDestinationHandler)DM.getDestination(handlerID, false);
            Object criteria = null;
            criteria = selectorProperties == null ? MP.getSelectionCriteriaFactory().createSelectionCriteria(discriminator, selectorString, selectorDomain) : MPSelectionCriteriaFactory.getInstance().createSelectionCriteria(discriminator, selectorString, selectorDomain, selectorProperties);
            status = handler.createDurableFromRemote(subName, (SelectionCriteria)criteria, user, msg.isCloned(), msg.isNoLocal(), isSIBServerSubject);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.handleCreateDurable", (String)"1:281:1.45.1.1", DurableOutputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        SIBUuid8 sender = msg.getGuaranteedSourceMessagingEngineUUID();
        ControlDurableConfirm reply = DurableOutputHandler.createDurableConfirm(MP, sender, msg.getRequestID(), status);
        MP.getMPIO().sendToMe(sender, 11, (AbstractMessage)reply);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleCreateDurable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void handleDeleteDurable(DestinationManager DM, ControlDeleteDurable msg, MessageProcessor MP) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleDeleteDurable", (Object)new Object[]{DM, msg, MP});
        }
        int status = 2;
        try {
            HashMap durableSubs;
            String subName = msg.getDurableSubName();
            HashMap hashMap = durableSubs = DM.getDurableSubscriptionsTable();
            synchronized (hashMap) {
                ConsumerDispatcher cd = (ConsumerDispatcher)durableSubs.get(subName);
                if (cd == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"handleDeleteDurable", (Object)"SIDurableSubscriptionNotFoundException");
                    }
                    status = 3;
                    throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{subName, MP.getMessagingEngineName()}, null));
                }
                BaseDestinationHandler handler = cd.getDestination();
                boolean userMatch = true;
                if (MP.isBusSecure()) {
                    ConsumerDispatcherState subState = cd.getConsumerDispatcherState();
                    String theUser = msg.getSecurityUserid();
                    if (theUser == null) {
                        if (subState.getUser() != null) {
                            userMatch = false;
                        }
                    } else if (!theUser.equals(subState.getUser())) {
                        userMatch = false;
                    }
                }
                status = !userMatch ? 5 : handler.deleteDurableFromRemote(subName);
            }
        }
        catch (SIDurableSubscriptionNotFoundException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.handleDeleteDurable", (String)"1:387:1.45.1.1", DurableOutputHandler.class);
        }
        SIBUuid8 sender = msg.getGuaranteedSourceMessagingEngineUUID();
        ControlDurableConfirm reply = DurableOutputHandler.createDurableConfirm(MP, sender, msg.getRequestID(), status);
        MP.getMPIO().sendToMe(sender, 11, (AbstractMessage)reply);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleDeleteDurable");
        }
    }

    protected static void handleCreateStream(DestinationManager DM, ControlCreateStream msg, MessageProcessor MP) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleCreateStream", (Object)new Object[]{DM, msg, MP});
        }
        ControlCardinalityInfo reply = null;
        try {
            SIBUuid12 handlerID = msg.getGuaranteedTargetDestinationDefinitionUUID();
            BaseDestinationHandler handler = (BaseDestinationHandler)DM.getDestination(handlerID, false);
            handler.attachDurableFromRemote(msg);
        }
        catch (SIDestinationLockedException e) {
            reply = DurableOutputHandler.createCardinalityInfo(MP, msg.getGuaranteedSourceMessagingEngineUUID(), msg.getRequestID(), 1);
        }
        catch (Exception e) {
            int status = 2;
            SIBUuid8 sender = msg.getGuaranteedSourceMessagingEngineUUID();
            if (e instanceof SIDurableSubscriptionNotFoundException) {
                status = 3;
            } else if (e instanceof SIDurableSubscriptionMismatchException) {
                status = 6;
            } else if (e instanceof SINotAuthorizedException) {
                status = 5;
            } else {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.handleCreateStream", (String)"1:454:1.45.1.1", DurableOutputHandler.class);
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            reply = DurableOutputHandler.createDurableConfirm(MP, sender, msg.getRequestID(), status);
        }
        if (reply != null) {
            SIBUuid8 sender = msg.getGuaranteedSourceMessagingEngineUUID();
            MP.getMPIO().sendToMe(sender, 11, (AbstractMessage)reply);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleCreateStream");
        }
    }

    protected static ControlDurableConfirm createDurableConfirm(MessageProcessor MP, SIBUuid8 target, long reqID, int status) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDurableConfirm", (Object)new Object[]{MP, target, new Long(reqID), new Integer(status)});
        }
        ControlDurableConfirm msg = null;
        try {
            msg = MessageProcessor.getControlMessageFactory().createNewControlDurableConfirm();
            DurableOutputHandler.initializeControlMessage(MP.getMessagingEngineUuid(), (ControlMessage)msg, target);
            msg.setRequestID(reqID);
            msg.setStatus(status);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.createDurableConfirm", (String)"1:509:1.45.1.1", DurableOutputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDurableConfirm", (Object)msg);
        }
        return msg;
    }

    protected static ControlCardinalityInfo createCardinalityInfo(MessageProcessor MP, SIBUuid8 target, long reqID, int card) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createCardinalityInfo", (Object)new Object[]{MP, target, new Long(reqID), new Integer(card)});
        }
        ControlCardinalityInfo msg = null;
        try {
            msg = MessageProcessor.getControlMessageFactory().createNewControlCardinalityInfo();
            DurableOutputHandler.initializeControlMessage(MP.getMessagingEngineUuid(), (ControlMessage)msg, target);
            msg.setRequestID(reqID);
            msg.setCardinality(card);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.createCardinalityInfo", (String)"1:552:1.45.1.1", DurableOutputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createCardinalityInfo", (Object)msg);
        }
        return msg;
    }

    protected static void initializeControlMessage(SIBUuid8 sourceME, ControlMessage msg, SIBUuid8 remoteMEId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeControlMessage", (Object)new Object[]{msg, remoteMEId});
        }
        SIMPUtils.setGuaranteedDeliveryProperties(msg, sourceME, remoteMEId, null, null, null, ProtocolType.DURABLEINPUT, GDConfig.PROTOCOL_VERSION);
        msg.setPriority(11);
        msg.setReliability(SIMPConstants.CONTROL_MESSAGE_RELIABILITY);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeControlMessage");
        }
    }

    @Override
    public long handleControlMessageWithReturnValue(SIBUuid8 sourceMEUuid, ControlMessage cMsg) throws SIIncorrectCallException, SIResourceException, SIConnectionLostException, SIRollbackException {
        return 0L;
    }
}

