/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.DestinationIndex;
import com.ibm.ws.sib.processor.impl.indexes.DestinationTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.LinkIndex;
import com.ibm.ws.sib.processor.impl.indexes.LinkTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.statemodel.State;
import com.ibm.ws.sib.processor.impl.interfaces.MPCallsToUnitTestHandler;
import com.ibm.ws.sib.processor.impl.interfaces.StoppableThread;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.utils.StoppableThreadCache;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

public class AsynchDeletionThread
implements Runnable,
StoppableThread {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(AsynchDeletionThread.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessor _messageProcessor;
    private volatile boolean _isRunning = false;
    private volatile boolean _isStopping = false;
    private volatile boolean _rerunRequested = false;
    private Object asynchLock = new Object();

    AsynchDeletionThread(MessageProcessor mp) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AsynchDeletionThread", (Object)new Object[]{mp});
        }
        this._messageProcessor = mp;
        this._messageProcessor.getStoppableThreadCache().registerThread(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AsynchDeletionThread", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"run");
        }
        MPCallsToUnitTestHandler unitTestCallback = MessageProcessor.getMPCallsToUnitTestHandler();
        DestinationManager destinationManager = this._messageProcessor.getDestinationManager();
        DestinationIndex destinationIndex = destinationManager.getDestinationIndex();
        LinkIndex linkIndex = destinationManager.getLinkIndex();
        SIMPIterator itr = null;
        boolean run = true;
        try {
            if (unitTestCallback != null) {
                this.asynchLock = unitTestCallback.getAsynchLock(this);
            }
            Object object = this.asynchLock;
            synchronized (object) {
                if (unitTestCallback != null) {
                    unitTestCallback.asyncDeletionThreadReadyToStart();
                }
                while (run && !this.isStopping()) {
                    List subscriptions = (List)((ArrayList)destinationManager.getSubscriptionsToDelete()).clone();
                    SubscriptionItemStream stream = null;
                    while (!subscriptions.isEmpty()) {
                        stream = (SubscriptionItemStream)subscriptions.remove(0);
                        this.cleanupSubscription(stream);
                        destinationManager.removeSubscriptionAsDeleted(stream);
                    }
                    DestinationTypeFilter destFilter = new DestinationTypeFilter();
                    destFilter.ALIAS = Boolean.FALSE;
                    destFilter.FOREIGN_DESTINATION = Boolean.FALSE;
                    destFilter.and = false;
                    destFilter.CLEANUP_PENDING = Boolean.TRUE;
                    destFilter.DELETE_PENDING = Boolean.TRUE;
                    itr = destinationIndex.iterator(destFilter);
                    BaseDestinationHandler dh = null;
                    while (itr.hasNext() && !this.isStopping()) {
                        dh = (BaseDestinationHandler)itr.next();
                        boolean destinationCleanedUp = this.cleanUpDestination(dh);
                        if (destinationCleanedUp) {
                            DestinationIndex destinationIndex2 = destinationIndex;
                            synchronized (destinationIndex2) {
                                State state = destinationIndex.getState(dh);
                                if (state.isCleanupPending()) {
                                    destinationIndex.cleanupComplete(dh);
                                } else {
                                    destinationIndex.remove(dh);
                                }
                            }
                            if (!tc.isDebugEnabled()) continue;
                            SibTr.debug((TraceComponent)tc, (String)("Destination " + dh.getName() + " cleaned up"));
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)tc, (String)("Failed to cleanup destination " + dh.getName()));
                    }
                    itr.finished();
                    LinkTypeFilter linkFilter = new LinkTypeFilter();
                    linkFilter.and = false;
                    linkFilter.CLEANUP_PENDING = Boolean.TRUE;
                    linkFilter.DELETE_PENDING = Boolean.TRUE;
                    itr = linkIndex.iterator(linkFilter);
                    while (itr.hasNext() && !this._isStopping) {
                        dh = (BaseDestinationHandler)itr.next();
                        boolean destinationCleanedUp = this.cleanUpDestination(dh);
                        if (destinationCleanedUp) {
                            LinkIndex linkIndex2 = linkIndex;
                            synchronized (linkIndex2) {
                                State state = linkIndex.getState(dh);
                                if (state.isCleanupPending()) {
                                    linkIndex.cleanupComplete(dh);
                                } else {
                                    linkIndex.remove(dh);
                                }
                            }
                            if (!tc.isDebugEnabled()) continue;
                            SibTr.debug((TraceComponent)tc, (String)("Link " + dh.getName() + " cleaned up"));
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)tc, (String)("Failed to cleanup Link " + dh.getName()));
                    }
                    itr.finished();
                    run = this._rerunRequested;
                    this._rerunRequested = false;
                }
                this.asynchLock.notifyAll();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AsynchDeletionThread.run", (String)"1:263:1.50", (Object)this);
            try {
                itr.finished();
            }
            catch (Exception subscriptions) {
                // empty catch block
            }
            unitTestCallback = MessageProcessor.getMPCallsToUnitTestHandler();
            if (null != unitTestCallback) {
                unitTestCallback.unitTestFailure("Async background deletion thread failed with an exception ", e);
            }
            SIErrorException exToThrow = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AsynchDeletionThread.run", "1:298:1.50"}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"run");
            }
            throw exToThrow;
        }
        finally {
            destinationManager.notifyAsynchDeletionEnd(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"run");
        }
    }

    private void cleanupSubscription(SubscriptionItemStream stream) {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"cleanupSubscription", (Object)stream);
            }
            try {
                stream.deleteIfPossible(false);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AsynchDeletionThread.cleanupSubscription", (String)"1:340:1.50", (Object)stream);
                if (!tc.isDebugEnabled()) break block4;
                SibTr.debug((TraceComponent)tc, (String)("Failed to delete subscription " + stream));
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupSubscription");
        }
    }

    private boolean cleanUpDestination(BaseDestinationHandler dh) {
        boolean destinationCleanedUp;
        block7: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"cleanUpDestination", (Object)new Object[]{dh});
            }
            destinationCleanedUp = false;
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Starting clean-up for " + dh.getName() + " : " + dh.getUuid()));
                }
                destinationCleanedUp = dh.cleanupDestination();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Ended clean-up for " + dh.getName() + " : " + dh.getUuid() + " : Success " + destinationCleanedUp));
                }
            }
            catch (Exception e) {
                MPCallsToUnitTestHandler unitTestCallback;
                SibTr.exception((TraceComponent)tc, (Exception)e);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)(" Failed to cleanup destination " + dh.getName() + " : " + dh.getUuid()));
                }
                if (null == (unitTestCallback = MessageProcessor.getMPCallsToUnitTestHandler())) break block7;
                unitTestCallback.unitTestFailure("Failed to clean up a destination on the async deletion thread.\nThe test reporting this failure may not be the one which caused the problem.\nLikely that the test which created + used the destination will show it up when\nre-running the tests stand-alone.\n" + dh.toString() + "\n", e);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanUpDestination", (Object)new Boolean(destinationCleanedUp));
        }
        return destinationCleanedUp;
    }

    public void setRunning(boolean running) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRunning");
            SibTr.exit((TraceComponent)tc, (String)"setRunning");
        }
        this._isRunning = running;
    }

    public boolean isRunning() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRunning");
            SibTr.exit((TraceComponent)tc, (String)"isRunning", (Object)new Boolean(this._isRunning));
        }
        return this._isRunning;
    }

    public void setStopping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStopping");
            SibTr.exit((TraceComponent)tc, (String)"setStopping");
        }
        this._isStopping = true;
    }

    public boolean isStopping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStopping");
            SibTr.exit((TraceComponent)tc, (String)"isStopping", (Object)new Boolean(this._isStopping));
        }
        return this._isStopping;
    }

    public void rerun() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rerun");
        }
        this._rerunRequested = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rerun");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopThread(StoppableThreadCache threadCache) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopThread", (Object)threadCache);
        }
        Object object = this._messageProcessor.getDestinationManager().deletionThreadLock;
        synchronized (object) {
            this.setStopping();
            while (this.isRunning()) {
                try {
                    this._messageProcessor.getDestinationManager().deletionThreadLock.wait(5000L);
                    if (!Thread.holdsLock(this.asynchLock)) continue;
                    this.asynchLock.wait(5000L);
                }
                catch (InterruptedException iex) {
                    SibTr.exception((TraceComponent)tc, (Exception)iex);
                }
            }
        }
        threadCache.deregisterThread(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopThread");
        }
    }
}

