/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlFlushed;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.mfp.control.ControlRequestFlush;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.mfp.impl.ControlMessageFactory;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.exceptions.SIMPIncorrectCallException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TargetStreamManager;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.ProducerSessionImpl;
import com.ibm.ws.sib.processor.impl.interfaces.BatchListener;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.MessageDeliverer;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.MessageProducer;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.ProducerInputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.impl.store.BatchHandler;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.TargetProtocolItemStream;
import com.ibm.ws.sib.processor.io.MPIO;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractInputHandler
implements ProducerInputHandler,
MessageDeliverer,
UpstreamControl,
ControlHandler,
MessageEventListener {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final TraceComponent tc = SibTr.register(AbstractInputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected SIMPTransactionManager _txManager;
    protected MessageProcessor _messageProcessor;
    protected DestinationHandler _destination;
    protected BatchHandler _targetBatchHandler;
    protected MPIO _mpio;
    protected TargetStreamManager _targetStreamManager;
    protected ControlMessageFactory _cmf;
    private List<MessageProducer> _producers;
    private boolean _destinationDeleted = false;

    AbstractInputHandler(DestinationHandler destination, TargetProtocolItemStream targetProtocolItemStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AbstractInputHandler", (Object)new Object[]{destination, targetProtocolItemStream});
        }
        this._destination = destination;
        this._messageProcessor = destination.getMessageProcessor();
        this._txManager = this._messageProcessor.getTXManager();
        this._mpio = this._messageProcessor.getMPIO();
        this._targetBatchHandler = this._messageProcessor.getTargetBatchHandler();
        this._producers = new LinkedList<MessageProducer>();
        this._targetStreamManager = new TargetStreamManager(this._messageProcessor, this._destination, this, this, targetProtocolItemStream, this._txManager);
        this._cmf = MessageProcessor.getControlMessageFactory();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AbstractInputHandler", (Object)this);
        }
    }

    @Override
    public void registerForEvents(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents", (Object)msg);
        }
        msg.registerMessageEventListener(8, this);
        if (msg.getReportCOD() != null && this._destination instanceof BaseDestinationHandler) {
            msg.registerMessageEventListener(11, (BaseDestinationHandler)this._destination);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachProducer(MessageProducer producerSession) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachProducer", (Object)producerSession);
        }
        List<MessageProducer> list = this._producers;
        synchronized (list) {
            if (this._destinationDeleted) {
                String destName = this._destination.getName();
                if (this._destination.isLink()) {
                    destName = ((LinkHandler)this._destination).getBusName();
                }
                SIMPNotPossibleInCurrentConfigurationException e = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_32", new Object[]{destName, this._messageProcessor.getMessagingEngineName()}, null));
                e.setExceptionReason(32);
                e.setExceptionInserts(new String[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attachProducer", (Object)e);
                }
                throw e;
            }
            this._producers.add(producerSession);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachProducer");
        }
    }

    protected void remoteToLocalPut(MessageItem msgItem) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remoteToLocalPut", (Object)new Object[]{msgItem});
        }
        this._targetStreamManager.handleMessage(msgItem);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remoteToLocalPut");
        }
    }

    @Override
    public void reconstituteTargetStreams(StreamSet streamSet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteTargetStreams", (Object)streamSet);
        }
        this._targetStreamManager.reconstituteStreamSet(streamSet);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteTargetStreams");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachProducer(MessageProducer producerSession) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"detachProducer", (Object)producerSession);
        }
        List<MessageProducer> list = this._producers;
        synchronized (list) {
            this._producers.remove(producerSession);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detachProducer");
        }
    }

    public String toString() {
        return "Dest InputHandler: " + this._destination.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProducerCount() {
        int producerCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProducerCount");
        }
        List<MessageProducer> list = this._producers;
        synchronized (list) {
            producerCount = this._producers.size();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getProducerCount", (Object)new Integer(producerCount));
        }
        return producerCount;
    }

    protected void handleRollback(LocalTransaction transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleRollback", (Object)transaction);
        }
        if (transaction != null) {
            try {
                transaction.rollback();
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AbstractInputHandler.handleRollback", (String)"1:345:1.170", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleRollback");
        }
    }

    public OutputHandler handleMessage(MessageItem msg) throws SIMPNotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleMessage", (Object)msg);
        }
        msg.setCurrentMEArrivalTimestamp(System.currentTimeMillis());
        Reliability msgReliability = msg.getReliability();
        if (msgReliability == Reliability.NONE) {
            msgReliability = this._destination.getDefaultReliability();
            msg.setReliability(msgReliability);
        } else if (msgReliability.compareTo((Object)this._destination.getMaxReliability()) > 0) {
            if ((this._destination.isTemporary() || this._destination.getName().equals(this._messageProcessor.getTDReceiverAddr().getDestinationName())) && msg.getReliability().compareTo((Object)Reliability.RELIABLE_PERSISTENT) >= 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"handleMessage", (Object)"Sending ASSURED message to temporary destination");
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleMessage", (Object)"Reliablity greater than dest");
                }
                SIMPNotPossibleInCurrentConfigurationException e = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_33", new Object[]{msg.getReliability().toString(), this._destination.getMaxReliability().toString(), this._destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                e.setExceptionReason(33);
                e.setExceptionInserts(new String[]{msg.getReliability().toString(), this._destination.getMaxReliability().toString(), this._destination.getName(), this._messageProcessor.getMessagingEngineName()});
                throw e;
            }
        }
        if (this._destination.isTemporary() || this._destination.getName().equals(this._messageProcessor.getTDReceiverAddr().getDestinationName())) {
            msg.setMaxStorageStrategy(2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleMessage");
        }
        return null;
    }

    public void registerMessage(MessageItem msg, TransactionCommon tran) throws SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerMessage", (Object)new Object[]{msg, tran});
        }
        if (tran != null && !tran.isAlive()) {
            SIMPIncorrectCallException e = new SIMPIncorrectCallException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_16", new Object[]{this._destination}, null));
            e.setExceptionReason(16);
            e.setExceptionInserts(new String[]{this._destination.getName()});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerMessage", (Object)e);
            }
            throw e;
        }
        this.registerForEvents(msg);
        tran.registerCallback((TransactionCallback)msg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeProducersDestinationDeleted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeProducersDestinationDeleted");
        }
        List<MessageProducer> list = this._producers;
        synchronized (list) {
            this._destinationDeleted = true;
            Iterator<MessageProducer> i = this._producers.iterator();
            while (i.hasNext()) {
                ProducerSessionImpl producerSessionImpl = (ProducerSessionImpl)i.next();
                producerSessionImpl._closeProducerDestinationDeleted();
                i.remove();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeProducersDestinationDeleted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachAllProducersForNewInputHandler(ProducerInputHandler newHandler) throws SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"detachAllProducersForNewInputHandler", (Object)newHandler);
        }
        List<MessageProducer> list = this._producers;
        synchronized (list) {
            Iterator<MessageProducer> it = this._producers.iterator();
            while (it.hasNext()) {
                ProducerSessionImpl prod = (ProducerSessionImpl)it.next();
                it.remove();
                newHandler.attachProducer(prod);
                prod.updateInputHandler(newHandler);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detachAllProducersForNewInputHandler");
        }
    }

    protected ControlAreYouFlushed createControlAreYouFlushed(SIBUuid8 target, long ID, SIBUuid12 stream) throws SIResourceException {
        ControlAreYouFlushed flushedqMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAreYouFlushed");
        }
        try {
            flushedqMsg = this._cmf.createNewControlAreYouFlushed();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AbstractInputHandler.createControlAreYouFlushed", (String)"1:588:1.170", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlAreYouFlushed", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractInputHandler", "1:600:1.170", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.AbstractInputHandler", "1:608:1.170", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)flushedqMsg, this._messageProcessor.getMessagingEngineUuid(), target, stream, null, this._destination.getUuid(), ProtocolType.UNICASTOUTPUT, GDConfig.PROTOCOL_VERSION);
        if (this._destination.isPubSub()) {
            flushedqMsg.setGuaranteedProtocolType(ProtocolType.PUBSUBOUTPUT);
        }
        flushedqMsg.setRequestID(ID);
        flushedqMsg.setPriority(11);
        flushedqMsg.setReliability(SIMPConstants.CONTROL_MESSAGE_RELIABILITY);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAreYouFlushed", (Object)flushedqMsg);
        }
        return flushedqMsg;
    }

    protected ControlRequestFlush createControlRequestFlush(SIBUuid8 target, long ID, SIBUuid12 stream) throws SIResourceException {
        ControlRequestFlush rflushMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlRequestFlush");
        }
        try {
            rflushMsg = this._cmf.createNewControlRequestFlush();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AbstractInputHandler.createControlRequestFlush", (String)"1:667:1.170", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlRequestFlush", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractInputHandler", "1:679:1.170", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.AbstractInputHandler", "1:687:1.170", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)rflushMsg, this._messageProcessor.getMessagingEngineUuid(), target, stream, null, this._destination.getUuid(), null, GDConfig.PROTOCOL_VERSION);
        if (this._destination.isPubSub()) {
            rflushMsg.setGuaranteedProtocolType(ProtocolType.PUBSUBOUTPUT);
        } else {
            rflushMsg.setGuaranteedProtocolType(ProtocolType.UNICASTOUTPUT);
        }
        rflushMsg.setRequestID(ID);
        rflushMsg.setPriority(11);
        rflushMsg.setReliability(SIMPConstants.CONTROL_MESSAGE_RELIABILITY);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlRequestFlush", (Object)rflushMsg);
        }
        return rflushMsg;
    }

    @Override
    public void handleControlMessage(SIBUuid8 sourceMEUuid, ControlMessage cMsg) throws SIIncorrectCallException, SIErrorException, SIResourceException {
        ControlMessageType type;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{sourceMEUuid, cMsg});
        }
        if ((type = cMsg.getControlMessageType()) == ControlMessageType.FLUSHED) {
            this._targetStreamManager.handleFlushedMessage((ControlFlushed)cMsg);
        } else if (type == ControlMessageType.NOTFLUSHED) {
            this._targetStreamManager.handleNotFlushedMessage((ControlNotFlushed)cMsg);
        } else if (type == ControlMessageType.SILENCE) {
            this._targetStreamManager.handleSilenceMessage((ControlSilence)cMsg);
        } else if (type == ControlMessageType.ACKEXPECTED) {
            this._targetStreamManager.handleAckExpectedMessage((ControlAckExpected)cMsg);
        }
    }

    @Override
    public TargetStreamManager getTargetStreamManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetStreamManager");
            SibTr.exit((TraceComponent)tc, (String)"getTargetStreamManager", (Object)this._targetStreamManager);
        }
        return this._targetStreamManager;
    }

    @Override
    public void forceTargetBatchCompletion(BatchListener listener) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceTargetBatchCompletion", (Object)new Object[]{listener});
        }
        this._targetBatchHandler.completeBatch(true, listener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceTargetBatchCompletion");
        }
    }

    @Override
    public boolean getInboundStreamsEmpty() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInboundStreamsEmpty");
        }
        boolean returnValue = false;
        if (this._targetStreamManager != null) {
            returnValue = this._targetStreamManager.isEmpty();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getInboundStreamsEmpty", (Object)new Boolean(returnValue));
        }
        return returnValue;
    }
}

