/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlFlushed;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.ExpressTargetStream;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.GuaranteedTargetStream;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TargetStream;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.BatchListener;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.MessageDeliverer;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPInboundReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.TargetStreamSetControl;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TargetStreamManager
implements AlarmListener,
BatchListener {
    private static final TraceComponent tc = SibTr.register(TargetStreamManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private HashMap<SIBUuid12, SIBUuid8> sourceMap;
    private Index streamSets;
    private List<StreamSet> flushedStreamSets;
    private HashMap<SIBUuid12, FlushQueryRecord> flushMap;
    private MessageDeliverer deliverer;
    private UpstreamControl upControl;
    private SIMPTransactionManager txManager;
    protected ProtocolItemStream protocolItemStream = null;
    private DestinationHandler destination = null;
    private MPAlarmManager am;
    private MessageProcessor messageProcessor;

    public TargetStreamManager(MessageProcessor messageProcessor, DestinationHandler destination, MessageDeliverer deliverer, UpstreamControl upControl, ProtocolItemStream protocolItemStream, SIMPTransactionManager txManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TargetStreamManager", (Object)new Object[]{messageProcessor, destination, deliverer, upControl, protocolItemStream, txManager});
        }
        this.messageProcessor = messageProcessor;
        this.am = messageProcessor.getAlarmManager();
        this.deliverer = deliverer;
        this.upControl = upControl;
        this.txManager = txManager;
        this.protocolItemStream = protocolItemStream;
        this.destination = destination;
        this.sourceMap = new HashMap();
        this.streamSets = new Index();
        this.flushMap = new HashMap();
        this.flushedStreamSets = new ArrayList<StreamSet>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"TargetStreamManager", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSet getStreamSetForMessage(AbstractMessage msg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamSetForMessage", (Object)new Object[]{msg});
        }
        SIBUuid12 streamID = msg.getGuaranteedStreamUUID();
        StreamSet streamSet = null;
        Index index = this.streamSets;
        synchronized (index) {
            SIBUuid12 msgDest;
            streamSet = (StreamSet)this.streamSets.get(streamID);
            if (streamSet != null && (msgDest = msg.getGuaranteedTargetDestinationDefinitionUUID()) != null && !msgDest.equals((Object)streamSet.getDestUuid())) {
                streamSet.setDestUuid(msgDest);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamSetForMessage", (Object)streamSet);
        }
        return streamSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(MessageItem msgItem) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"handleMessage", (Object)new Object[]{msgItem});
        }
        JsMessage jsMsg = msgItem.getMessage();
        int priority = jsMsg.getPriority();
        Reliability reliability = jsMsg.getReliability();
        StreamSet streamSet = this.getStreamSetForMessage((AbstractMessage)jsMsg);
        if (streamSet == null) {
            this.handleNewStreamID(msgItem);
        } else {
            TargetStream targetStream = null;
            StreamSet streamSet2 = streamSet;
            synchronized (streamSet2) {
                targetStream = (TargetStream)streamSet.getStream(priority, reliability);
                if (targetStream == null) {
                    targetStream = this.createStream(streamSet, priority, reliability, streamSet.getPersistentData(priority, reliability));
                }
            }
            targetStream.writeValue(msgItem);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSilence(MessageItem msgItem) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"handleSilence", (Object)new Object[]{msgItem});
        }
        JsMessage jsMsg = msgItem.getMessage();
        int priority = jsMsg.getPriority();
        Reliability reliability = jsMsg.getReliability();
        StreamSet streamSet = this.getStreamSetForMessage((AbstractMessage)jsMsg);
        if (streamSet != null) {
            TargetStream targetStream = null;
            StreamSet streamSet2 = streamSet;
            synchronized (streamSet2) {
                targetStream = (TargetStream)streamSet.getStream(priority, reliability);
            }
            if (targetStream != null) {
                targetStream.writeSilence(msgItem);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleSilence");
        }
    }

    private void handleNewStreamID(ControlMessage cMsg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleNewStreamID", (Object)new Object[]{cMsg});
        }
        this.handleNewStreamID((AbstractMessage)cMsg, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleNewStreamID");
        }
    }

    private void handleNewStreamID(MessageItem msgItem) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleNewStreamID", (Object)new Object[]{msgItem});
        }
        JsMessage jsMsg = msgItem.getMessage();
        this.handleNewStreamID((AbstractMessage)jsMsg, msgItem);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleNewStreamID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewStreamID(AbstractMessage aMessage, MessageItem msgItem) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleNewStreamID", (Object)new Object[]{aMessage, msgItem});
        }
        SIBUuid12 streamID = aMessage.getGuaranteedStreamUUID();
        HashMap<SIBUuid12, FlushQueryRecord> hashMap = this.flushMap;
        synchronized (hashMap) {
            FlushQueryRecord entry = this.flushMap.get(streamID);
            if (entry != null && msgItem != null) {
                entry.append(msgItem);
            } else {
                SIBUuid8 sourceMEUuid = aMessage.getGuaranteedSourceMessagingEngineUUID();
                SIBUuid12 destID = aMessage.getGuaranteedTargetDestinationDefinitionUUID();
                SIBUuid8 busID = aMessage.getGuaranteedCrossBusSourceBusUUID();
                long reqID = this.messageProcessor.nextTick();
                entry = new FlushQueryRecord(sourceMEUuid, destID, busID, msgItem, reqID);
                this.flushMap.put(streamID, entry);
                this.upControl.sendAreYouFlushedMessage(sourceMEUuid, destID, busID, reqID, streamID);
                entry.resend = this.am.create(GDConfig.FLUSH_QUERY_INTERVAL, this, streamID);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleNewStreamID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSet addNewStreamSet(SIBUuid12 streamID, SIBUuid8 sourceMEUuid, SIBUuid12 remoteDestUuid, SIBUuid8 remoteBusUuid, String linkTarget) throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNewStreamSet", (Object)new Object[]{streamID, sourceMEUuid, remoteDestUuid, remoteBusUuid, linkTarget});
        }
        StreamSet streamSet = null;
        try {
            LocalTransaction tran = this.txManager.createLocalTransaction(false);
            Transaction msTran = this.txManager.resolveAndEnlistMsgStoreTransaction((TransactionCommon)tran);
            streamSet = new StreamSet(streamID, sourceMEUuid, remoteDestUuid, remoteBusUuid, this.protocolItemStream, this.txManager, 0L, this.destination.isLink() ? StreamSet.Type.LINK_TARGET : StreamSet.Type.TARGET, (TransactionCommon)tran, linkTarget);
            this.protocolItemStream.addItem(streamSet, msTran);
            tran.commit();
            Index index = this.streamSets;
            synchronized (index) {
                this.streamSets.put(streamID, streamSet);
                this.sourceMap.put(streamID, sourceMEUuid);
            }
        }
        catch (OutOfCacheSpace e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addNewStreamSet", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.TargetStreamManager.addNewStreamSet", (String)"1:471:1.69", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addNewStreamSet", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNewStreamSet", (Object)streamSet);
        }
        return streamSet;
    }

    private TargetStream createStream(StreamSet streamSet, int priority, Reliability reliability, long completedPrefix) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStream", (Object)new Object[]{streamSet, priority, reliability, completedPrefix});
        }
        TargetStream stream = null;
        stream = this.createStream(streamSet, priority, reliability);
        stream.setCompletedPrefix(completedPrefix);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStream");
        }
        return stream;
    }

    private TargetStream createStream(StreamSet streamSet, int priority, Reliability reliability) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStream", (Object)new Object[]{streamSet, priority, reliability});
        }
        ControllableStream stream = null;
        stream = reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) <= 0 ? new ExpressTargetStream(this.deliverer, streamSet.getRemoteMEUuid(), streamSet.getStreamID()) : new GuaranteedTargetStream(this.deliverer, this.upControl, this.am, streamSet, priority, reliability, new ArrayList(), this.messageProcessor);
        streamSet.setStream(priority, reliability, stream);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStream", (Object)stream);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkAck(ControlAck ack, long min) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkAck", (Object)new Object[]{ack, min});
        }
        int priority = ack.getPriority();
        Reliability reliability = ack.getReliability();
        StreamSet streamSet = this.getStreamSetForMessage((AbstractMessage)ack);
        if (streamSet != null) {
            long ackPrefix;
            TargetStream targetStream = null;
            StreamSet streamSet2 = streamSet;
            synchronized (streamSet2) {
                targetStream = (TargetStream)streamSet.getStream(priority, reliability);
            }
            if (targetStream != null && (ackPrefix = targetStream.getCompletedPrefix()) < min) {
                min = ackPrefix;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkAck", (Object)min);
        }
        return min;
    }

    public void handleFlushedMessage(ControlFlushed cMsg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"handleFlushedMessage", (Object)new Object[]{cMsg});
        }
        SIBUuid12 streamID = cMsg.getGuaranteedStreamUUID();
        this.forceFlush(streamID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleFlushedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceFlush(SIBUuid12 streamID) throws SIResourceException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"forceFlush", (Object)new Object[]{streamID});
        }
        HashMap<SIBUuid12, FlushQueryRecord> hashMap = this.flushMap;
        synchronized (hashMap) {
            FlushQueryRecord entry = this.flushMap.remove(streamID);
            if (entry != null) {
                entry.resend.cancel();
            }
            this.flush(streamID);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFlushAtSource(SIBUuid8 source, SIBUuid12 destID, SIBUuid8 busID, SIBUuid12 stream, boolean indoubtDiscard) throws SIException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"requestFlushAtSource", (Object)new Object[]{source, stream});
        }
        HashMap<SIBUuid12, FlushQueryRecord> hashMap = this.flushMap;
        synchronized (hashMap) {
            if (this.flushMap.containsKey(stream)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"requestFlushAtSource");
                }
                return;
            }
            long reqID = this.messageProcessor.nextTick();
            FlushQueryRecord entry = new FlushQueryRecord(source, destID, busID, reqID);
            this.flushMap.put(stream, entry);
            this.upControl.sendRequestFlushMessage(source, destID, busID, reqID, stream, indoubtDiscard);
            entry.resend = this.am.create(10000L, this, stream);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestFlushAtSource");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(SIBUuid12 streamID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"flush", (Object)new Object[]{streamID, this});
        }
        StreamSet streamSet = null;
        Index index = this.streamSets;
        synchronized (index) {
            this.sourceMap.remove(streamID);
            streamSet = (StreamSet)this.streamSets.remove(streamID);
            if (streamSet != null) {
                streamSet.dereferenceControlAdapter();
                Iterator<Stream> itr = streamSet.iterator();
                while (itr.hasNext()) {
                    TargetStream stream = (TargetStream)itr.next();
                    stream.flush();
                }
                List<StreamSet> list = this.flushedStreamSets;
                synchronized (list) {
                    this.flushedStreamSets.add(streamSet);
                }
                this.deliverer.forceTargetBatchCompletion(this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flush", (Object)this.streamSets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotFlushedMessage(ControlNotFlushed cMsg) throws SIIncorrectCallException, SIErrorException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"handleNotFlushedMessage", (Object)new Object[]{cMsg});
        }
        SIBUuid12 streamID = cMsg.getGuaranteedStreamUUID();
        HashMap<SIBUuid12, FlushQueryRecord> hashMap = this.flushMap;
        synchronized (hashMap) {
            FlushQueryRecord entry = this.flushMap.get(streamID);
            long reqId = cMsg.getRequestID();
            if (entry != null && entry.requestID == reqId) {
                this.flushMap.remove(streamID);
                entry.resend.cancel();
                StreamSet streamSet = this.getStreamSetForMessage((AbstractMessage)cMsg);
                if (streamSet == null) {
                    SIBUuid8 busId;
                    DestinationHandler dest;
                    SIBUuid8 sourceMEUuid = cMsg.getGuaranteedSourceMessagingEngineUUID();
                    if (this.sourceMap.containsValue(sourceMEUuid)) {
                        for (SIBUuid12 sid : this.sourceMap.keySet()) {
                            SIBUuid8 uuid = this.sourceMap.get(sid);
                            if (!sourceMEUuid.equals((Object)uuid)) continue;
                            if (this.destination.isLink()) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                SibTr.debug((TraceComponent)tc, (String)("WARNING: Existing Link stream, " + sid + ", not flushed"));
                                continue;
                            }
                            this.flush(sid);
                            break;
                        }
                    }
                    String linkTarget = "_PTOP_TARGET_STREAM";
                    JsDestinationAddress routingDest = cMsg.getRoutingDestination();
                    if (this.destination.isLink() && routingDest != null && (dest = this.destination.getDestinationManager().getDestinationInternal(routingDest.getDestinationName(), routingDest.getBusName(), true)) != null && dest.isPubSub()) {
                        linkTarget = routingDest.getDestinationName();
                    }
                    if ((busId = cMsg.getGuaranteedCrossBusSourceBusUUID()) == null) {
                        busId = this.messageProcessor.getMessagingEngineBusUuid();
                    }
                    streamSet = this.addNewStreamSet(streamID, sourceMEUuid, cMsg.getGuaranteedTargetDestinationDefinitionUUID(), busId, linkTarget);
                    long[] completedPrefixes = cMsg.getCompletedPrefixTicks();
                    int[] priority = cMsg.getCompletedPrefixPriority();
                    int[] reliability = cMsg.getCompletedPrefixQOS();
                    for (int i = 0; i < completedPrefixes.length; ++i) {
                        streamSet.setPersistentData(priority[i], Reliability.getReliability((int)reliability[i]), completedPrefixes[i]);
                    }
                }
                for (int i = 0; i < entry.cacheIndex; ++i) {
                    this.handleMessage(entry.cache[i]);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleNotFlushedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAckExpectedMessage(ControlAckExpected cMsg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"handleAckExpectedMessage", (Object)new Object[]{cMsg});
        }
        int priority = cMsg.getPriority();
        Reliability reliability = cMsg.getReliability();
        SIBUuid12 streamID = cMsg.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSetForMessage((AbstractMessage)cMsg);
        if (streamSet == null) {
            this.handleNewStreamID((ControlMessage)cMsg);
        } else {
            TargetStream targetStream = null;
            StreamSet streamSet2 = streamSet;
            synchronized (streamSet2) {
                targetStream = (TargetStream)streamSet.getStream(priority, reliability);
                if (targetStream == null) {
                    targetStream = this.createStream(streamSet, priority, reliability, streamSet.getPersistentData(priority, reliability));
                }
            }
            long tickValue = cMsg.getTick();
            targetStream.processAckExpected(tickValue);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleAckExpectedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSilenceMessage(ControlSilence cMsg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"handleSilenceMessage", (Object)new Object[]{cMsg});
        }
        int priority = cMsg.getPriority();
        Reliability reliability = cMsg.getReliability();
        SIBUuid12 streamID = cMsg.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSetForMessage((AbstractMessage)cMsg);
        if (streamSet == null) {
            this.handleNewStreamID((ControlMessage)cMsg);
        } else {
            TargetStream targetStream = null;
            StreamSet streamSet2 = streamSet;
            synchronized (streamSet2) {
                targetStream = (TargetStream)streamSet.getStream(priority, reliability);
                if (targetStream == null) {
                    targetStream = this.createStream(streamSet, priority, reliability, streamSet.getPersistentData(priority, reliability));
                }
            }
            targetStream.writeSilence(cMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleSilenceMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconstituteStreamSet(StreamSet streamSet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reconstituteStreamSet", (Object)streamSet);
        }
        Index index = this.streamSets;
        synchronized (index) {
            this.streamSets.put(streamSet.getStreamID(), streamSet);
            this.sourceMap.put(streamSet.getStreamID(), streamSet.getRemoteMEUuid());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteStreamSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object alarmContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm", (Object)alarmContext);
        }
        SIBUuid12 sid = (SIBUuid12)alarmContext;
        HashMap<SIBUuid12, FlushQueryRecord> hashMap = this.flushMap;
        synchronized (hashMap) {
            block12: {
                FlushQueryRecord entry = this.flushMap.get(sid);
                if (entry != null) {
                    --entry.attempts;
                    if (entry.attempts > 0) {
                        try {
                            if (entry.cache == null) {
                                this.upControl.sendRequestFlushMessage(entry.source, entry.destId, entry.busId, entry.requestID, sid, false);
                                break block12;
                            }
                            this.upControl.sendAreYouFlushedMessage(entry.source, entry.destId, entry.busId, entry.requestID, sid);
                        }
                        catch (SIResourceException e) {
                            this.flushMap.remove(sid);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                SibTr.event((TraceComponent)tc, (String)("Flush query failed for stream: " + sid));
                            }
                            break block12;
                        }
                    }
                    this.flushMap.remove(sid);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)("Flush query expired for stream: " + sid));
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    public boolean isEmpty() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isEmpty");
            SibTr.exit((TraceComponent)tc, (String)"isEmpty", (Object)new Object[]{this.streamSets.isEmpty(), this.flushedStreamSets.isEmpty(), this.streamSets, this});
        }
        return this.streamSets.isEmpty() && this.flushedStreamSets.isEmpty();
    }

    public SIMPIterator getTargetStreamSetControlIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTargetStreamSetControlIterator");
        }
        TargetStreamSetControllableIterator itr = new TargetStreamSetControllableIterator((Iterator)this.streamSets.iterator(), this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTargetStreamSetControlIterator", (Object)itr);
        }
        return itr;
    }

    @Override
    public void batchPrecommit(TransactionCommon currentTran) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchCommitted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"batchCommitted");
        }
        List<StreamSet> list = this.flushedStreamSets;
        synchronized (list) {
            Iterator<StreamSet> itr = this.flushedStreamSets.iterator();
            while (itr.hasNext()) {
                StreamSet streamSet = itr.next();
                try {
                    streamSet.remove();
                    itr.remove();
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.TargetStreamManager.batchCommitted", (String)"1:1297:1.69", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"batchCommitted", (Object)"SIErrorException");
                    }
                    throw new SIErrorException((Throwable)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"batchCommitted");
        }
    }

    @Override
    public void batchRolledBack() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryUnflushedStreams() throws SIResourceException {
        Index index = this.streamSets;
        synchronized (index) {
            SIMPIterator i = this.streamSets.iterator();
            while (i.hasNext()) {
                StreamSet next = (StreamSet)i.next();
                this.upControl.sendAreYouFlushedMessage(next.getRemoteMEUuid(), next.getDestUuid(), next.getBusUuid(), -1L, next.getStreamID());
            }
        }
    }

    public DestinationHandler getDestinationHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestinationHandler");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHandler", (Object)this.destination);
        }
        return this.destination;
    }

    protected class FlushQueryRecord {
        public SIBUuid8 source;
        public SIBUuid12 destId;
        public SIBUuid8 busId;
        public MessageItem[] cache;
        public int cacheIndex;
        public Alarm resend;
        public int attempts;
        public long requestID;

        public FlushQueryRecord(SIBUuid8 C, SIBUuid12 D, SIBUuid8 B, long I) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"FlushQueryRecord", (Object)new Object[]{C, D, B, I});
            }
            this.source = C;
            this.destId = D;
            this.busId = B;
            this.requestID = I;
            this.cache = null;
            this.attempts = 10;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"FlushQueryRecord", (Object)this);
            }
        }

        public FlushQueryRecord(SIBUuid8 C, SIBUuid12 D, SIBUuid8 B, MessageItem M, long I) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"FlushQueryRecord", (Object)new Object[]{C, D, B, M, I});
            }
            this.source = C;
            this.destId = D;
            this.busId = B;
            this.cache = new MessageItem[10];
            this.cacheIndex = 0;
            this.requestID = I;
            this.attempts = 3;
            if (M != null) {
                this.append(M);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"FlushQueryRecord", (Object)this);
            }
        }

        public synchronized void append(MessageItem M) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"append", (Object)new Object[]{M});
            }
            if (this.cacheIndex < this.cache.length && M != null) {
                this.cache[this.cacheIndex++] = M;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"append");
            }
        }
    }

    private static final class TargetStreamSetControllableIterator
    extends BasicSIMPIterator {
        private TargetStreamManager tsm;

        public TargetStreamSetControllableIterator(Iterator parent, TargetStreamManager tsm) {
            super(parent);
            this.tsm = tsm;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"TargetStreamSetControllableIterator", (Object)new Object[]{parent, tsm});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"TargetStreamSetControllableIterator", (Object)this);
            }
        }

        @Override
        public Object next() {
            StreamSet targetStreamSet;
            SIMPInboundReceiverControllable targetStreamSetControl;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"next");
            }
            if ((targetStreamSetControl = (SIMPInboundReceiverControllable)(targetStreamSet = (StreamSet)super.next()).getControlAdapter()) != null) {
                ((TargetStreamSetControl)targetStreamSetControl).setTargetStreamManager(this.tsm);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"next", (Object)targetStreamSetControl);
            }
            return targetStreamSetControl;
        }
    }
}

