/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.SourceStream;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.HealthStateListener;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.runtime.impl.InternalOutputStreamControl;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InternalOutputStream
extends ControllableStream {
    private UpstreamControl upControl;
    private static TraceComponent tc = SibTr.register(InternalOutputStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private int priority;
    private Reliability reliability;
    private DownstreamControl downControl;
    private long totalMessagesSent = 0L;
    private long timeLastMsgSent = 0L;
    private SIBUuid12 streamID;
    private StateStream oststream;
    private long oack = 0L;
    private long ack = 0L;
    private long lastSent = 0L;
    private final SourceStream.SourceStreamState internalOutputState = SourceStream.SourceStreamState.ACTIVE;
    private StreamSet streamSet;
    private long lastAckExpTick;
    private long lastNackReceivedTick;
    private final HashMap<TickRange, Integer> gapMap = new HashMap();
    private long _lastTickWhenStreamCreated;
    private long _streamStartTick;
    private BlockedStreamAlarm blockedStreamAlarm;
    private MessageProcessor messageProcessor;
    private MPAlarmManager am;
    private InternalOutputStreamControl srcStreamControl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalOutputStream(int priority, Reliability reliability, long completedPrefix, DownstreamControl downControl, UpstreamControl upControl, List scratch, SIBUuid12 stream, StreamSet streamSet, MPAlarmManager am, MessageProcessor mp, long LastMessageTickWhenStreamCreated) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"InternalOutputStream", (Object)new Object[]{priority, reliability, completedPrefix, downControl, upControl, scratch, stream, streamSet, am, mp, LastMessageTickWhenStreamCreated});
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            this.streamSet = streamSet;
            this.priority = priority;
            this.reliability = reliability;
            this.downControl = downControl;
            this.upControl = upControl;
            this.streamID = stream;
            this.am = am;
            this.messageProcessor = mp;
            this.oststream = new StateStream();
            this.oststream.init();
            this.oststream.setCompletedPrefix(completedPrefix);
            this._lastTickWhenStreamCreated = LastMessageTickWhenStreamCreated;
            this._streamStartTick = completedPrefix;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"InternalOutputStream", (Object)this);
        }
    }

    public boolean hasMsgsOnStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasMsgsOnStream");
        }
        boolean hasMsgs = false;
        this.oststream.setCursor(0L);
        TickRange tr = this.oststream.getNext();
        while (tr.endstamp < Long.MAX_VALUE) {
            if (tr.type == 3 || tr.type == 2) {
                hasMsgs = true;
                break;
            }
            tr = this.oststream.getNext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasMsgsOnStream", (Object)hasMsgs);
        }
        return hasMsgs;
    }

    @Override
    public long getCompletedPrefix() {
        long returnLong = this.oststream.getCompletedPrefix();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCompletedPrefix");
            SibTr.exit((TraceComponent)tc, (String)"getCompletedPrefix", (Object)returnLong);
        }
        return returnLong;
    }

    @Override
    public int getPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPriority");
            SibTr.exit((TraceComponent)tc, (String)"getPriority", (Object)this.priority);
        }
        return this.priority;
    }

    @Override
    public Reliability getReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReliability");
            SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)this.reliability);
        }
        return this.reliability;
    }

    public long getAckPrefix() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAckPrefix");
            SibTr.exit((TraceComponent)tc, (String)"getAckPrefix", (Object)this.oack);
        }
        return this.oack;
    }

    public void setLastSent(long sentTick) {
        if (sentTick > this.lastSent) {
            this.lastSent = sentTick;
        }
    }

    public void sendSilence(long starts, long completedPrefix) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendSilence", (Object)starts);
        }
        if (this.ack < starts - 1L) {
            long prev = this.oststream.discoverPrevCompleted(starts);
            if (prev < this.ack + 1L) {
                prev = this.ack + 1L;
            }
            if (prev < starts) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("send Silence from: " + prev + " to " + (starts - 1L) + " on Stream " + this.streamID));
                    }
                    this.downControl.sendSilenceMessage(prev, starts - 1L, completedPrefix, false, this.priority, this.reliability, this.streamID);
                }
                catch (SIResourceException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.sendSilence", (String)"1:433:1.83.1.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"sendSilence", (Object)((Object)e));
                    }
                    throw e;
                }
                this.setLastSent(starts - 1L);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendSilence");
        }
    }

    @Override
    public StateStream getStateStream() {
        return this.oststream;
    }

    public synchronized long getTotalMessagesSent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTotalMessagesSent");
            SibTr.exit((TraceComponent)tc, (String)"getTotalMessagesSent", (Object)this.totalMessagesSent);
        }
        return this.totalMessagesSent;
    }

    public InternalOutputStreamControl getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
        }
        if (this.srcStreamControl == null) {
            this.srcStreamControl = new InternalOutputStreamControl(this, this.streamSet, this.downControl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.srcStreamControl);
        }
        return this.srcStreamControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeValue(SIMPMessage m) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeValue", (Object)new Object[]{m});
        }
        TickRange tr = null;
        long msgStoreId = -1L;
        try {
            if (m.isInStore()) {
                msgStoreId = m.getID();
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.writeValue", (String)"1:513:1.83.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeValue", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        JsMessage jsMsg = m.getMessage();
        long stamp = jsMsg.getGuaranteedValueValueTick();
        boolean sendMessage = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeValue at: " + stamp + " on Stream " + this.streamID));
        }
        if (stamp > this.lastSent) {
            ++this.totalMessagesSent;
            this.timeLastMsgSent = System.currentTimeMillis();
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            if (stamp > this.oststream.getCompletedPrefix()) {
                if (jsMsg.getGuaranteedValueRequestedOnly() && !this.oststream.isRequested(stamp)) {
                    sendMessage = false;
                }
                tr = TickRange.newValueTick(stamp, null, msgStoreId);
                this.oststream.writeRange(tr);
                if (sendMessage && this.blockedStreamAlarm != null) {
                    this.blockedStreamAlarm.checkState(false);
                }
            } else {
                sendMessage = false;
            }
        }
        if (sendMessage) {
            this.setLastSent(jsMsg.getGuaranteedValueEndTick());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeValue", (Object)sendMessage);
        }
        return sendMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUncommitted(SIMPMessage m) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeUncommitted", (Object)new Object[]{m});
        }
        TickRange tr = null;
        JsMessage jsMsg = m.getMessage();
        long stamp = jsMsg.getGuaranteedValueValueTick();
        long starts = jsMsg.getGuaranteedValueStartTick();
        long ends = jsMsg.getGuaranteedValueEndTick();
        tr = TickRange.newUncommittedTick(stamp);
        tr.startstamp = starts;
        tr.endstamp = ends;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeUncommitted at: " + stamp + " with Silence from: " + starts + " to " + ends + " on Stream " + this.streamID));
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            this.oststream.writeCombinedRange(tr);
            long completedPrefix = this.oststream.getCompletedPrefix();
            this.sendSilence(starts, completedPrefix);
            if (this.blockedStreamAlarm == null) {
                this.blockedStreamAlarm = new BlockedStreamAlarm(this, this.getCompletedPrefix());
                this.am.create(10000L, this.blockedStreamAlarm);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeUncommitted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeSilence(SIMPMessage m) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilence", (Object)new Object[]{m});
        }
        JsMessage jsMsg = m.getMessage();
        long stamp = jsMsg.getGuaranteedValueValueTick();
        long starts = jsMsg.getGuaranteedValueStartTick();
        long ends = jsMsg.getGuaranteedValueEndTick();
        if (ends < stamp) {
            ends = stamp;
        }
        TickRange tr = new TickRange(7, starts, ends);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeSilence from: " + starts + " to " + ends + " on Stream " + this.streamID));
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            tr = this.oststream.writeCompletedRange(tr);
            long completedPrefix = this.oststream.getCompletedPrefix();
            if (completedPrefix > this.oack) {
                this.oack = completedPrefix;
            }
            if (this.lastSent > ends) {
                this.sendSilence(ends + 1L, completedPrefix);
            }
            if (this.blockedStreamAlarm != null) {
                this.blockedStreamAlarm.checkState(false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilence");
        }
        this.setLastSent(jsMsg.getGuaranteedValueEndTick());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSilence(ControlSilence m) throws SIResourceException {
        long completedPrefix;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilence", (Object)new Object[]{m});
        }
        boolean sendMessage = false;
        long starts = m.getStartTick();
        long ends = m.getEndTick();
        boolean requestedOnly = m.getRequestedOnly();
        TickRange tr = new TickRange(7, starts, ends);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeSilence from: " + starts + " to " + ends + " on Stream " + this.streamID));
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            if (requestedOnly && !this.oststream.containsRequested(tr)) {
                sendMessage = false;
            }
            tr = this.oststream.writeCompletedRange(tr);
            if (this.oststream.getCompletedPrefix() > this.oack) {
                this.oack = this.oststream.getCompletedPrefix();
            }
            completedPrefix = this.oststream.getCompletedPrefix();
        }
        if (sendMessage) {
            try {
                this.downControl.sendSilenceMessage(tr.startstamp, tr.endstamp, completedPrefix, requestedOnly, this.priority, this.reliability, this.streamID);
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.writeSilence", (String)"1:788:1.83.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"writeSilence", (Object)((Object)e));
                }
                throw e;
            }
            this.setLastSent(tr.endstamp);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilence", (Object)sendMessage);
        }
    }

    public void processAckExpected(long stamp) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAckExpected", (Object)new Object[]{stamp});
        }
        if (this.oack < stamp) {
            try {
                this.downControl.sendAckExpectedMessage(stamp, this.priority, this.reliability, this.streamID);
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.processAckExpected", (String)"1:828:1.83.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processAckExpected", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAckPrefix(long stamp) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeAckPrefix", (Object)stamp);
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            if (stamp >= this.lastAckExpTick) {
                this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.ACK_EXPECTED_STATE, 2);
                this.lastAckExpTick = Long.MAX_VALUE;
            }
            if (stamp >= this.lastNackReceivedTick) {
                this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.NACK_RECEIVED_STATE, 2);
                this.lastNackReceivedTick = Long.MAX_VALUE;
            }
            if (stamp > this.ack) {
                this.ack = stamp;
            }
            this.oststream.setCompletedPrefix(stamp);
            long newCompletedPrefix = this.oststream.getCompletedPrefix();
            if (newCompletedPrefix > this.oack) {
                this.oack = newCompletedPrefix;
                this.upControl.sendAckMessage(null, null, null, newCompletedPrefix, this.priority, this.reliability, this.streamID, false);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeAckPrefix");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List processNack(ControlNack nm) throws SIResourceException {
        long completedPrefix;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNack", (Object)new Object[]{nm, false});
        }
        boolean sendPending = false;
        ArrayList<TickRange> sendList = new ArrayList<TickRange>();
        boolean sendLeadingSilence = false;
        long lsstart = 0L;
        long lsend = 0L;
        boolean sendTrailingSilence = false;
        long tsstart = 0L;
        long tsend = 0L;
        long startstamp = nm.getStartTick();
        long endstamp = nm.getEndTick();
        TickRange r = null;
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.NACK_RECEIVED_STATE, 1);
            this.lastNackReceivedTick = endstamp;
            completedPrefix = this.oststream.getCompletedPrefix();
            if (startstamp <= completedPrefix) {
                sendLeadingSilence = true;
                lsstart = startstamp;
                lsend = completedPrefix;
                startstamp = completedPrefix + 1L;
            }
            if (endstamp > completedPrefix) {
                this.oststream.setCursor(startstamp);
                TickRange tr = this.oststream.getNext();
                TickRange tr2 = null;
                while (tr.startstamp <= endstamp && tr != tr2) {
                    if (tr.type == 0 || tr.type == 1) {
                        TickRange ctr;
                        long ss = InternalOutputStream.max(tr.startstamp, startstamp);
                        long es = InternalOutputStream.min(endstamp, tr.endstamp);
                        TickRange ntr = new TickRange(1, ss, es);
                        if (tr.type == 0) {
                            this.oststream.writeRange(ntr);
                        }
                        long sourceStream_completedPrefix = this.upControl.sendNackMessageWithReturnValue(null, null, null, ss, es, this.priority, this.reliability, this.streamID);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("sourceStream_completedPrefix : " + sourceStream_completedPrefix + "  es :" + es));
                        }
                        if (es <= sourceStream_completedPrefix) {
                            ctr = new TickRange(7, ss, es);
                            this.writeSilenceForced(ctr);
                            this.downControl.sendSilenceMessage(ss, es, this.oststream.getCompletedPrefix(), true, nm.getPriority(), nm.getReliability(), this.streamID);
                        } else if (sourceStream_completedPrefix != -1L) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"NACK Range is Unknown and greater than completed prefix ");
                            }
                            if (this.oststream.getCompletedPrefix() <= this._lastTickWhenStreamCreated) {
                                if (this.gapMap.get(tr) == null) {
                                    if (tr.startstamp > this._streamStartTick && tr.endstamp <= this._lastTickWhenStreamCreated) {
                                        this.gapMap.put(tr, new Integer(1));
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            SibTr.debug((TraceComponent)tc, (String)("Adding Tickrange object into Gap map : " + Integer.toHexString(tr.hashCode())));
                                        }
                                    }
                                } else if (this.gapMap.get(tr) > 9) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)"Reached max nack tolerance(10) for mesages in gap ");
                                    }
                                    ctr = new TickRange(7, ss, es);
                                    this.writeSilenceForced(ctr);
                                    this.downControl.sendSilenceMessage(ss, es, this.oststream.getCompletedPrefix(), true, nm.getPriority(), nm.getReliability(), this.streamID);
                                    this.gapMap.remove(tr);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)("Removing TickRange object from Gap map : " + Integer.toHexString(tr.hashCode())));
                                    }
                                } else {
                                    this.gapMap.put(tr, new Integer(this.gapMap.get(tr) + 1));
                                }
                            } else {
                                this.gapMap.clear();
                            }
                        }
                    } else {
                        this.removeTickRangeObjectFromHashmap(tr);
                        if (tr.type == 3) {
                            if (sendPending) {
                                sendList.add(r);
                            }
                            r = (TickRange)tr.clone();
                            sendPending = true;
                        } else if (tr.type == 2 && sendPending) {
                            if (tr.valuestamp > r.valuestamp + 1L) {
                                r.endstamp = tr.valuestamp - 1L;
                            }
                            sendList.add(r);
                            sendPending = false;
                        }
                    }
                    tr2 = tr;
                    tr = this.oststream.getNext();
                }
                if (tr2 != null && tr2.type == 7) {
                    if (sendPending) {
                        r.endstamp = tr2.endstamp;
                    } else {
                        sendTrailingSilence = true;
                        tsstart = tr2.startstamp;
                        tsend = tr2.endstamp;
                    }
                }
                if (sendPending) {
                    sendList.add(r);
                }
            }
        }
        if (sendLeadingSilence) {
            try {
                this.downControl.sendSilenceMessage(lsstart, lsend, completedPrefix, true, nm.getPriority(), nm.getReliability(), this.streamID);
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.processNack", (String)"1:1096:1.83.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (sendList.size() != 0) {
            List expiredMsgs = null;
            try {
                expiredMsgs = this.downControl.sendValueMessages(sendList, this.getCompletedPrefix(), true, this.priority, this.reliability, this.streamID);
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.processNack", (String)"1:1129:1.83.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)((Object)e));
                }
                throw e;
            }
            if (expiredMsgs != null) {
                TickRange vtr = null;
                for (int i = 0; i < expiredMsgs.size(); ++i) {
                    vtr = (TickRange)expiredMsgs.get(i);
                    this.writeSilenceForced(vtr);
                }
            }
        }
        if (sendTrailingSilence) {
            try {
                this.downControl.sendSilenceMessage(tsstart, tsend, completedPrefix, true, nm.getPriority(), nm.getReliability(), this.streamID);
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.processNack", (String)"1:1172:1.83.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTickRangeObjectFromHashmap(TickRange tr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeTickRangeObjectFromHashmap", (Object)new Object[]{tr});
        }
        if (this.gapMap.isEmpty()) {
            return;
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            block10: {
                Object[] trArray;
                block9: {
                    if (this.oststream.getCompletedPrefix() >= this._lastTickWhenStreamCreated) {
                        this.gapMap.clear();
                        return;
                    }
                    if (this.gapMap.remove(tr) == null) break block9;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    SibTr.debug((TraceComponent)tc, (String)("Removing Tr object from Hashmap : " + Integer.toHexString(tr.hashCode())));
                    break block10;
                }
                for (Object trFromHashmap : trArray = this.gapMap.entrySet().toArray()) {
                    TickRange TrObjFromHashMap = (TickRange)((Map.Entry)trFromHashmap).getKey();
                    if (tr.startstamp == TrObjFromHashMap.startstamp) {
                        this.gapMap.remove(TrObjFromHashMap);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                        SibTr.debug((TraceComponent)tc, (String)("Removing Tr object from Hashmap : " + Integer.toHexString(tr.hashCode())));
                        break;
                    }
                    if (TrObjFromHashMap.endstamp == Long.MAX_VALUE || tr.startstamp <= TrObjFromHashMap.startstamp || tr.startstamp >= TrObjFromHashMap.endstamp) continue;
                    this.gapMap.remove(TrObjFromHashMap);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    SibTr.debug((TraceComponent)tc, (String)("Removing Tr object from Hashmap : " + Integer.toHexString(tr.hashCode())));
                    break;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeTickRangeObjectFromHashmap");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMemory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"releaseMemory");
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            this.oststream = new StateStream();
            this.oststream.init();
            this.oststream.setCompletedPrefix(this.oack);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"releaseMemory");
        }
    }

    protected static long max(long a, long b) {
        return a > b ? a : b;
    }

    protected static long min(long a, long b) {
        return a < b ? a : b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSilenceForced(TickRange vtr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilenceForced", (Object)new Object[]{vtr});
        }
        long start = vtr.startstamp;
        long end = vtr.endstamp;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeSilenceForced from: " + start + " to " + end + " on Stream " + this.streamID));
        }
        TickRange tr = new TickRange(7, start, end);
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            tr = this.oststream.writeCompletedRangeForced(tr);
            try {
                if (tr.startstamp == 0L) {
                    this.writeAckPrefix(tr.endstamp);
                }
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.writeSilenceForced", (String)"1:1273:1.83.1.1", (Object)this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceForced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSilenceForced(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilenceForced", (Object)tick);
        }
        TickRange tr = null;
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            this.oststream.setCursor(tick);
            tr = this.oststream.getNext();
            if (tr != null) {
                this.writeSilenceForced(tr);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceForced");
        }
    }

    public synchronized List<TickRange> getAllMessageItemsOnStream(boolean includeUncommitted) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllMessageItemsOnStream", (Object)includeUncommitted);
        }
        LinkedList<TickRange> msgs = new LinkedList<TickRange>();
        this.oststream.setCursor(0L);
        TickRange tr = this.oststream.getNext();
        while (tr.endstamp < Long.MAX_VALUE) {
            if (tr.type == 3) {
                msgs.add((TickRange)tr.clone());
            } else if (tr.type == 2 && includeUncommitted && tr.value != null) {
                msgs.add((TickRange)tr.clone());
            }
            tr = this.oststream.getNext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllMessageItemsOnStream", msgs);
        }
        return Collections.unmodifiableList(msgs);
    }

    public synchronized long countAllMessagesOnStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"countAllMessagesOnStream");
        }
        long count = 0L;
        this.oststream.setCursor(0L);
        TickRange tr = this.oststream.getNext();
        while (tr.endstamp < Long.MAX_VALUE) {
            if (tr.type == 3) {
                ++count;
            }
            tr = this.oststream.getNext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"countAllMessagesOnStream", (Object)count);
        }
        return count;
    }

    public SourceStream.SourceStreamState getStreamState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)this.internalOutputState);
        }
        return this.internalOutputState;
    }

    public long getLastMsgSentTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLastMsgSentTime");
            SibTr.exit((TraceComponent)tc, (String)"getLastMsgSentTime", (Object)this.timeLastMsgSent);
        }
        return this.timeLastMsgSent;
    }

    public synchronized void setLatestAckExpected(long ackExpStamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setLatestAckExpected", (Object)ackExpStamp);
            SibTr.entry((TraceComponent)tc, (String)"setLatestAckExpected");
        }
        this.lastAckExpTick = ackExpStamp;
    }

    public class BlockedStreamAlarm
    implements AlarmListener {
        private final InternalOutputStream sourceStream;
        private long previousCompletedPrefix;

        public BlockedStreamAlarm(InternalOutputStream sourceStream, long completedPrefix) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"BlockedStreamAlarm", (Object)sourceStream);
            }
            this.sourceStream = sourceStream;
            this.previousCompletedPrefix = completedPrefix;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"BlockedStreamAlarm", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkState(boolean create) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"checkState", (Object)create);
            }
            InternalOutputStream internalOutputStream = this.sourceStream;
            synchronized (internalOutputStream) {
                if (InternalOutputStream.this.hasMsgsOnStream()) {
                    long completedPrefix = InternalOutputStream.this.getCompletedPrefix();
                    InternalOutputStream.this.oststream.setCursor(completedPrefix + 1L);
                    if (((InternalOutputStream)InternalOutputStream.this).oststream.getNext().type == 2 && completedPrefix == this.previousCompletedPrefix) {
                        InternalOutputStream.this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.BLOCKED_STREAM_STATE, 1);
                    } else {
                        this.previousCompletedPrefix = completedPrefix;
                        InternalOutputStream.this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.BLOCKED_STREAM_STATE, 2);
                    }
                    if (create) {
                        InternalOutputStream.this.am.create(10000L, this);
                    }
                } else {
                    if (create) {
                        InternalOutputStream.this.blockedStreamAlarm = null;
                    }
                    InternalOutputStream.this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.BLOCKED_STREAM_STATE, 2);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkState");
            }
        }

        public void alarm(Object thandle) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)thandle);
            }
            this.checkState(true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }
}

