/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.net.ssl.HostnameVerifier;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.microprofile.client.CxfTypeSafeClientBuilder;
import org.apache.cxf.microprofile.client.config.ConfigFacade;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.rest.client.inject.RestClient;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class RestClientBean
implements Bean<Object>,
PassivationCapable {
    public static final String REST_URL_FORMAT = "%s/mp-rest/url";
    public static final String REST_URI_FORMAT = "%s/mp-rest/uri";
    public static final String REST_SCOPE_FORMAT = "%s/mp-rest/scope";
    public static final String REST_PROVIDERS_FORMAT = "%s/mp-rest/providers";
    public static final String REST_CONN_TIMEOUT_FORMAT = "%s/mp-rest/connectTimeout";
    public static final String REST_READ_TIMEOUT_FORMAT = "%s/mp-rest/readTimeout";
    public static final String REST_PROVIDERS_PRIORITY_FORMAT = "/mp-rest/providers/%s/priority";
    public static final String REST_TRUST_STORE_FORMAT = "%s/mp-rest/trustStore";
    public static final String REST_TRUST_STORE_PASSWORD_FORMAT = "%s/mp-rest/trustStorePassword";
    public static final String REST_TRUST_STORE_TYPE_FORMAT = "%s/mp-rest/trustStoreType";
    public static final String REST_HOSTNAME_VERIFIER_FORMAT = "%s/mp-rest/hostnameVerifier";
    public static final String REST_KEY_STORE_FORMAT = "%s/mp-rest/keyStore";
    public static final String REST_KEY_STORE_PASSWORD_FORMAT = "%s/mp-rest/keyStorePassword";
    public static final String REST_KEY_STORE_TYPE_FORMAT = "%s/mp-rest/keyStoreType";
    public static final String REST_FOLLOW_REDIRECTS_FORMAT = "%s/mp-rest/followRedirects";
    public static final String REST_PROXY_ADDRESS_FORMAT = "%s/mp-rest/proxyAddress";
    public static final String QUERY_PARAM_STYLE_FORMAT = "%s/mp-rest/queryParamStyle";
    private static final Logger LOG = LogUtils.getL7dLogger(RestClientBean.class);
    private static final Default DEFAULT_LITERAL = new DefaultLiteral();
    private final Class<?> clientInterface;
    private final Class<? extends Annotation> scope;
    private final BeanManager beanManager;
    private final Map<Object, CxfTypeSafeClientBuilder> builders;
    static final long serialVersionUID = 6049704812779427012L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RestClientBean(Class<?> clientInterface, BeanManager beanManager) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "<init>", new Object[]{clientInterface, beanManager});
        }
        this.builders = new WeakHashMap<Object, CxfTypeSafeClientBuilder>();
        this.clientInterface = clientInterface;
        this.beanManager = beanManager;
        this.scope = this.readScope();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getId() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getId", new Object[0]);
        }
        String string = this.clientInterface.getName();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getId", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?> getBeanClass() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getBeanClass", new Object[0]);
        }
        Class<?> clazz = this.clientInterface;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getBeanClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<InjectionPoint> getInjectionPoints() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getInjectionPoints", new Object[0]);
        }
        Set<InjectionPoint> set = Collections.emptySet();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getInjectionPoints", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isNullable() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "isNullable", new Object[0]);
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "isNullable", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object create(CreationalContext<Object> creationalContext) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "create", new Object[]{creationalContext});
        }
        CxfTypeSafeClientBuilder builder = new CxfTypeSafeClientBuilder();
        String baseUri = this.getBaseUri();
        builder = (CxfTypeSafeClientBuilder)builder.baseUri(URI.create(baseUri));
        List<Class<?>> providers = this.getConfiguredProviders();
        Map<Class<?>, Integer> providerPriorities = this.getConfiguredProviderPriorities(providers);
        for (Class<?> providerClass : providers) {
            builder = (CxfTypeSafeClientBuilder)builder.register(providerClass, (int)providerPriorities.getOrDefault(providerClass, 5000));
        }
        this.setTimeouts(builder);
        this.setSSLConfig(builder);
        this.setFollowRedirects(builder);
        this.setProxyAddress(builder);
        this.setQueryParamStyle(builder);
        Object clientInstance = builder.build(this.clientInterface);
        this.builders.put(clientInstance, builder);
        Object obj = clientInstance;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            obj = obj;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "create", obj);
        }
        return obj;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "destroy", new Object[]{instance, creationalContext});
        }
        CxfTypeSafeClientBuilder builder = this.builders.remove(instance);
        if (builder != null) {
            builder.close();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "destroy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<Type> getTypes() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getTypes", new Object[0]);
        }
        Set<Type> set = Collections.singleton(this.clientInterface);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getTypes", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<Annotation> getQualifiers() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getQualifiers", new Object[0]);
        }
        HashSet<Annotation> hashSet = new HashSet<Annotation>(Arrays.asList(DEFAULT_LITERAL, RestClient.RestClientLiteral.LITERAL));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getQualifiers", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<? extends Annotation> getScope() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getScope", new Object[0]);
        }
        Class<? extends Annotation> clazz = this.scope;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getScope", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getName", new Object[0]);
        }
        String string = this.clientInterface.getName();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<Class<? extends Annotation>> getStereotypes() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getStereotypes", new Object[0]);
        }
        Set<Class<? extends Annotation>> set = Collections.emptySet();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getStereotypes", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isAlternative() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "isAlternative", new Object[0]);
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "isAlternative", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getBaseUri() {
        String annoUri;
        RegisterRestClient anno;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getBaseUri", new Object[0]);
        }
        String interfaceName = this.clientInterface.getName();
        String baseURI = ConfigFacade.getOptionalValue(REST_URI_FORMAT, this.clientInterface, String.class).orElseGet(() -> ConfigFacade.getOptionalValue(REST_URL_FORMAT, this.clientInterface, String.class).orElse(null));
        if (baseURI == null && (anno = this.clientInterface.getAnnotation(RegisterRestClient.class)) != null && (annoUri = anno.baseUri()) != null && !"".equals(anno.baseUri())) {
            baseURI = annoUri;
        }
        if (baseURI == null) {
            throw new IllegalStateException("Unable to determine base URI from configuration for " + interfaceName);
        }
        String string = baseURI;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getBaseUri", string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Class<? extends Annotation> readScope() {
        Annotation[] annotations;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "readScope", new Object[0]);
        }
        String configuredScope = ConfigFacade.getOptionalValue(REST_SCOPE_FORMAT, this.clientInterface, String.class).orElse(null);
        if (configuredScope != null) {
            Class clazz;
            block9: {
                try {
                    clazz = ClassLoaderUtils.loadClass((String)configuredScope, this.getClass(), Annotation.class);
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block9;
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.microprofile.client.cdi.RestClientBean", (String)"206", (Object)this, (Object[])new Object[0]);
                    throw new IllegalArgumentException("The scope " + configuredScope + " is invalid", (Throwable)e);
                }
                clazz = clazz;
                LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "readScope", clazz);
            }
            return clazz;
        }
        ArrayList<Annotation> possibleScopes = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = this.clientInterface.getDeclaredAnnotations()) {
            if (!this.beanManager.isScope(annotation.annotationType())) continue;
            possibleScopes.add(annotation);
        }
        if (possibleScopes.isEmpty()) {
            Class<Dependent> clazz = Dependent.class;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "readScope", clazz);
            }
            return clazz;
        }
        if (possibleScopes.size() == 1) {
            Class<? extends Annotation> clazz = ((Annotation)possibleScopes.get(0)).annotationType();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "readScope", clazz);
            }
            return clazz;
        }
        throw new IllegalArgumentException("The client interface " + this.clientInterface + " has multiple scopes defined " + possibleScopes);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    List<Class<?>> getConfiguredProviders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getConfiguredProviders", new Object[0]);
        }
        String providersList = ConfigFacade.getOptionalValue(REST_PROVIDERS_FORMAT, this.clientInterface, String.class).orElse(null);
        ArrayList providers = new ArrayList();
        if (providersList != null) {
            String[] providerClassNames = providersList.split(",");
            for (int i = 0; i < providerClassNames.length; ++i) {
                try {
                    providers.add(ClassLoaderUtils.loadClass((String)providerClassNames[i], RestClientBean.class));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"org.apache.cxf.microprofile.client.cdi.RestClientBean", (String)"237", (Object)this, (Object[])new Object[0]);
                    LOG.log(Level.WARNING, "Could not load provider, {0}, configured for Rest Client interface, {1} ", new Object[]{providerClassNames[i], this.clientInterface.getName()});
                }
            }
        }
        ArrayList arrayList = providers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getConfiguredProviders", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Map<Class<?>, Integer> getConfiguredProviderPriorities(List<Class<?>> providers) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getConfiguredProviderPriorities", new Object[]{providers});
        }
        HashMap map = new HashMap();
        for (Class<?> providerClass : providers) {
            String propertyFormat = "%s" + String.format(REST_PROVIDERS_PRIORITY_FORMAT, providerClass.getName());
            Integer priority = ConfigFacade.getOptionalValue(propertyFormat, this.clientInterface, Integer.class).orElse(RestClientBean.getPriorityFromClass(providerClass, 5000));
            map.put(providerClass, priority);
        }
        HashMap hashMap = map;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashMap = hashMap;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getConfiguredProviderPriorities", hashMap);
        }
        return hashMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static int getPriorityFromClass(Class<?> providerClass, int defaultValue) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getPriorityFromClass", new Object[]{providerClass, defaultValue});
        }
        Priority p = providerClass.getAnnotation(Priority.class);
        int n = p != null ? p.value() : defaultValue;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getPriorityFromClass", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setTimeouts(CxfTypeSafeClientBuilder builder) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "setTimeouts", new Object[]{builder});
        }
        ConfigFacade.getOptionalLong(REST_CONN_TIMEOUT_FORMAT, this.clientInterface).ifPresent(timeoutValue -> {
            builder.connectTimeout(timeoutValue, TimeUnit.MILLISECONDS);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("readTimeout set by MP Config: " + timeoutValue);
            }
        });
        ConfigFacade.getOptionalLong(REST_READ_TIMEOUT_FORMAT, this.clientInterface).ifPresent(timeoutValue -> {
            builder.readTimeout(timeoutValue, TimeUnit.MILLISECONDS);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("readTimeout set by MP Config: " + timeoutValue);
            }
        });
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "setTimeouts");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setFollowRedirects(CxfTypeSafeClientBuilder builder) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "setFollowRedirects", new Object[]{builder});
        }
        ConfigFacade.getOptionalValue(REST_FOLLOW_REDIRECTS_FORMAT, this.clientInterface, String.class).ifPresent(follows -> {
            builder.followRedirects(PropertyUtils.isTrue((Object)follows));
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("followRedirect set by MP Config: " + follows);
            }
        });
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "setFollowRedirects");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setProxyAddress(CxfTypeSafeClientBuilder builder) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "setProxyAddress", new Object[]{builder});
        }
        ConfigFacade.getOptionalValue(REST_PROXY_ADDRESS_FORMAT, this.clientInterface, String.class).ifPresent(address -> {
            String[] split = address.split(":");
            if (split.length != 2) {
                throw new IllegalStateException(String.format("Invalid proxy server address configured for %s: %s", this.clientInterface.getName(), address));
            }
            try {
                String hostname = split[0];
                int port = Integer.parseInt(split[1]);
                builder.proxyAddress(hostname, port);
            }
            catch (Throwable t) {
                throw new IllegalStateException(String.format("Invalid proxy server address configured for %s: %s", this.clientInterface.getName(), address), t);
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("proxyAddress set by MP Config: " + address);
            }
        });
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "setProxyAddress");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setQueryParamStyle(CxfTypeSafeClientBuilder builder) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "setQueryParamStyle", new Object[]{builder});
        }
        ConfigFacade.getOptionalValue(QUERY_PARAM_STYLE_FORMAT, this.clientInterface, String.class).ifPresent(styleString -> {
            try {
                builder.queryParamStyle(QueryParamStyle.valueOf((String)styleString));
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("queryParamStyle set by MP Config: " + styleString);
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException(String.format("Invalid queryParamStyle value specified for %s: %s", this.clientInterface.getName(), styleString));
            }
        });
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "setQueryParamStyle");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setSSLConfig(CxfTypeSafeClientBuilder builder) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "setSSLConfig", new Object[]{builder});
        }
        ConfigFacade.getOptionalValue(REST_HOSTNAME_VERIFIER_FORMAT, this.clientInterface, String.class).ifPresent(className -> {
            try {
                Class clazz = ClassLoaderUtils.loadClassFromContextLoader((String)className);
                Constructor ctor = ReflectionUtil.getConstructor((Class)clazz, (Class[])new Class[0]);
                if (ctor != null) {
                    builder.hostnameVerifier((HostnameVerifier)ctor.newInstance(new Object[0]));
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOG.log(Level.WARNING, "INVALID_HOSTNAME_VERIFIER_CONFIGURED", new Object[]{className, this.clientInterface.getName()});
        });
        ConfigFacade.getOptionalValue(REST_TRUST_STORE_FORMAT, this.clientInterface, String.class).ifPresent(trustStoreLoc -> this.initTrustStore((String)trustStoreLoc, builder));
        ConfigFacade.getOptionalValue(REST_KEY_STORE_FORMAT, this.clientInterface, String.class).ifPresent(keyStoreLoc -> this.initKeyStore((String)keyStoreLoc, builder));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "setSSLConfig");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initTrustStore(String trustStoreLoc, CxfTypeSafeClientBuilder builder) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "initTrustStore", new Object[]{trustStoreLoc, builder});
        }
        String password = ConfigFacade.getOptionalValue(REST_TRUST_STORE_PASSWORD_FORMAT, this.clientInterface, String.class).orElse(null);
        String storeType = ConfigFacade.getOptionalValue(REST_TRUST_STORE_TYPE_FORMAT, this.clientInterface, String.class).orElse("JKS");
        try {
            KeyStore trustStore;
            block9: {
                trustStore = KeyStore.getInstance(storeType);
                try {
                    InputStream input = this.getInputStream(trustStoreLoc);
                    try {
                        trustStore.load(input, password == null ? null : password.toCharArray());
                        if (input == null) break block9;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.microprofile.client.cdi.RestClientBean", (String)"381", (Object)this, (Object[])new Object[]{trustStoreLoc, builder});
                        if (input == null) throw throwable;
                        try {
                            input.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException((Throwable)throwable2, (String)"org.apache.cxf.microprofile.client.cdi.RestClientBean", (String)"381", (Object)this, (Object[])new Object[]{trustStoreLoc, builder});
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    input.close();
                }
                catch (Throwable input) {
                    void t;
                    FFDCFilter.processException((Throwable)input, (String)"org.apache.cxf.microprofile.client.cdi.RestClientBean", (String)"383", (Object)this, (Object[])new Object[]{trustStoreLoc, builder});
                    throw new IllegalArgumentException("Failed to initialize trust store from URL, " + trustStoreLoc, (Throwable)t);
                }
            }
            builder.trustStore(trustStore);
        }
        catch (KeyStoreException trustStore) {
            void e;
            FFDCFilter.processException((Throwable)trustStore, (String)"org.apache.cxf.microprofile.client.cdi.RestClientBean", (String)"388", (Object)this, (Object[])new Object[]{trustStoreLoc, builder});
            throw new IllegalArgumentException("Failed to initialize trust store from " + trustStoreLoc, (Throwable)e);
        }
        if (LOG == null) return;
        if (!LOG.isLoggable(Level.FINER)) return;
        LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "initTrustStore");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initKeyStore(String keyStoreLoc, CxfTypeSafeClientBuilder builder) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "initKeyStore", new Object[]{keyStoreLoc, builder});
        }
        String password = ConfigFacade.getOptionalValue(REST_KEY_STORE_PASSWORD_FORMAT, this.clientInterface, String.class).orElse(null);
        String storeType = ConfigFacade.getOptionalValue(REST_KEY_STORE_TYPE_FORMAT, this.clientInterface, String.class).orElse("JKS");
        try {
            KeyStore keyStore;
            block9: {
                keyStore = KeyStore.getInstance(storeType);
                try {
                    InputStream input = this.getInputStream(keyStoreLoc);
                    try {
                        keyStore.load(input, password == null ? null : password.toCharArray());
                        if (input == null) break block9;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.microprofile.client.cdi.RestClientBean", (String)"401", (Object)this, (Object[])new Object[]{keyStoreLoc, builder});
                        if (input == null) throw throwable;
                        try {
                            input.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException((Throwable)throwable2, (String)"org.apache.cxf.microprofile.client.cdi.RestClientBean", (String)"401", (Object)this, (Object[])new Object[]{keyStoreLoc, builder});
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    input.close();
                }
                catch (Throwable input) {
                    void t;
                    FFDCFilter.processException((Throwable)input, (String)"org.apache.cxf.microprofile.client.cdi.RestClientBean", (String)"403", (Object)this, (Object[])new Object[]{keyStoreLoc, builder});
                    throw new IllegalArgumentException("Failed to initialize key store from URL, " + keyStoreLoc, (Throwable)t);
                }
            }
            builder.keyStore(keyStore, password);
        }
        catch (KeyStoreException keyStore) {
            void e;
            FFDCFilter.processException((Throwable)keyStore, (String)"org.apache.cxf.microprofile.client.cdi.RestClientBean", (String)"408", (Object)this, (Object[])new Object[]{keyStoreLoc, builder});
            throw new IllegalArgumentException("Failed to initialize key store from " + keyStoreLoc, (Throwable)e);
        }
        if (LOG == null) return;
        if (!LOG.isLoggable(Level.FINER)) return;
        LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "initKeyStore");
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    InputStream getInputStream(String location) {
        InputStream inputStream;
        block10: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getInputStream", new Object[]{location});
            }
            if (location.startsWith("classpath:")) {
                List urls = ClassLoaderUtils.getResources((String)(location = location.substring(10)), this.clientInterface);
                if (urls != null && !urls.isEmpty()) {
                    InputStream inputStream2;
                    block9: {
                        try {
                            inputStream2 = ((URL)urls.get(0)).openStream();
                            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block9;
                        }
                        catch (IOException iOException) {
                            void e;
                            FFDCFilter.processException((Throwable)iOException, (String)"org.apache.cxf.microprofile.client.cdi.RestClientBean", (String)"423", (Object)this, (Object[])new Object[]{location});
                            throw new IllegalArgumentException((Throwable)e);
                        }
                        inputStream2 = inputStream2;
                        LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getInputStream", inputStream2);
                    }
                    return inputStream2;
                }
                LOG.warning("could not find classpath:" + location);
                throw new IllegalStateException("could not find configured key/trust store: " + location);
            }
            try {
                inputStream = new URL(location).openStream();
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block10;
            }
            catch (Exception urls) {
                InputStream inputStream3;
                block11: {
                    FFDCFilter.processException((Throwable)urls, (String)"org.apache.cxf.microprofile.client.cdi.RestClientBean", (String)"433", (Object)this, (Object[])new Object[]{location});
                    try {
                        inputStream3 = new URL("file:" + location).openStream();
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block11;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.microprofile.client.cdi.RestClientBean", (String)"437", (Object)this, (Object[])new Object[]{location});
                        throw new IllegalStateException("could not find configured key/trust store URL: " + location);
                    }
                    inputStream3 = inputStream3;
                    LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getInputStream", inputStream3);
                }
                return inputStream3;
            }
            inputStream = inputStream;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getInputStream", inputStream);
        }
        return inputStream;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class DefaultLiteral
    extends AnnotationLiteral<Default>
    implements Default {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DefaultLiteral() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.microprofile.client.cdi.RestClientBean$DefaultLiteral", DefaultLiteral.class, null, null);
        }
    }
}

