/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.rest.client.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.eclipse.microprofile.faulttolerance.Timeout;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyFTTimeoutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(LibertyFTTimeoutInterceptor.class, null, null);
    static final long serialVersionUID = -8560552950055139583L;

    public LibertyFTTimeoutInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        Map filterProps = (Map)message.getExchange().get((Object)"jaxrs.filter.properties");
        if (filterProps == null) {
            return;
        }
        Method method = (Method)filterProps.get("org.eclipse.microprofile.rest.client.invokedMethod");
        if (method == null) {
            return;
        }
        Timeout timeoutAnnotation = method.getAnnotation(Timeout.class);
        if (timeoutAnnotation == null) {
            return;
        }
        Conduit conduit = message.getExchange().getConduit(message);
        if (conduit instanceof HTTPConduit) {
            HTTPConduit httpConduit = (HTTPConduit)conduit;
            long value = timeoutAnnotation.value();
            ChronoUnit unit = timeoutAnnotation.unit();
            long timeoutMillis = Duration.of(value, unit).plusMillis(2L).toMillis();
            httpConduit.getClient().setConnectionTimeout(timeoutMillis);
            httpConduit.getClient().setReceiveTimeout(timeoutMillis);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("set connection and read timeout to " + timeoutMillis), (Object[])new Object[0]);
            }
        }
    }
}

