/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang3.Validate;
import org.apache.commons.weaver.model.AnnotatedElements;
import org.apache.commons.weaver.model.WeavableClass;
import org.apache.commons.weaver.model.WeavableConstructor;
import org.apache.commons.weaver.model.WeavableConstructorParameter;
import org.apache.commons.weaver.model.WeavableField;
import org.apache.commons.weaver.model.WeavableMethod;
import org.apache.commons.weaver.model.WeavableMethodParameter;
import org.apache.commons.weaver.model.WeavablePackage;

public class ScanResult {
    private final ConcurrentNavigableMap<String, WeavablePackage> packages = new ConcurrentSkipListMap<String, WeavablePackage>();

    public WeavablePackage getWeavable(Package pkg) {
        String key = pkg.getName();
        if (this.packages.containsKey(key)) {
            return (WeavablePackage)this.packages.get(key);
        }
        WeavablePackage result = new WeavablePackage(pkg);
        WeavablePackage faster = this.packages.putIfAbsent(key, result);
        return faster == null ? result : faster;
    }

    public <T> WeavableClass<T> getWeavable(Class<T> cls) {
        return this.getWeavable(cls.getPackage()).getWeavable(cls);
    }

    public WeavableField<?> getWeavable(Field fld) {
        return this.getWeavable(fld.getDeclaringClass()).getWeavable(fld);
    }

    public WeavableMethod<?> getWeavable(Method methd) {
        return this.getWeavable(methd.getDeclaringClass()).getWeavable(methd);
    }

    public <T> WeavableConstructor<T> getWeavable(Constructor<T> ctor) {
        return this.getWeavable(ctor.getDeclaringClass()).getWeavable(ctor);
    }

    public AnnotatedElements<WeavablePackage> getPackages() {
        return new AnnotatedElements<WeavablePackage>(){

            @Override
            public Iterator<WeavablePackage> iterator() {
                return ScanResult.this.packages.values().iterator();
            }

            @Override
            public AnnotatedElements<WeavablePackage> with(Class<? extends Annotation> annotationType) {
                return new AnnotatedWith<WeavablePackage>(ScanResult.this.packages.values(), annotationType);
            }
        };
    }

    public AnnotatedElements<WeavableClass<?>> getClasses() {
        return new Projection<WeavablePackage, WeavableClass<?>>(this.getPackages()){

            @Override
            protected Iterable<WeavableClass<?>> childrenOf(WeavablePackage parent) {
                return parent.getClasses();
            }
        };
    }

    public AnnotatedElements<WeavableClass<?>> getClassesAssignableTo(final Class<?> supertype) {
        Validate.notNull(supertype, (String)"supertype", (Object[])new Object[0]);
        return new Projection<WeavablePackage, WeavableClass<?>>(this.getPackages()){

            @Override
            protected Iterable<WeavableClass<?>> childrenOf(WeavablePackage parent) {
                return parent.getClasses();
            }

            @Override
            public Iterator<WeavableClass<?>> iterator() {
                final Iterator toWrap = super.iterator();
                return new Iterator<WeavableClass<?>>(){
                    private WeavableClass<?> next;
                    {
                        this.read();
                    }

                    private void read() {
                        while (toWrap.hasNext()) {
                            WeavableClass test = (WeavableClass)toWrap.next();
                            if (!supertype.isAssignableFrom((Class)test.getTarget())) continue;
                            this.next = test;
                            return;
                        }
                        this.next = null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public WeavableClass<?> next() {
                        try {
                            WeavableClass<?> weavableClass = this.next;
                            return weavableClass;
                        }
                        finally {
                            this.read();
                        }
                    }

                    @Override
                    public void remove() {
                        toWrap.remove();
                    }
                };
            }
        };
    }

    public AnnotatedElements<WeavableField<?>> getFields() {
        return new Projection<WeavableClass<?>, WeavableField<?>>(this.getClasses()){

            @Override
            protected Iterable<WeavableField<?>> childrenOf(WeavableClass<?> parent) {
                Iterable<WeavableField<?>> result = parent.getFields();
                return result;
            }
        };
    }

    public AnnotatedElements<WeavableConstructor<?>> getConstructors() {
        return new Projection<WeavableClass<?>, WeavableConstructor<?>>(this.getClasses()){

            @Override
            protected Iterable<WeavableConstructor<?>> childrenOf(WeavableClass<?> parent) {
                Iterable<WeavableConstructor<?>> result = parent.getConstructors();
                return result;
            }
        };
    }

    public AnnotatedElements<WeavableMethod<?>> getMethods() {
        return new Projection<WeavableClass<?>, WeavableMethod<?>>(this.getClasses()){

            @Override
            protected Iterable<WeavableMethod<?>> childrenOf(WeavableClass<?> parent) {
                Iterable<WeavableMethod<?>> result = parent.getMethods();
                return result;
            }
        };
    }

    public AnnotatedElements<WeavableMethodParameter<?>> getMethodParameters() {
        return new Projection<WeavableMethod<?>, WeavableMethodParameter<?>>(this.getMethods()){

            @Override
            protected Iterable<WeavableMethodParameter<?>> childrenOf(WeavableMethod<?> parent) {
                Iterable<WeavableMethodParameter<?>> result = parent.getParameters();
                return result;
            }
        };
    }

    public AnnotatedElements<WeavableConstructorParameter<?>> getConstructorParameters() {
        return new Projection<WeavableConstructor<?>, WeavableConstructorParameter<?>>(this.getConstructors()){

            @Override
            protected Iterable<WeavableConstructorParameter<?>> childrenOf(WeavableConstructor<?> parent) {
                Iterable<WeavableConstructorParameter<?>> result = parent.getParameters();
                return result;
            }
        };
    }

    private static class AnnotatedWith<W extends AnnotatedElement>
    implements AnnotatedElements<W> {
        final Iterable<W> wrapped;
        final Class<? extends Annotation> annotationType;

        AnnotatedWith(Iterable<W> wrapped, Class<? extends Annotation> annotationType) {
            this.wrapped = wrapped;
            this.annotationType = annotationType;
        }

        @Override
        public Iterator<W> iterator() {
            final Iterator<W> iter = this.wrapped.iterator();
            return new Iterator<W>(){
                W next = this.read();

                private W read() {
                    while (iter.hasNext()) {
                        AnnotatedElement element = (AnnotatedElement)iter.next();
                        if (!element.isAnnotationPresent(AnnotatedWith.this.annotationType)) continue;
                        return element;
                    }
                    return null;
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public W next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    try {
                        Object w = this.next;
                        return w;
                    }
                    finally {
                        this.next = this.read();
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public AnnotatedElements<W> with(Class<? extends Annotation> annotationType) {
            return new AnnotatedWith<W>(this, annotationType);
        }
    }

    private static abstract class Projection<PARENT, CHILD extends AnnotatedElement>
    implements AnnotatedElements<CHILD> {
        private final Iterable<PARENT> parents;

        Projection(Iterable<PARENT> parents) {
            this.parents = parents;
        }

        protected abstract Iterable<CHILD> childrenOf(PARENT var1);

        @Override
        public Iterator<CHILD> iterator() {
            final Iterator<PARENT> parentIterator = this.parents.iterator();
            return new Iterator<CHILD>(){
                private Iterator<CHILD> children = this.nextChildren();

                @Override
                public synchronized boolean hasNext() {
                    return this.children != null;
                }

                @Override
                public synchronized CHILD next() {
                    if (this.children == null) {
                        throw new NoSuchElementException();
                    }
                    try {
                        AnnotatedElement annotatedElement = (AnnotatedElement)this.children.next();
                        return annotatedElement;
                    }
                    finally {
                        if (!this.children.hasNext()) {
                            this.children = this.nextChildren();
                        }
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private Iterator<CHILD> nextChildren() {
                    while (parentIterator.hasNext()) {
                        Iterator prospect = Projection.this.childrenOf(parentIterator.next()).iterator();
                        if (!prospect.hasNext()) continue;
                        return prospect;
                    }
                    return null;
                }
            };
        }

        @Override
        public AnnotatedElements<CHILD> with(Class<? extends Annotation> annotationType) {
            return new AnnotatedWith(this, annotationType);
        }
    }
}

